/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKey;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKeyHolder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringCloudPlugin
extends AbstractShenyuPlugin {
    private final LoadBalancerClient loadBalancer;

    public SpringCloudPlugin(LoadBalancerClient loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ServiceInstance serviceInstance;
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)selector.getId());
        SpringCloudRuleHandle ruleHandle = (SpringCloudRuleHandle)SpringCloudPluginDataHandler.RULE_CACHED.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        String serviceId = springCloudSelectorHandle.getServiceId();
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        LoadBalanceKey loadBalanceKey = new LoadBalanceKey(ip, selector.getId(), ruleHandle.getLoadBalance());
        try {
            LoadBalanceKeyHolder.setLoadBalanceKey(loadBalanceKey);
            serviceInstance = this.loadBalancer.choose(serviceId);
        }
        finally {
            LoadBalanceKeyHolder.resetLoadBalanceKey();
        }
        if (Objects.isNull(serviceInstance)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        URI uri = this.loadBalancer.reconstructURI(serviceInstance, URI.create(shenyuContext.getRealUrl()));
        this.setDomain(uri, exchange);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.SPRING_CLOUD});
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    private void setDomain(URI uri, ServerWebExchange exchange) {
        String domain = uri.getScheme() + "://" + uri.getAuthority();
        exchange.getAttributes().put("httpDomain", domain);
    }
}

