/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.SpringCloudRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.JsonReturnValueUtil;
import org.apache.shenyu.plugin.base.utils.MetaDataUtil;
import org.apache.shenyu.plugin.base.utils.ParamStructureConvertUtil;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKey;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKeyHolder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class SpringCloudPlugin
extends AbstractShenyuPlugin {
    private static final Logger log = LoggerFactory.getLogger(SpringCloudPlugin.class);
    private final LoadBalancerClient loadBalancer;
    private static final Integer LOG_MAX_LENGTH = 2048;

    public SpringCloudPlugin(LoadBalancerClient loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ServiceInstance serviceInstance;
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)selector.getId());
        SpringCloudRuleHandle ruleHandle = (SpringCloudRuleHandle)SpringCloudPluginDataHandler.RULE_CACHED.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        String serviceId = springCloudSelectorHandle.getServiceId();
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        LoadBalanceKey loadBalanceKey = new LoadBalanceKey(ip, selector.getId(), ruleHandle.getLoadBalance());
        try {
            LoadBalanceKeyHolder.setLoadBalanceKey(loadBalanceKey);
            serviceInstance = this.loadBalancer.choose(serviceId);
        }
        finally {
            LoadBalanceKeyHolder.resetLoadBalanceKey();
        }
        if (Objects.isNull(serviceInstance)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        String validateMetadataDesc = MetaDataUtil.validateMetadata((MetaData)metaData);
        if (StringUtils.isNotEmpty((CharSequence)validateMetadataDesc)) {
            log.error(validateMetadataDesc);
            return ResponseUtils.buildErrorResult((ServerWebExchange)exchange);
        }
        URI uri = this.loadBalancer.reconstructURI(serviceInstance, URI.create(this.buildRealUrl(metaData)));
        this.setDomain(uri, exchange);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        if (StrUtil.isNotEmpty((CharSequence)ruleHandle.getExtFields()) && "POST".equals(exchange.getRequest().getMethodValue())) {
            return this.reBuildReqParaAndAddRespDecorator(chain, exchange, ruleHandle);
        }
        if (StrUtil.isNotEmpty((CharSequence)ruleHandle.getResponseFields())) {
            exchange.getAttributes().put("responseRewrote", "responseRewrote");
            return chain.execute(exchange.mutate().response((ServerHttpResponse)new ModifyResponseDecorator(exchange, ruleHandle.getResponseFields())).build());
        }
        return chain.execute(exchange);
    }

    private Mono<Void> reBuildReqParaAndAddRespDecorator(ShenyuPluginChain chain, ServerWebExchange exchange, SpringCloudRuleHandle ruleHandle) {
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            String bodyString = new String(bytes, StandardCharsets.UTF_8);
            JSONObject requestPramJSON = JSONObject.parseObject((String)bodyString);
            Map extFieldMap = (Map)JSON.parseObject((String)ruleHandle.getExtFields(), Map.class);
            List extendFieldBos = ParamStructureConvertUtil.flatAndFilter((Map)extFieldMap, (JSONObject)requestPramJSON);
            if (CollectionUtils.isNotEmpty((Collection)extendFieldBos)) {
                requestPramJSON.put("extFields", (Object)extendFieldBos);
            }
            log.info("\u91cd\u65b0\u6784\u5efa\u540e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)(requestPramJSON.toJSONString().length() > LOG_MAX_LENGTH ? requestPramJSON.toJSONString().substring(0, LOG_MAX_LENGTH) : requestPramJSON.toJSONString()));
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(requestPramJSON.toJSONString().getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            headers.set("Transfer-Encoding", "chunked");
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)headers);
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            return chain.execute(exchange.mutate().request((ServerHttpRequest)mutatedRequest).response((ServerHttpResponse)new ModifyResponseDecorator(exchange, ruleHandle.getResponseFields())).build());
        });
    }

    private String buildRealUrl(MetaData metaData) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(metaData.getGroup()).append("/").append(metaData.getVersion()).append("/").append(metaData.getServiceName()).append("/").append(metaData.getMethodName());
        return urlBuilder.toString();
    }

    private void setDomain(URI uri, ServerWebExchange exchange) {
        String domain = uri.getScheme() + "://" + uri.getAuthority();
        String route = uri.getPath();
        log.info("\u771f\u5b9e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)domain);
        log.info("\u771f\u5b9e\u8c03\u7528\u8def\u7531\uff1a{}", (Object)route);
        exchange.getAttributes().put("httpDomain", domain);
        exchange.getAttributes().put("rewrite_uri", route);
    }

    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.SPRING_CLOUD});
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    static class ModifyResponseDecorator
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final String responseFields;

        ModifyResponseDecorator(ServerWebExchange exchange, String responseFields) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.responseFields = responseFields;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            ClientResponse clientResponse = this.buildModifiedResponse(body);
            Mono modifiedBody = clientResponse.bodyToMono(byte[].class).flatMap(originalBody -> Mono.just((Object)this.modifyBody((byte[])originalBody)));
            return ResponseUtils.writeWith((ClientResponse)clientResponse, (ServerWebExchange)this.exchange, (Publisher)modifiedBody, byte[].class);
        }

        private ClientResponse buildModifiedResponse(Publisher<? extends DataBuffer> body) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.addAll((MultiValueMap)this.getHeaders());
            ClientResponse clientResponse = ResponseUtils.buildClientResponse((ServerHttpResponse)this.getDelegate(), body);
            HttpStatus statusCode = clientResponse.statusCode();
            this.getDelegate().getHeaders().clear();
            this.getDelegate().getHeaders().putAll((Map)httpHeaders);
            int rowStatusCode = clientResponse.rawStatusCode();
            return ClientResponse.create((HttpStatus)statusCode).rawStatusCode(rowStatusCode).headers(headers -> headers.addAll((MultiValueMap)httpHeaders)).body(Flux.from(body)).build();
        }

        private byte[] modifyBody(byte[] responseBody) {
            try {
                String bodyStr = this.modifyBody(new String(responseBody, StandardCharsets.UTF_8));
                log.info("the body string {}", (Object)(bodyStr.length() > LOG_MAX_LENGTH ? bodyStr.substring(0, LOG_MAX_LENGTH) : bodyStr));
                return bodyStr.getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                log.error("modify response error", (Throwable)e);
                throw new ShenyuException(String.format("response modify failure. %s", e.getLocalizedMessage()));
            }
        }

        private String modifyBody(String jsonValue) {
            String newJsonValue = ParamStructureConvertUtil.toJSONString((Object)JSON.parseObject((String)jsonValue));
            if (StringUtils.isEmpty((CharSequence)this.responseFields)) {
                return JsonReturnValueUtil.buildUnifiedFormat((String)jsonValue);
            }
            Set includes = (Set)JSON.parseObject((String)this.responseFields, Set.class);
            includes.add("busiCode");
            includes.add("busiMsg");
            PropertyPreFilter propertyPreFilter = (serializer, object, name) -> {
                String replaceAll = serializer.getContext().toString().replace("$.", "").replaceAll("\\[(0|[1-9][0-9]*)]\\.", ".").replaceAll("\\[.*]", "");
                return includes.contains(name) || includes.contains(replaceAll + "." + name);
            };
            Object retObj = ParamStructureConvertUtil.flatExtField((Object)JSON.parseObject((String)newJsonValue));
            return JsonReturnValueUtil.buildUnifiedFormat((String)JSON.toJSONString((Object)retObj, (SerializeFilter)propertyPreFilter, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

