/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tars.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.GsonUtils;

public final class PrxInfoUtil {
    private static final Map<String, PrimitiveType> PRIMITIVE_TYPE = new HashMap<String, PrimitiveType>();

    private PrxInfoUtil() {
    }

    public static Class<?> getParamClass(String className) throws ClassNotFoundException {
        if (PRIMITIVE_TYPE.containsKey(className)) {
            return PRIMITIVE_TYPE.get(className).getClazz();
        }
        return Class.forName(className);
    }

    public static String getPrxName(MetaData metaData) {
        return metaData.getPath().replace("/", "") + metaData.getMethodName() + "Prx";
    }

    public static String getMethodName(String methodName) {
        return "promise_" + methodName;
    }

    public static String getObjectName(String upstreamUrl, String serviceName) {
        String[] ipAndPort = upstreamUrl.split(":");
        return serviceName + "@tcp -h " + ipAndPort[0] + " -p " + ipAndPort[1];
    }

    public static Object[] getParamArray(Class<?>[] paramTypes, String[] paramNames, String body) {
        Map bodyMap = GsonUtils.getInstance().convertToMap(body);
        Object[] param = new Object[paramNames.length];
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            Class<?> paramType = paramTypes[i];
            param[i] = PRIMITIVE_TYPE.containsKey(paramType.getName()) ? PRIMITIVE_TYPE.get(paramType.getName()).getFunc().apply(bodyMap.get(paramName)) : bodyMap.get(paramName);
        }
        return param;
    }

    static {
        PRIMITIVE_TYPE.put("int", new PrimitiveType(Integer.TYPE, o -> {
            if (o instanceof String) {
                return Integer.valueOf((String)o);
            }
            return ((Long)o).intValue();
        }));
        PRIMITIVE_TYPE.put("double", new PrimitiveType(Double.TYPE, o -> {
            if (o instanceof String) {
                return Double.valueOf((String)o);
            }
            return o;
        }));
        PRIMITIVE_TYPE.put("long", new PrimitiveType(Long.TYPE, o -> {
            if (o instanceof String) {
                return Long.valueOf((String)o);
            }
            return o;
        }));
        PRIMITIVE_TYPE.put("short", new PrimitiveType(Short.TYPE, o -> {
            if (o instanceof String) {
                return Short.valueOf((String)o);
            }
            return ((Long)o).shortValue();
        }));
        PRIMITIVE_TYPE.put("byte", new PrimitiveType(Byte.TYPE, o -> {
            if (o instanceof String) {
                return Byte.valueOf((String)o);
            }
            return ((Long)o).byteValue();
        }));
        PRIMITIVE_TYPE.put("boolean", new PrimitiveType(Boolean.TYPE, o -> {
            if (o instanceof String) {
                return Byte.valueOf((String)o);
            }
            return o;
        }));
        PRIMITIVE_TYPE.put("char", new PrimitiveType(Character.TYPE, o -> {
            if (o instanceof String) {
                return Character.valueOf(String.valueOf(o).charAt(0));
            }
            return o;
        }));
        PRIMITIVE_TYPE.put("float", new PrimitiveType(Float.TYPE, o -> {
            if (o instanceof String) {
                return Float.valueOf((String)o);
            }
            return Float.valueOf(((Double)o).floatValue());
        }));
    }

    static class PrimitiveType {
        private final Class<?> clazz;
        private final Function<Object, Object> func;

        PrimitiveType(Class<?> clazz, Function<Object, Object> func) {
            this.clazz = clazz;
            this.func = func;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Function<Object, Object> getFunc() {
            return this.func;
        }
    }
}

