/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.FailbackRegistryRepository;
import org.apache.shenyu.register.client.http.utils.RegisterUtils;
import org.apache.shenyu.register.client.http.utils.RuntimeUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class HttpClientRegisterRepository
extends FailbackRegistryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientRegisterRepository.class);
    private static URIRegisterDTO uriRegisterDTO;
    private String username;
    private String password;
    private List<String> serverList;
    private String accessToken;

    public HttpClientRegisterRepository() {
    }

    public HttpClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        this.username = config.getProps().getProperty("username");
        this.password = config.getProps().getProperty("password");
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)config.getServerLists()));
        this.setAccessToken();
    }

    public void doPersistURI(URIRegisterDTO registerDTO) {
        if (RuntimeUtils.listenByOther(registerDTO.getPort())) {
            return;
        }
        this.doRegister(registerDTO, "/shenyu-client/register-uri", "uri");
        uriRegisterDTO = registerDTO;
    }

    public void doPersistInterface(MetaDataRegisterDTO metadata) {
        this.doRegister(metadata, "/shenyu-client/register-metadata", "metadata");
    }

    public void close() {
        if (uriRegisterDTO != null) {
            uriRegisterDTO.setEventType(EventType.DELETED);
            this.doRegister(uriRegisterDTO, "/shenyu-client/register-uri", "uri");
        }
    }

    private void setAccessToken() {
        for (String server : this.serverList) {
            try {
                Optional<Object> login = RegisterUtils.doLogin(this.username, this.password, server.concat("/platform/loginForMetadata"));
                login.ifPresent(v -> {
                    this.accessToken = String.valueOf(v);
                });
            }
            catch (Exception e) {
                LOGGER.error("Login admin url :{} is fail, will retry. cause: {} ", (Object)server, (Object)e.getMessage());
            }
        }
    }

    private <T> void doRegister(T t, String path, String type) {
        for (String server : this.serverList) {
            String concat = server.concat(path);
            try {
                if (StringUtils.isBlank((CharSequence)this.accessToken)) {
                    this.setAccessToken();
                    if (StringUtils.isBlank((CharSequence)this.accessToken)) {
                        throw new NullPointerException("accessToken is null");
                    }
                }
                RegisterUtils.doRegister(GsonUtils.getInstance().toJson(t), concat, type, this.accessToken);
                if (!"uri".equals(type)) continue;
                return;
            }
            catch (Exception e) {
                LOGGER.error("Register admin url :{} is fail, will retry. cause:{}", (Object)server, (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

