/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.register.client.server.consul.ConsulConfigChangedEvent;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;

public class ShenyuConsulConfigWatch
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShenyuConsulConfigWatch.class);
    @Resource(name="registerConsulClient")
    private ConsulClient consul;
    private final ScheduledThreadPoolExecutor executor;
    private final int waitTime;
    private final int watchDelay;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, Long> consulIndexes = new HashMap<String, Long>();
    private final ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;

    public ShenyuConsulConfigWatch(ShenyuRegisterCenterConfig config, ApplicationEventPublisher publisher) {
        this.watchDelay = Integer.parseInt(config.getProps().getProperty("delay", "1"));
        this.waitTime = Integer.parseInt(config.getProps().getProperty("wait-time", "55"));
        this.executor = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"consul-config-watch", (boolean)true));
        String metadataPath = config.getProps().getProperty("metadata-path", "shenyu/register");
        this.consulIndexes.put(metadataPath, 0L);
        this.publisher = publisher;
    }

    private void watchConfigKeyValues() {
        if (this.running.get()) {
            for (String context : this.consulIndexes.keySet()) {
                try {
                    Response response;
                    Long currentIndex = this.consulIndexes.get(context);
                    if (currentIndex == null) {
                        currentIndex = -1L;
                    }
                    if ((response = this.consul.getKVValues(context, null, new QueryParams((long)this.waitTime, currentIndex.longValue()))).getValue() != null && !((List)response.getValue()).isEmpty()) {
                        Long newIndex = response.getConsulIndex();
                        if (Objects.nonNull(newIndex) && !newIndex.equals(currentIndex)) {
                            if (!this.consulIndexes.containsValue(newIndex) && !currentIndex.equals(-1L)) {
                                LOGGER.trace("Context {} has new index {}", (Object)context, (Object)newIndex);
                                Map<String, GetValue> valueMap = this.extractGetValue((Response<List<GetValue>>)response);
                                this.publisher.publishEvent((ApplicationEvent)new ConsulConfigChangedEvent(this, newIndex, valueMap));
                            } else if (LOGGER.isTraceEnabled()) {
                                LOGGER.info("Event for index already published for context {}", (Object)context);
                            }
                            this.consulIndexes.put(context, newIndex);
                            continue;
                        }
                        if (!LOGGER.isTraceEnabled()) continue;
                        LOGGER.trace("Same index for context {}", (Object)context);
                        continue;
                    }
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("No value for context {}", (Object)context);
                }
                catch (Exception e) {
                    LOGGER.warn("Error querying consul Key/Values for context '{}'. Message: {}", (Object)context, (Object)e.getMessage());
                }
            }
        }
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.executor.scheduleWithFixedDelay(this::watchConfigKeyValues, 5L, this.watchDelay, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    private Map<String, GetValue> extractGetValue(Response<List<GetValue>> response) {
        HashMap<String, GetValue> valueMap = new HashMap<String, GetValue>();
        List values = (List)response.getValue();
        values.forEach(getValue -> valueMap.put(getValue.getKey(), (GetValue)getValue));
        return valueMap;
    }
}

