/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.client.server.consul.ConsulConfigChangedEvent;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

@Join
public class ConsulClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClientServerRegisterRepository.class);
    private ConsulClient consulClient;
    private Map<String, List<URIRegisterDTO>> uriRegisterDTOMap = new HashMap<String, List<URIRegisterDTO>>();
    private ShenyuClientServerRegisterPublisher publisher;
    private final Map<String, Long> indexMap = new HashMap<String, Long>();
    private final Map<String, String> uriRpcTypeMap = new HashMap<String, String>();

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
        this.consulClient = new ConsulClient(config.getServerLists());
    }

    @EventListener
    public void onInstanceChange(ConsulConfigChangedEvent event) {
        Map<String, List<URIRegisterDTO>> uriMap = this.fetchInstancesMap();
        MapDifference difference = Maps.difference(uriMap, this.uriRegisterDTOMap);
        difference.entriesOnlyOnLeft().forEach(this::publishRegisterURI);
        difference.entriesOnlyOnRight().keySet().forEach(contextPath -> this.publishRegisterURI((String)contextPath, (List<URIRegisterDTO>)new ArrayList<URIRegisterDTO>()));
        difference.entriesDiffering().forEach((contextPath, listValueDifference) -> this.publishRegisterURI((String)contextPath, (List)listValueDifference.leftValue()));
        this.uriRegisterDTOMap = uriMap;
    }

    @EventListener
    public void onMetadataChange(ConsulConfigChangedEvent event) {
        Map<String, GetValue> metadataMap = event.getMetadataMap();
        metadataMap.forEach((path, getValue) -> {
            long modifyIndex = getValue.getModifyIndex();
            if (this.metadataChanged((String)path, modifyIndex)) {
                this.publishMetadata(getValue.getDecodedValue());
            }
        });
    }

    private void publishMetadata(String data) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(String contextPath, List<URIRegisterDTO> registerDTOList) {
        if (registerDTOList.isEmpty()) {
            URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath(contextPath).rpcType(this.uriRpcTypeMap.get(contextPath)).build();
            registerDTOList.add(uriRegisterDTO);
        } else {
            this.uriRpcTypeMap.put(contextPath, registerDTOList.get(0).getRpcType());
        }
        this.publisher.publish(registerDTOList);
    }

    private Map<String, List<URIRegisterDTO>> fetchInstancesMap() {
        HashMap<String, List<URIRegisterDTO>> map = new HashMap<String, List<URIRegisterDTO>>();
        Response agentServices = this.consulClient.getAgentServices();
        Map agentServicesValue = (Map)agentServices.getValue();
        agentServicesValue.forEach((k, v) -> {
            String data = (String)v.getMeta().get("uri");
            if (Objects.nonNull(data)) {
                URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(data, URIRegisterDTO.class);
                String contextPath = uriRegisterDTO.getContextPath();
                map.putIfAbsent(contextPath, new ArrayList());
                ((List)map.get(contextPath)).add(uriRegisterDTO);
            } else {
                LOGGER.debug("maybe not shenyu client, ignore service instance: {}", v);
            }
        });
        return map;
    }

    private boolean metadataChanged(String path, long index) {
        boolean hasResult;
        boolean bl = hasResult = !this.indexMap.containsKey(path) || this.indexMap.get(path) < index;
        if (hasResult) {
            this.indexMap.put(path, index);
        }
        return hasResult;
    }
}

