/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.zookeeper;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PathMatchUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperClient;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperConfig;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperClientServerRegisterRepository.class);
    private ShenyuClientServerRegisterPublisher publisher;
    private ZookeeperClient client;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.init(config);
        this.publisher = publisher;
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        this.client = new ZookeeperClient(zkConfig);
        this.client.start();
        this.initSubscribe();
    }

    public void close() {
        this.client.close();
    }

    private void initSubscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(rpcTypeEnum -> this.subscribeMetaData(rpcTypeEnum.getName()));
        RpcTypeEnum.acquireSupportURIs().forEach(rpcTypeEnum -> this.subscribeURI(rpcTypeEnum.getName()));
    }

    private void subscribeURI(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildURIContextPathParent((String)rpcType);
        this.client.addCache(contextPathParent, new URICacheListener());
    }

    private void subscribeMetaData(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildMetaDataContextPathParent((String)rpcType);
        CuratorCacheListener listener = CuratorCacheListener.builder().forCreatesAndChanges((oldNode, node) -> {
            if (PathMatchUtils.match((String)"/shenyu/register/metadata/*/*/*", (String)node.getPath())) {
                String data = new String(node.getData(), StandardCharsets.UTF_8);
                this.publishMetadata(data);
                LOGGER.info("zookeeper register metadata success: {}", (Object)data);
            }
        }).build();
        this.client.addCache(contextPathParent, listener);
    }

    private void publishMetadata(String data) {
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(List<URIRegisterDTO> registerDTOList) {
        this.publisher.publish(registerDTOList);
    }

    class URICacheListener
    implements CuratorCacheListener {
        URICacheListener() {
        }

        public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
            String path;
            String string = path = Objects.isNull(data) ? oldData.getPath() : data.getPath();
            if (!PathMatchUtils.match((String)"/shenyu/register/uri/*/*/*", (String)path)) {
                return;
            }
            int lastSepIndex = path.lastIndexOf("/");
            String contextPath = path.substring(0, lastSepIndex);
            List<String> childrenList = ZookeeperClientServerRegisterRepository.this.client.getChildren(contextPath);
            LinkedList<URIRegisterDTO> registerDTOList = new LinkedList<URIRegisterDTO>();
            childrenList.forEach(addPath -> {
                String realPath = RegisterPathConstants.buildRealNode((String)contextPath, (String)addPath);
                registerDTOList.add((URIRegisterDTO)GsonUtils.getInstance().fromJson(ZookeeperClientServerRegisterRepository.this.client.get(realPath), URIRegisterDTO.class));
            });
            if (CollectionUtils.isEmpty(registerDTOList)) {
                String[] paths = contextPath.split("/");
                URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath("/" + paths[paths.length - 1]).rpcType(paths[paths.length - 2]).build();
                registerDTOList.add(uriRegisterDTO);
            }
            ZookeeperClientServerRegisterRepository.this.publishRegisterURI(registerDTOList);
        }
    }
}

