/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.client.zookeeper.ZookeeperClient;
import org.apache.shenyu.register.client.zookeeper.ZookeeperConfig;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperClientRegisterRepository.class);
    private ZookeeperClient client;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();
    private final Set<String> metadataSet = new HashSet<String>();

    public ZookeeperClientRegisterRepository() {
    }

    public ZookeeperClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        this.client = new ZookeeperClient(zkConfig);
        this.client.getClient().getConnectionStateListenable().addListener((c, newState) -> {
            if (newState == ConnectionState.RECONNECTED) {
                this.nodeDataMap.forEach((k, v) -> {
                    if (!this.client.isExist((String)k)) {
                        this.client.createOrUpdate((String)k, (String)v, CreateMode.EPHEMERAL);
                        LOGGER.info("zookeeper client register uri success: {}", v);
                    }
                });
            }
        });
        this.client.start();
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        this.registerMetadata(rpcType, contextPath, metadata);
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        String rpcType = registerDTO.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)registerDTO.getContextPath(), (String)registerDTO.getAppName());
        this.registerURI(rpcType, contextPath, registerDTO);
        LOGGER.info("{} zookeeper client register uri success: {}", (Object)rpcType, (Object)registerDTO);
    }

    public void close() {
        this.client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMetadata(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        String metadataNodeName = this.buildMetadataNodeName(metadata);
        String metaDataPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)metaDataPath, (String)metadataNodeName);
        Set<String> set = this.metadataSet;
        synchronized (set) {
            if (this.metadataSet.contains(realNode)) {
                return;
            }
            this.metadataSet.add(realNode);
        }
        this.client.createOrUpdate(realNode, metadata, CreateMode.PERSISTENT);
        LOGGER.info("{} zookeeper client register metadata success: {}", (Object)rpcType, (Object)metadata);
    }

    private synchronized void registerURI(String rpcType, String contextPath, URIRegisterDTO registerDTO) {
        String uriNodeName = this.buildURINodeName(registerDTO);
        String uriPath = RegisterPathConstants.buildURIParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)uriPath, (String)uriNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)registerDTO);
        this.nodeDataMap.put(realNode, nodeData);
        this.client.createOrUpdate(realNode, nodeData, CreateMode.EPHEMERAL);
    }

    private String buildURINodeName(URIRegisterDTO registerDTO) {
        String host = registerDTO.getHost();
        int port = registerDTO.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private String buildMetadataNodeName(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String nodeName = RpcTypeEnum.HTTP.getName().equals(rpcType) || RpcTypeEnum.SPRING_CLOUD.getName().equals(rpcType) ? String.join((CharSequence)"-", metadata.getContextPath(), metadata.getRuleName().replace("/", "-")) : RegisterPathConstants.buildNodeName((String)metadata.getServiceName(), (String)metadata.getMethodName());
        return nodeName.startsWith("/") ? nodeName.substring(1) : nodeName;
    }
}

