/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.common.path;

public class RegisterPathConstants {
    public static final String REGISTER_URI_INSTANCE_PATH = "/shenyu/register/uri/*/*/*";
    public static final String REGISTER_METADATA_INSTANCE_PATH = "/shenyu/register/metadata/*/*/*";
    public static final String ROOT_PATH = "/shenyu/register";
    private static final String SEPARATOR = "/";
    private static final String DOT_SEPARATOR = ".";

    public static String buildMetaDataContextPathParent(String rpcType) {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "metadata", rpcType);
    }

    public static String buildMetaDataParentPath(String rpcType, String contextPath) {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "metadata", rpcType, contextPath);
    }

    public static String buildURIContextPathParent(String rpcType) {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "uri", rpcType);
    }

    public static String buildURIParentPath(String rpcType, String contextPath) {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "uri", rpcType, contextPath);
    }

    public static String buildInstanceParentPath() {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "instance");
    }

    public static String buildRealNode(String nodePath, String nodeName) {
        return String.join((CharSequence)SEPARATOR, nodePath, nodeName);
    }

    public static String buildServiceInstancePath(String rpcType) {
        return String.join((CharSequence)SEPARATOR, ROOT_PATH, "service", rpcType).replace(SEPARATOR, DOT_SEPARATOR).substring(1);
    }

    public static String buildServiceConfigPath(String rpcType, String contextPath) {
        String serviceConfigPathOrigin = String.join((CharSequence)SEPARATOR, ROOT_PATH, "service", rpcType, contextPath).replace(SEPARATOR, DOT_SEPARATOR).replace("*", "");
        String serviceConfigPathAfterSubstring = serviceConfigPathOrigin.substring(1);
        if (serviceConfigPathAfterSubstring.endsWith(DOT_SEPARATOR)) {
            return serviceConfigPathAfterSubstring.substring(0, serviceConfigPathAfterSubstring.length() - 1);
        }
        return serviceConfigPathAfterSubstring;
    }

    public static String buildNodeName(String serviceName, String methodName) {
        return String.join((CharSequence)DOT_SEPARATOR, serviceName, methodName);
    }
}

