/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewCheck;
import java.util.Properties;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.InstanceRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ConsulInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulInstanceRegisterRepository.class);
    private ConsulClient consulClient;
    private NewCheck check;

    public void init(ShenyuConfig.InstanceConfig config) {
        Properties props = config.getProps();
        String timeout = props.getProperty("consulTimeout", "3000");
        String ttl = props.getProperty("consulTTL", "3000");
        String name = props.getProperty("consulName", "shenyu-gateway");
        this.check = new NewCheck();
        this.check.setName(name);
        this.check.setId(name);
        this.check.setTtl(ttl.concat("ms"));
        this.check.setTimeout(timeout.concat("ms"));
        this.consulClient = new ConsulClient(config.getServerLists());
        this.consulClient.agentCheckRegister(this.check);
    }

    public void persistInstance(InstanceRegisterDTO instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        String instancePath = RegisterPathConstants.buildInstanceParentPath();
        String realNode = RegisterPathConstants.buildRealNode((String)instancePath, (String)instanceNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.consulClient.setKVValue(realNode, nodeData);
        LOGGER.info("consul client register success: {}", (Object)nodeData);
    }

    public void close() {
        this.consulClient.agentCheckDeregister(this.check.getId());
    }

    private String buildInstanceNodeName(InstanceRegisterDTO instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }
}

