/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.zookeeper;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.InstanceRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.register.instance.zookeeper.ZookeeperClient;
import org.apache.shenyu.register.instance.zookeeper.ZookeeperConfig;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperInstanceRegisterRepository.class);
    private ZookeeperClient client;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();

    public void init(ShenyuConfig.InstanceConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        this.client = new ZookeeperClient(zkConfig);
        this.client.getClient().getConnectionStateListenable().addListener((c, newState) -> {
            if (newState == ConnectionState.RECONNECTED) {
                this.nodeDataMap.forEach((k, v) -> {
                    if (!this.client.isExist((String)k)) {
                        this.client.createOrUpdate((String)k, (String)v, CreateMode.EPHEMERAL);
                        LOGGER.info("zookeeper client register instance success: {}", v);
                    }
                });
            }
        });
        this.client.start();
    }

    public void persistInstance(InstanceRegisterDTO instance) {
        String uriNodeName = this.buildInstanceNodeName(instance);
        String instancePath = RegisterPathConstants.buildInstanceParentPath();
        if (!this.client.isExist(instancePath)) {
            this.client.createOrUpdate(instancePath, "", CreateMode.PERSISTENT);
        }
        String realNode = RegisterPathConstants.buildRealNode((String)instancePath, (String)uriNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.nodeDataMap.put(realNode, nodeData);
        this.client.createOrUpdate(realNode, nodeData, CreateMode.EPHEMERAL);
    }

    public void close() {
        this.client.close();
    }

    private String buildInstanceNodeName(InstanceRegisterDTO instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }
}

