/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.spi.ExtensionFactory;
import org.apache.shenyu.spi.Join;
import org.apache.shenyu.spi.SPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String SHENYU_DIRECTORY = "META-INF/shenyu/";
    private static final Map<Class<?>, ExtensionLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Class<T> clazz;
    private final ClassLoader classLoader;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final Map<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Map<Class<?>, Object> joinInstances = new ConcurrentHashMap();
    private String cachedDefaultName;

    private ExtensionLoader(Class<T> clazz, ClassLoader cl) {
        this.clazz = clazz;
        this.classLoader = cl;
        if (!Objects.equals(clazz, ExtensionFactory.class)) {
            ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getExtensionClasses();
        }
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz, ClassLoader cl) {
        Objects.requireNonNull(clazz, "extension clazz is null");
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") is not interface!");
        }
        if (!clazz.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") without @" + SPI.class + " Annotation");
        }
        ExtensionLoader<?> extensionLoader = LOADERS.get(clazz);
        if (Objects.nonNull(extensionLoader)) {
            return extensionLoader;
        }
        LOADERS.putIfAbsent(clazz, new ExtensionLoader<T>(clazz, cl));
        return LOADERS.get(clazz);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz) {
        return ExtensionLoader.getExtensionLoader(clazz, ExtensionLoader.class.getClassLoader());
    }

    public T getDefaultJoin() {
        this.getExtensionClasses();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName)) {
            return null;
        }
        return this.getJoin(this.cachedDefaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getJoin(String name) {
        Object value;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new NullPointerException("get join name is null");
        }
        Holder<Object> objectHolder = this.cachedInstances.get(name);
        if (Objects.isNull(objectHolder)) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            objectHolder = this.cachedInstances.get(name);
        }
        if (Objects.isNull(value = objectHolder.getValue())) {
            Map<String, Holder<Object>> map = this.cachedInstances;
            synchronized (map) {
                value = objectHolder.getValue();
                if (Objects.isNull(value)) {
                    value = this.createExtension(name);
                    objectHolder.setValue(value);
                }
            }
        }
        return (T)value;
    }

    public List<T> getJoins() {
        Map<String, Class<?>> extensionClasses = this.getExtensionClasses();
        if (extensionClasses.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.equals(extensionClasses.size(), this.cachedInstances.size())) {
            return this.cachedInstances.values().stream().map(e -> e.getValue()).collect(Collectors.toList());
        }
        ArrayList joins = new ArrayList();
        extensionClasses.forEach((name, v) -> {
            T join = this.getJoin((String)name);
            joins.add(join);
        });
        return joins;
    }

    private T createExtension(String name) {
        Class<?> aClass = this.getExtensionClasses().get(name);
        if (Objects.isNull(aClass)) {
            throw new IllegalArgumentException("name is error");
        }
        Object o = this.joinInstances.get(aClass);
        if (Objects.isNull(o)) {
            try {
                this.joinInstances.putIfAbsent(aClass, aClass.newInstance());
                o = this.joinInstances.get(aClass);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Extension instance(name: " + name + ", class: " + aClass + ")  could not be instantiated: " + e.getMessage(), e);
            }
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.getValue();
        if (Objects.isNull(classes)) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.getValue();
                if (Objects.isNull(classes)) {
                    classes = this.loadExtensionClass();
                    this.cachedClasses.setValue(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClass() {
        String value;
        SPI annotation = this.clazz.getAnnotation(SPI.class);
        if (Objects.nonNull(annotation) && StringUtils.isNotBlank((CharSequence)(value = annotation.value()))) {
            this.cachedDefaultName = value;
        }
        HashMap classes = new HashMap(16);
        this.loadDirectory(classes);
        return classes;
    }

    private void loadDirectory(Map<String, Class<?>> classes) {
        String fileName = SHENYU_DIRECTORY + this.clazz.getName();
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = Objects.nonNull(this.classLoader) ? this.classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (Objects.nonNull(urls)) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResources(classes, url);
                }
            }
        }
        catch (IOException t) {
            LOG.error("load extension class error {}", (Object)fileName, (Object)t);
        }
    }

    private void loadResources(Map<String, Class<?>> classes, URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String name = (String)k;
                String classPath = (String)v;
                if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)classPath)) {
                    try {
                        this.loadClass(classes, name, classPath);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("load extension resources error", e);
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("load extension resources error", e);
        }
    }

    private void loadClass(Map<String, Class<?>> classes, String name, String classPath) throws ClassNotFoundException {
        Class<?> subClass;
        Class<?> clazz = subClass = Objects.nonNull(this.classLoader) ? Class.forName(classPath, true, this.classLoader) : Class.forName(classPath);
        if (!this.clazz.isAssignableFrom(subClass)) {
            throw new IllegalStateException("load extension resources error," + subClass + " subtype is not of " + this.clazz);
        }
        if (!subClass.isAnnotationPresent(Join.class)) {
            throw new IllegalStateException("load extension resources error," + subClass + " without @" + Join.class + " annotation");
        }
        Class<?> oldClass = classes.get(name);
        if (Objects.isNull(oldClass)) {
            classes.put(name, subClass);
        } else if (!Objects.equals(oldClass, subClass)) {
            throw new IllegalStateException("load extension resources error,Duplicate class " + this.clazz.getName() + " name " + name + " on " + oldClass.getName() + " or " + subClass.getName());
        }
    }

    public static class Holder<T> {
        private volatile T value;

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

