/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.redis.cache.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.shenyu.common.utils.SerializationUtils;
import org.apache.shenyu.springboot.starter.redis.cache.CacheClient;
import org.apache.shenyu.springboot.starter.redis.cache.CacheExecuterService;
import org.apache.shenyu.springboot.starter.redis.cache.CacheManager;
import org.apache.shenyu.springboot.starter.redis.cache.impl.RedisClusterManager;
import org.apache.shenyu.springboot.starter.redis.util.ConvertUtil;
import org.apache.shenyu.springboot.starter.redis.util.SerializetionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class CacheClientImpl
implements CacheClient {
    private static final Logger log = LoggerFactory.getLogger(CacheClientImpl.class);
    private boolean isCluster = false;
    private CacheManager cacheManager;

    @Override
    public boolean isCluster() {
        return this.isCluster;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if (cacheManager instanceof RedisClusterManager) {
            this.isCluster = true;
        }
    }

    @Override
    public void set(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializetionUtils.serializeSlightly(value));
    }

    @Override
    public void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializetionUtils.serializeSlightly(value));
    }

    @Override
    public void set(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializetionUtils.serializeSlightly(value), expire);
    }

    @Override
    public void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializetionUtils.serializeSlightly(value), expire);
    }

    @Override
    public Object get(String key, boolean needSerialization) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        if (needSerialization) {
            return SerializationUtils.deserializeSlightly((byte[])value);
        }
        return new String(value);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return (T)SerializetionUtils.deserializeSlightly(value);
    }

    @Override
    public void delete(String key) {
        this.cacheManager.del(key.getBytes());
    }

    @Override
    public <T> T getFinal(CacheExecuterService<T> executer, String ... key) {
        String finalKey = this.getFinalKey(key);
        log.debug("finalKey=" + finalKey);
        byte[] value = this.cacheManager.get(finalKey.getBytes());
        if (value == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            T obj = executer.getParamFromDb(key);
            if (obj != null && !"".equals(obj)) {
                log.debug("value=" + obj.toString());
                this.put(finalKey, obj);
                return obj;
            }
            log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        Object finalValue = SerializetionUtils.deserializeSlightly(value);
        log.debug("value=" + finalValue);
        return (T)finalValue;
    }

    private String getFinalKey(String ... key) {
        StringBuffer fkey = new StringBuffer();
        for (String s : key) {
            fkey.append(s);
            fkey.append("_");
        }
        fkey.setLength(fkey.length() - 1);
        return fkey.toString();
    }

    @Override
    public Set<String> getkeys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Set<byte[]> keybs = this.cacheManager.keys(pattern);
        for (byte[] bs : keybs) {
            keys.add(new String(bs));
        }
        return keys;
    }

    @Override
    public Long getExpireTimeByKey(String key) {
        return this.cacheManager.getExpireTimeByKey(key.getBytes());
    }

    @Override
    public Long incr(String key) {
        return this.cacheManager.incr(key.getBytes());
    }

    @Override
    public Long incrExpireTime(String key, int expire) {
        return this.cacheManager.incrExpireTime(key.getBytes(), expire);
    }

    @Override
    public Long incrBy(String key, long num) {
        return this.cacheManager.incrBy(key.getBytes(), num);
    }

    @Override
    public Long incrExpireTimeBy(String key, long num, int expire) {
        return this.cacheManager.incrExpireTimeBy(key.getBytes(), num, expire);
    }

    @Override
    public Long getIncr(String key) {
        return this.cacheManager.getIncr(key.getBytes());
    }

    @Override
    public Long rpush(String key, Object obj) {
        return this.cacheManager.rpush(key.getBytes(), ConvertUtil.serialize(obj));
    }

    @Override
    public String lpop(String key) {
        return this.cacheManager.lpop(key);
    }

    @Override
    public Long llen(String key) {
        return this.cacheManager.llen(key);
    }

    @Override
    public Long setnx(String key, Object value) {
        return this.cacheManager.setnx(key.getBytes(), SerializetionUtils.serializeSlightly(value));
    }

    @Override
    public Object getSet(String key, Object value) {
        byte[] bytes = this.cacheManager.getSet(key.getBytes(), SerializetionUtils.serializeSlightly(value));
        return bytes == null ? null : SerializetionUtils.deserializeSlightly(bytes);
    }

    @Override
    public JedisPool getJedisPool() {
        return this.cacheManager.getJedisPool();
    }

    @Override
    public JedisCluster getJedisCluster() {
        return this.cacheManager.getJedisCluster();
    }

    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        return this.cacheManager.blpop(key, waitSeconds, clazz);
    }

    @Override
    public Long expire(String key, int secound) {
        return this.cacheManager.expire(key, secound);
    }

    @Override
    public String setByPipeline(Map<String, String> cacheInfo) {
        return this.cacheManager.setByPipeline(cacheInfo);
    }

    @Override
    public Object getByPipeline(String keyPrefix) {
        return this.cacheManager.getByPipeline(keyPrefix);
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.cacheManager.subscribe(jedisPubSub, channels);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.cacheManager.publish(channel, message);
    }
}

