/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.redis.cache.impl;

import cn.hutool.core.collection.CollectionUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.springboot.starter.redis.cache.CacheManager;
import org.apache.shenyu.springboot.starter.redis.util.ConvertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.JedisClusterCRC16;

public class RedisClusterManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(RedisClusterManager.class);
    private String host = "115.28.105.99";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "BJtGXdevRedis123";
    private JedisCluster jedisCluster;

    @Override
    public byte[] get(byte[] key) {
        byte[] value = null;
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        value = jedisCluster.get(key);
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (this.expire != 0) {
            jedisCluster.expire(key, (long)this.expire);
        }
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.set(key, value);
        if (expire != 0) {
            jedisCluster.expire(key, (long)expire);
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        jedisCluster.del(key);
    }

    @Override
    public void flushDB() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public Long dbSize() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public Set<byte[]> keys(String pattern) {
        ScanResult scanResult;
        JedisCluster jedisCluster = this.getJedisCluster();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        byte[] cursor = "0".getBytes(StandardCharsets.UTF_8);
        ScanParams scanParams = new ScanParams().count(Integer.valueOf(100)).match(pattern.getBytes(StandardCharsets.UTF_8));
        do {
            scanResult = jedisCluster.scan(cursor, scanParams);
            keys.addAll(scanResult.getResult());
        } while (!new String(cursor = scanResult.getCursorAsBytes(), StandardCharsets.UTF_8).equals("0"));
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    @Override
    public JedisPool getJedisPool() {
        return null;
    }

    public void setJedisClusterPool(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        if (expire != 0) {
            jedisCluster.expire(key, (long)expire);
        }
    }

    @Override
    public Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        JedisCluster jedisCluster = null;
        jedisCluster = this.getJedisCluster();
        expireTime = jedisCluster.ttl(key);
        return expireTime;
    }

    @Override
    public Long incr(byte[] key) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incr(key);
        return num;
    }

    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incr(key);
        jedisCluster.expire(key, (long)expire);
        return num;
    }

    @Override
    public Long incrBy(byte[] key, long conut) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incrBy(key, conut);
        return num;
    }

    @Override
    public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        num = jedisCluster.incrBy(key, conut);
        jedisCluster.expire(key, (long)expire);
        return num;
    }

    @Override
    public Long getIncr(byte[] key) {
        JedisCluster jedisCluster = null;
        Long num = null;
        jedisCluster = this.getJedisCluster();
        byte[] bnum = jedisCluster.get(key);
        String numStr = bnum == null ? null : new String(bnum);
        num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        return num;
    }

    @Override
    public Long rpush(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.rpush(key, (byte[][])new byte[][]{value});
        return res;
    }

    @Override
    public String lpop(String key) {
        JedisCluster jedisCluster = null;
        String res = null;
        jedisCluster = this.getJedisCluster();
        byte[] bytes = jedisCluster.lpop(key.getBytes());
        res = new String(bytes);
        return res;
    }

    @Override
    public Long llen(String key) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.llen(key.getBytes());
        return res;
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        Long res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.setnx(key, value);
        return res;
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        JedisCluster jedisCluster = null;
        byte[] res = null;
        jedisCluster = this.getJedisCluster();
        res = jedisCluster.getSet(key, value);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        T t;
        block5: {
            JedisCluster jedisCluster = null;
            jedisCluster = this.getJedisCluster();
            List values = jedisCluster.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
            if (values == null || values.size() <= 0) break block5;
            byte[] value = (byte[])values.get(1);
            T t2 = ConvertUtil.unserialize(value, clazz);
            return t2;
        }
        try {
            t = null;
        }
        catch (Exception e) {
            T t3 = null;
            return t3;
        }
        return t;
    }

    @Override
    public Long expire(String key, int secound) {
        JedisCluster jedisCluster = null;
        Long expire = null;
        jedisCluster = this.getJedisCluster();
        expire = jedisCluster.expire(key, (long)secound);
        return expire;
    }

    @Override
    public String setByPipeline(Map<String, String> cacheInfo) {
        ConcurrentHashMap<Jedis, Pipeline> pipelineMap = new ConcurrentHashMap<Jedis, Pipeline>(16);
        Iterator<Map.Entry<String, String>> it = cacheInfo.entrySet().iterator();
        try {
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                Connection connection = this.jedisCluster.getConnectionFromSlot(JedisClusterCRC16.getSlot((String)entry.getKey()));
                Jedis jedis2 = new Jedis(connection);
                Pipeline pipeline2 = (Pipeline)pipelineMap.get(jedis2);
                if (null == pipeline2) {
                    pipeline2 = jedis2.pipelined();
                    pipelineMap.put(jedis2, pipeline2);
                }
                pipeline2.set(entry.getKey(), entry.getValue());
            }
            pipelineMap.forEach((jedis, pipeline) -> {
                try {
                    pipeline.sync();
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u7ba1\u9053\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    pipeline.close();
                }
            });
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7\u7ba1\u9053\u7f13\u5b58\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public Object getByPipeline(String pattern) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams scanParams = new ScanParams().match(pattern).count(Integer.valueOf(1000));
        Map clusterNodeConnectionPool = this.jedisCluster.getClusterNodes();
        HashSet keySet = new HashSet(16);
        for (Map.Entry entry : clusterNodeConnectionPool.entrySet()) {
            try {
                Jedis jedis = new Jedis(((ConnectionPool)entry.getValue()).getResource());
                Throwable throwable = null;
                try {
                    ScanResult scanResult;
                    do {
                        if (!CollectionUtil.isNotEmpty((Collection)(scanResult = jedis.scan(cursor, scanParams)).getResult())) continue;
                        keySet.addAll(scanResult.getResult());
                    } while (!(cursor = scanResult.getCursor()).equals(ScanParams.SCAN_POINTER_START));
                }
                catch (Throwable scanResult) {
                    throwable = scanResult;
                    throw scanResult;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable scanResult) {
                            throwable.addSuppressed(scanResult);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u8282\u70b9{}\u4e0b\u7684\u6240\u6709key\u503c\u5f02\u5e38\uff1a{}", entry.getKey(), (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        log.error("\u6839\u636ekey\u524d\u7f00[{}]\u5171\u83b7\u53d6\u5230{}\u4e2akey\u503c\u3002", (Object)pattern, (Object)keySet.size());
        if (CollectionUtil.isEmpty(keySet)) {
            return null;
        }
        ArrayList dataList = new ArrayList();
        HashMap nodeKeyMap = new HashMap(this.jedisCluster.getClusterNodes().size());
        try {
            keySet.forEach(key -> {
                Connection nodeCollection = this.jedisCluster.getConnectionFromSlot(JedisClusterCRC16.getSlot((String)key));
                ArrayList<String> nodeKeys = (ArrayList<String>)nodeKeyMap.get(nodeCollection);
                if (null == nodeKeys) {
                    nodeKeys = new ArrayList<String>();
                    nodeKeyMap.put(nodeCollection, nodeKeys);
                }
                nodeKeys.add((String)key);
            });
        }
        catch (Exception e) {
            log.error("\u6839\u636ekey\u503c\u83b7\u53d6\u5176\u8282\u70b9\u94fe\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        for (Map.Entry nodeKeyEntry : nodeKeyMap.entrySet()) {
            try {
                Jedis jedis = new Jedis((Connection)nodeKeyEntry.getKey());
                Throwable throwable = null;
                try {
                    Pipeline pipeline = jedis.pipelined();
                    Response mGetResponse = pipeline.mget(((List)nodeKeyEntry.getValue()).toArray(new String[((List)nodeKeyEntry.getValue()).size()]));
                    pipeline.sync();
                    dataList.addAll((Collection)mGetResponse.get());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (Exception e) {
                log.error("\u901a\u8fc7\u7ba1\u9053\u83b7\u53d6redis\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return dataList;
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.jedisCluster.subscribe(jedisPubSub, channels);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.jedisCluster.publish(channel, message);
    }
}

