/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.redis.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.shenyu.springboot.starter.redis.cache.Serializer;
import org.apache.shenyu.springboot.starter.redis.cache.impl.FSTSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SerializationUtils;

public class SerializetionUtils {
    private static final Logger logger = LoggerFactory.getLogger(SerializationUtils.class);
    private static Serializer g_serializer = new FSTSerializer();

    public static byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        return g_serializer.serialize(obj);
    }

    public static byte[] serializeWithoutException(Object obj) {
        try {
            return SerializetionUtils.serialize(obj);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static byte[] serializeSlightly(Object obj) {
        try {
            return SerializetionUtils.serialize(obj);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return g_serializer.deserialize(bytes);
    }

    public static Object deserializeSlightly(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return g_serializer.deserialize(bytes);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Object deserialize(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        return g_serializer.deserialize(SerializetionUtils.toByteArray(obj));
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }
}

