/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.nacos.handler;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosCacheHandler {
    protected static final Map<String, List<Listener>> LISTENERS = Maps.newConcurrentMap();
    private static final Logger LOG = LoggerFactory.getLogger(NacosCacheHandler.class);
    private final ConfigService configService;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public NacosCacheHandler(ConfigService configService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.configService = configService;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    protected void updatePluginMap(String configInfo) {
        try {
            ArrayList pluginDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, PluginData.class).values());
            pluginDataList.forEach(pluginData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSubscribe(pluginData);
                subscriber.onSubscribe(pluginData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync plugin data have error:", (Throwable)e);
        }
    }

    protected void updateSelectorMap(String configInfo) {
        try {
            List<SelectorData> selectorDataList = GsonUtils.getInstance().toObjectMapList(configInfo, SelectorData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            selectorDataList.forEach(selectorData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unSelectorSubscribe(selectorData);
                subscriber.onSelectorSubscribe(selectorData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync selector data have error:", (Throwable)e);
        }
    }

    protected void updateRuleMap(String configInfo) {
        try {
            List<RuleData> ruleDataList = GsonUtils.getInstance().toObjectMapList(configInfo, RuleData.class).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            ruleDataList.forEach(ruleData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(subscriber -> {
                subscriber.unRuleSubscribe(ruleData);
                subscriber.onRuleSubscribe(ruleData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync rule data have error:", (Throwable)e);
        }
    }

    protected void updateMetaDataMap(String configInfo) {
        try {
            ArrayList metaDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, MetaData.class).values());
            metaDataList.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(metaData);
                subscriber.onSubscribe(metaData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync meta data have error:", (Throwable)e);
        }
    }

    protected void updateAuthMap(String configInfo) {
        try {
            ArrayList appAuthDataList = new ArrayList(GsonUtils.getInstance().toObjectMap(configInfo, AppAuthData.class).values());
            appAuthDataList.forEach(appAuthData -> this.authDataSubscribers.forEach(subscriber -> {
                subscriber.unSubscribe(appAuthData);
                subscriber.onSubscribe(appAuthData);
            }));
        }
        catch (JsonParseException e) {
            LOG.error("sync auth data have error:", (Throwable)e);
        }
    }

    private String getConfigAndSignListener(String dataId, Listener listener) {
        String config = null;
        try {
            config = this.configService.getConfigAndSignListener(dataId, "DEFAULT_GROUP", 6000L, listener);
        }
        catch (NacosException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (Objects.isNull(config)) {
            config = "{}";
        }
        return config;
    }

    protected void watcherData(String dataId, final OnChange oc) {
        Listener listener = new Listener(){

            public void receiveConfigInfo(String configInfo) {
                oc.change(configInfo);
            }

            public Executor getExecutor() {
                return null;
            }
        };
        oc.change(this.getConfigAndSignListener(dataId, listener));
        LISTENERS.computeIfAbsent(dataId, key -> new ArrayList()).add(listener);
    }

    protected static interface OnChange {
        public void change(String var1);
    }
}

