/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class FallbackFilter
extends AbstractWebFilter {
    private final DispatcherHandler dispatcherHandler;
    private final Set<String> paths;

    public FallbackFilter(List<String> paths, DispatcherHandler dispatcherHandler) {
        this.dispatcherHandler = dispatcherHandler;
        this.paths = new HashSet<String>(paths);
    }

    @Override
    protected Mono<Boolean> doMatcher(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getURI().getPath();
        return Mono.just((Object)this.paths.contains(path));
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange) {
        return this.dispatcherHandler.handle(exchange);
    }
}

