/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.Health;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public final class HealthFilter
extends AbstractWebFilter {
    private final Set<String> paths;

    public HealthFilter(List<String> paths) {
        this.paths = CollectionUtils.isEmpty(paths) ? new HashSet<String>(Arrays.asList("/actuator/health", "/health_check")) : new HashSet<String>(paths);
    }

    @Override
    protected Mono<Boolean> doMatcher(ServerWebExchange exchange, WebFilterChain chain) {
        return Mono.just((Object)this.paths.contains(exchange.getRequest().getURI().getPath()));
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange) {
        String result = JsonUtils.toJson((Object)new Health.Builder().up().build());
        DataBuffer dataBuffer = exchange.getResponse().bufferFactory().wrap(result.getBytes(StandardCharsets.UTF_8));
        return exchange.getResponse().writeWith((Publisher)Mono.just((Object)dataBuffer));
    }
}

