/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.web.handler.ShenyuWebHandler;
import org.apache.shenyu.web.loader.ShenyuLoaderResult;
import org.apache.shenyu.web.loader.ShenyuPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuLoaderService {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebHandler.class);
    private final ShenyuWebHandler webHandler;
    private final CommonPluginDataSubscriber subscriber;
    private final ShenyuConfig shenyuConfig;

    public ShenyuLoaderService(ShenyuWebHandler webHandler, CommonPluginDataSubscriber subscriber, ShenyuConfig shenyuConfig) {
        this.subscriber = subscriber;
        this.webHandler = webHandler;
        this.shenyuConfig = shenyuConfig;
        ShenyuConfig.ExtPlugin config = shenyuConfig.getExtPlugin();
        if (config.getEnabled()) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor((int)config.getThreads(), ShenyuThreadFactory.create((String)"plugin-ext-loader", (boolean)true));
            executor.scheduleAtFixedRate(this::loaderExtPlugins, config.getScheduleDelay().intValue(), config.getScheduleTime().intValue(), TimeUnit.SECONDS);
        }
    }

    private void loaderExtPlugins() {
        try {
            List<ShenyuLoaderResult> results = ShenyuPluginLoader.getInstance().loadExtendPlugins(this.shenyuConfig.getExtPlugin().getPath());
            if (CollectionUtils.isEmpty(results)) {
                return;
            }
            List<ShenyuPlugin> shenyuExtendPlugins = results.stream().map(ShenyuLoaderResult::getShenyuPlugin).filter(Objects::nonNull).collect(Collectors.toList());
            this.webHandler.putExtPlugins(shenyuExtendPlugins);
            List handlers = results.stream().map(ShenyuLoaderResult::getPluginDataHandler).filter(Objects::nonNull).collect(Collectors.toList());
            this.subscriber.putExtendPluginDataHandler(handlers);
        }
        catch (Exception e) {
            LOG.error("shenyu ext plugins load has error ", (Throwable)e);
        }
    }
}

