/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/shenyu"}, produces={"application/json", "application/xml"})
public class LocalMetadataController {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMetadataController.class);
    private final List<MetaDataSubscriber> subscribers;

    public LocalMetadataController(ObjectProvider<List<MetaDataSubscriber>> subscribers) {
        this.subscribers = (List)subscribers.getIfAvailable(ArrayList::new);
    }

    @GetMapping(value={"/meta/delete"})
    public Mono<String> clean(@RequestParam(value="rpcType") String rpcType, @RequestParam(value="path") String path) {
        if (CollectionUtils.isEmpty(this.subscribers)) {
            return Mono.just((Object)"success");
        }
        LOG.info("delete apache shenyu local meta data");
        MetaData metaData = MetaData.builder().rpcType(rpcType).path(path).build();
        this.subscribers.forEach(metaDataSubscriber -> metaDataSubscriber.unSubscribe(metaData));
        return Mono.just((Object)"success");
    }

    @PostMapping(value={"/meta/saveOrUpdate"})
    public Mono<String> saveOrUpdate(@RequestBody MetaData metaData) {
        if (CollectionUtils.isEmpty(this.subscribers)) {
            return Mono.just((Object)"success");
        }
        LOG.info("saveOrUpdate apache shenyu local meta data");
        this.subscribers.forEach(metaDataSubscriber -> metaDataSubscriber.onSubscribe(metaData));
        return Mono.just((Object)"success");
    }
}

