/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.web.filter.bo.ShenyuUmcQueryMenuListRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class PageNumFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PageNumFilter.class);
    @Value(value="${query.pn.url:http://39.105.66.173:10150/dyc/sassnogateway/auth/getUserInfo}")
    private String url;
    private final String TOKEN = "auth-token";
    private static final String PN = "pn";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        String token = headers.getFirst("auth-token");
        String pn = headers.getFirst(PN);
        LOG.info("\u83b7\u53d6\u5230pn\uff0c{}", (Object)pn);
        if (StringUtils.isEmpty((CharSequence)pn) || StringUtils.isEmpty((CharSequence)token)) {
            Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.PN_IS_NOT_PASS.getCode(), (String)ShenyuResultEnum.PN_IS_NOT_PASS.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
        }
        LOG.info("\u5f00\u59cb\u67e5\u8be2pn\u5217\u8868\uff0c \u8bf7\u6c42\u5730\u5740 \uff1a {}", (Object)this.url);
        String body = ((HttpRequest)HttpRequest.post((String)this.url).header("auth-token", token)).body("").execute().body();
        ShenyuUmcQueryMenuListRspBO shenyuUmcQueryMenuListRspBO = (ShenyuUmcQueryMenuListRspBO)JSON.parseObject((String)body, ShenyuUmcQueryMenuListRspBO.class);
        List<String> menuCodeList = shenyuUmcQueryMenuListRspBO.getData().getMenuCodeList();
        if (CollectionUtils.isEmpty(menuCodeList)) {
            Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.PN_IS_NOT_PASS.getCode(), (String)ShenyuResultEnum.PN_IS_NOT_PASS.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
        }
        List resultList = menuCodeList.stream().filter(pn::equals).collect(Collectors.toList());
        LOG.info("pn\u8fc7\u6ee4\u7ed3\u679c\uff1a{}", resultList);
        if (CollectionUtils.isEmpty(resultList)) {
            Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.PN_IS_NOT_PASS.getCode(), (String)ShenyuResultEnum.PN_IS_NOT_PASS.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
        }
        LOG.info("pn\u6821\u9a8c\u901a\u8fc7");
        return chain.filter(exchange);
    }
}

