/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalErrorHandler
implements ErrorWebExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalErrorHandler.class);

    @NonNull
    public Mono<Void> handle(@NonNull ServerWebExchange exchange, @NonNull Throwable throwable) {
        LOG.error("handle error: {}{}", new Object[]{exchange.getLogPrefix(), this.formatError(throwable, exchange.getRequest()), throwable});
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        if (throwable instanceof ResponseStatusException) {
            httpStatus = ((ResponseStatusException)throwable).getStatus();
        }
        exchange.getResponse().setStatusCode(httpStatus);
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)httpStatus.value(), (String)httpStatus.getReasonPhrase(), (Object)throwable);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    private String formatError(Throwable throwable, ServerHttpRequest request) {
        String reason = throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
        return "Resolved [" + reason + "] for HTTP " + request.getMethod() + " " + request.getPath();
    }
}

