/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginHandlerEventEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.PluginHandlerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ShenyuWebHandler
implements WebHandler,
ApplicationListener<PluginHandlerEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebHandler.class);
    private final List<ShenyuPlugin> plugins;
    private final List<ShenyuPlugin> sourcePlugins;
    private final boolean scheduled;
    private Scheduler scheduler;

    public ShenyuWebHandler(List<ShenyuPlugin> plugins, ShenyuConfig shenyuConfig) {
        this.sourcePlugins = new ArrayList<ShenyuPlugin>(plugins);
        this.plugins = new CopyOnWriteArrayList<ShenyuPlugin>(plugins);
        ShenyuConfig.Scheduler config = shenyuConfig.getScheduler();
        this.scheduled = config.getEnabled();
        if (this.scheduled) {
            this.scheduler = Objects.equals(config.getType(), "fixed") ? Schedulers.newParallel((String)"shenyu-work-threads", (int)config.getThreads()) : Schedulers.boundedElastic();
        }
    }

    public Mono<Void> handle(@NonNull ServerWebExchange exchange) {
        Mono<Void> execute = new DefaultShenyuPluginChain(this.plugins).execute(exchange);
        if (this.scheduled) {
            return execute.subscribeOn(this.scheduler);
        }
        return execute;
    }

    public void putExtPlugins(List<ShenyuPlugin> extPlugins) {
        if (CollectionUtils.isEmpty(extPlugins)) {
            return;
        }
        List<ShenyuPlugin> shenyuPlugins = extPlugins.stream().filter(e -> this.plugins.stream().noneMatch(plugin -> plugin.named().equals(e.named()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(shenyuPlugins)) {
            shenyuPlugins.forEach(plugin -> LOG.info("shenyu auto add extends plugins:{}", (Object)plugin.named()));
            this.plugins.addAll(shenyuPlugins);
            this.onSortedPlugins();
        }
    }

    public void onApplicationEvent(PluginHandlerEvent event) {
        PluginHandlerEventEnum stateEnums = event.getPluginStateEnums();
        PluginData pluginData = (PluginData)event.getSource();
        switch (stateEnums) {
            case ENABLED: {
                this.onPluginEnabled(pluginData);
                break;
            }
            case DELETE: 
            case DISABLED: {
                this.onPluginRemoved(pluginData);
                break;
            }
            case SORTED: {
                this.onSortedPlugins();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getPluginStateEnums());
            }
        }
        this.onSortedPlugins();
    }

    private void onSortedPlugins() {
        Map<String, Integer> pluginSortMap = this.plugins.stream().collect(Collectors.toMap(ShenyuPlugin::named, plugin -> {
            PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(plugin.named());
            return Optional.ofNullable(pluginData).map(PluginData::getSort).orElse(plugin.getOrder());
        }));
        this.plugins.sort(Comparator.comparingLong(plugin -> ((Integer)pluginSortMap.get(plugin.named())).intValue()));
    }

    private void onPluginEnabled(PluginData pluginData) {
        LOG.info("shenyu use plugin:[{}]", (Object)pluginData.getName());
        List enabledPlugins = this.sourcePlugins.stream().filter(plugin -> plugin.named().equals(pluginData.getName()) && pluginData.getEnabled() != false).collect(Collectors.toList());
        enabledPlugins.removeAll(this.plugins);
        this.plugins.addAll(enabledPlugins);
    }

    private void onPluginRemoved(PluginData pluginData) {
        this.plugins.removeIf(plugin -> plugin.named().equals(pluginData.getName()));
    }

    private static class DefaultShenyuPluginChain
    implements ShenyuPluginChain {
        private int index;
        private final List<ShenyuPlugin> plugins;

        DefaultShenyuPluginChain(List<ShenyuPlugin> plugins) {
            this.plugins = plugins;
        }

        public Mono<Void> execute(ServerWebExchange exchange) {
            return Mono.defer(() -> {
                if (this.index < this.plugins.size()) {
                    ShenyuPlugin plugin;
                    boolean skip;
                    if (skip = (plugin = this.plugins.get(this.index++)).skip(exchange)) {
                        return this.execute(exchange);
                    }
                    return plugin.execute(exchange, (ShenyuPluginChain)this);
                }
                return Mono.empty();
            });
        }
    }
}

