/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.pool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.pool.ConnectionPool;

public class Connection {
    private Socket sock;
    private InetSocketAddress inetSockAddr;
    private Long lastAccessTime = System.currentTimeMillis();
    private boolean needActiveTest = false;

    public Connection(Socket sock, InetSocketAddress inetSockAddr) {
        this.sock = sock;
        this.inetSockAddr = inetSockAddr;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSockAddr;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.sock.getInputStream();
    }

    public Long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public void close() throws IOException {
        if (ClientGlobal.g_connection_pool_enabled) {
            ConnectionPool.closeConnection(this);
        } else {
            this.closeDirectly();
        }
    }

    public void release() throws IOException {
        if (ClientGlobal.g_connection_pool_enabled) {
            ConnectionPool.releaseConnection(this);
        } else {
            this.closeDirectly();
        }
    }

    public void closeDirectly() throws IOException {
        if (this.sock != null) {
            try {
                ProtoCommon.closeSocket(this.sock);
            }
            finally {
                this.sock = null;
            }
        }
    }

    public boolean activeTest() throws IOException {
        if (this.sock == null) {
            return false;
        }
        return ProtoCommon.activeTest(this.sock);
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.sock != null && this.sock.isConnected()) {
            isConnected = true;
        }
        return isConnected;
    }

    public boolean isAvaliable() {
        if (this.isConnected()) {
            if (this.sock.getPort() == 0) {
                return false;
            }
            if (this.sock.getInetAddress() == null) {
                return false;
            }
            if (this.sock.getRemoteSocketAddress() == null) {
                return false;
            }
            if (this.sock.isInputShutdown()) {
                return false;
            }
            return !this.sock.isOutputShutdown();
        }
        return false;
    }

    public boolean isNeedActiveTest() {
        return this.needActiveTest;
    }

    public void setNeedActiveTest(boolean needActiveTest) {
        this.needActiveTest = needActiveTest;
    }

    public String toString() {
        return "Connection{sock=" + this.sock + ", inetSockAddr=" + this.inetSockAddr + ", lastAccessTime=" + this.lastAccessTime + ", needActiveTest=" + this.needActiveTest + '}';
    }
}

