/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class HanyuPinyinUtils {
    public static String getPingYinAllUpper(String chines) {
        return HanyuPinyinUtils.getPingYinAll(chines, HanyuPinyinCaseType.UPPERCASE);
    }

    public static String getPingYinAllLower(String chines) {
        return HanyuPinyinUtils.getPingYinAll(chines, HanyuPinyinCaseType.LOWERCASE);
    }

    public static String getPingYinAll(String chines, HanyuPinyinCaseType type) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(type);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder output = new StringBuilder();
        if (chines != null && chines.length() > 0 && !"null".equals(chines)) {
            char[] input = chines.trim().toCharArray();
            try {
                for (char anInput : input) {
                    if (Character.toString(anInput).matches("[\\u4E00-\\u9FA5]+")) {
                        String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)anInput, (HanyuPinyinOutputFormat)format);
                        output.append(temp[0]);
                        continue;
                    }
                    output.append(Character.toString(anInput));
                }
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                e.printStackTrace();
            }
        } else {
            return "*";
        }
        return output.toString();
    }

    public static String getPingYinFirstLetterUpper(String chines) {
        return HanyuPinyinUtils.getPingYinFirstLetter(chines, HanyuPinyinCaseType.UPPERCASE);
    }

    public static String getPingYinFirstLetterLower(String chines) {
        return HanyuPinyinUtils.getPingYinFirstLetter(chines, HanyuPinyinCaseType.LOWERCASE);
    }

    public static String getPingYinFirstLetter(String chines, HanyuPinyinCaseType type) {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(type);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char aNameChar : nameChar) {
            if (aNameChar > '\u0080') {
                try {
                    pinyinName.append(PinyinHelper.toHanyuPinyinStringArray((char)aNameChar, (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName.append(aNameChar);
        }
        return pinyinName.toString();
    }

    public static void main(String[] arg) {
        System.out.println(HanyuPinyinUtils.getPingYinAllLower("\u624b\u673a"));
        System.out.println(HanyuPinyinUtils.getPingYinFirstLetterUpper("\u624b\u673a"));
    }
}

