/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.utils;

import com.ohaotian.plugin.security.entity.UserInfo;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public final class SecurityHelper {
    private static final SecurityHelper INSTANCE = new SecurityHelper();
    private static final ThreadLocal<UserInfo> CURRENT_USER = new ThreadLocal();

    private SecurityHelper() {
    }

    public static SecurityHelper getInstance() {
        return INSTANCE;
    }

    public static UserInfo getCurrentUser() {
        UserInfo userInfo = CURRENT_USER.get();
        if (userInfo != null) {
            return userInfo;
        }
        Authentication authentication = SecurityHelper.getCurrentAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (UserInfo.class.isInstance(principal)) {
            UserInfo user = (UserInfo)principal;
            return user;
        }
        return null;
    }

    public static boolean hasAuthority(String authority) {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo == null) {
            throw new SessionAuthenticationException("\u8bf7\u5148\u767b\u5f55");
        }
        boolean authed = userInfo.hasAuthority(authority);
        return authed;
    }

    public void setThreadUser(UserInfo userInfo) {
        CURRENT_USER.set(userInfo);
    }

    public static Authentication getCurrentAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        return context.getAuthentication();
    }
}

