/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.router.tag;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.router.AbstractRouter;
import java.util.ArrayList;
import java.util.List;

public class TagRouter
extends AbstractRouter {
    private static final int DEFAULT_PRIORITY = 100;
    private static final URL ROUTER_URL = new URL("tag", "0.0.0.0", 0, "*").addParameters("runtime", "true");

    public TagRouter() {
        this.url = ROUTER_URL;
        this.priority = this.url.getParameter("priority", 100);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        String forceTag;
        ArrayList<Invoker<T>> result = new ArrayList<Invoker<T>>();
        String tag = RpcContext.getContext().getAttachment("dubbo.tag");
        if (!StringUtils.isEmpty(tag)) {
            for (Invoker<T> invoker : invokers) {
                if (!tag.equals(invoker.getUrl().getParameter("dubbo.tag"))) continue;
                result.add(invoker);
            }
        }
        if (result.isEmpty() && (StringUtils.isEmpty(forceTag = RpcContext.getContext().getAttachment("dubbo.force.tag")) || "false".equals(forceTag))) {
            for (Invoker<T> invoker : invokers) {
                if (!StringUtils.isEmpty(invoker.getUrl().getParameter("dubbo.tag"))) continue;
                result.add(invoker);
            }
        }
        return result;
    }
}

