/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;

public class MessageClientIDSetter {
    private static short counter;
    private static int basePos;
    private static long startTime;
    private static long nextStartTime;
    private static StringBuilder sb;
    private static ByteBuffer buffer;
    private static final String TOPIC_KEY_SPLITTER = "#";

    private static void setStartTime(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        startTime = cal.getTimeInMillis();
        cal.add(2, 1);
        nextStartTime = cal.getTimeInMillis();
    }

    public static Date getNearlyTimeFromID(String msgID) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        byte[] bytes = UtilAll.string2bytes(msgID);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.put(bytes, 10, 4);
        buf.position(0);
        long spanMS = buf.getLong();
        Calendar cal = Calendar.getInstance();
        long now = cal.getTimeInMillis();
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long monStartTime = cal.getTimeInMillis();
        if (monStartTime + spanMS >= now) {
            cal.add(2, -1);
            monStartTime = cal.getTimeInMillis();
        }
        cal.setTimeInMillis(monStartTime + spanMS);
        return cal.getTime();
    }

    public static String getIPStrFromID(String msgID) {
        byte[] ipBytes = MessageClientIDSetter.getIPFromID(msgID);
        return UtilAll.ipToIPv4Str(ipBytes);
    }

    public static byte[] getIPFromID(String msgID) {
        byte[] result = new byte[4];
        byte[] bytes = UtilAll.string2bytes(msgID);
        System.arraycopy(bytes, 0, result, 0, 4);
        return result;
    }

    public static synchronized String createUniqID() {
        long current = System.currentTimeMillis();
        if (current >= nextStartTime) {
            MessageClientIDSetter.setStartTime(current);
        }
        buffer.position(0);
        sb.setLength(basePos);
        buffer.putInt((int)(System.currentTimeMillis() - startTime));
        short s = counter;
        counter = (short)(s + 1);
        buffer.putShort(s);
        sb.append(UtilAll.bytes2string(buffer.array()));
        return sb.toString();
    }

    public static void setUniqID(Message msg) {
        if (msg.getProperty("UNIQ_KEY") == null) {
            msg.putProperty("UNIQ_KEY", MessageClientIDSetter.createUniqID());
        }
    }

    public static String getUniqID(Message msg) {
        return msg.getProperty("UNIQ_KEY");
    }

    public static byte[] createFakeIP() {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(System.currentTimeMillis());
        bb.position(4);
        byte[] fakeIP = new byte[4];
        bb.get(fakeIP);
        return fakeIP;
    }

    private static void printIP(byte[] ip) {
        String str = UtilAll.ipToIPv4Str(ip);
        System.out.println(str);
    }

    public static void main(String[] args) throws Exception {
        byte[] realIP = UtilAll.getIP();
        MessageClientIDSetter.printIP(realIP);
        if (realIP[3] > -8 && realIP[3] < -6) {
            System.out.println("true");
        }
        byte[] fakeIP = MessageClientIDSetter.createFakeIP();
        MessageClientIDSetter.printIP(fakeIP);
        byte[] innerIP = new byte[]{-84, 16, -39, 1};
        System.out.println("inner = " + UtilAll.isInternalIP(innerIP));
        System.out.println("end");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(1457442383176L);
        System.out.println(cal.getTime());
        cal.setTimeInMillis(1457442382996L);
        System.out.println(cal.getTime());
        MessageClientIDSetter.setStartTime(System.currentTimeMillis());
        Thread.currentThread();
        Thread.sleep(100L);
        MessageClientIDSetter.setStartTime(System.currentTimeMillis());
        long threeday = 259200000L;
        System.out.println(Long.toBinaryString(threeday));
        int d = Integer.parseInt("1111111111111111", 2);
        System.out.println(d);
        System.out.println(Short.MAX_VALUE);
        System.out.println(127);
        String id = MessageClientIDSetter.createUniqID();
        System.out.println(id);
        String ip = MessageClientIDSetter.getIPStrFromID(id);
        Date date = MessageClientIDSetter.getNearlyTimeFromID(id);
        System.out.println(ip);
        System.out.println(date.toString());
        System.out.println("end...");
        long begin = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            UUID.randomUUID().toString();
        }
        long end = System.currentTimeMillis();
        System.out.println(end - begin);
        begin = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            MessageClientIDSetter.createUniqID();
        }
        end = System.currentTimeMillis();
        System.out.println(end - begin);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            set.add(MessageClientIDSetter.createUniqID());
        }
        System.out.println(set.size());
        long testlong = 0x80000000L;
        System.out.println(testlong);
        System.out.println(UUID.randomUUID().toString());
        System.out.println(MessageClientIDSetter.createUniqID());
        for (int i = 0; i < 20; ++i) {
            Message test = new Message();
            MessageClientIDSetter.setUniqID(test);
            System.out.println(test.getProperty("UNIQ_KEY"));
        }
        System.out.println("end");
    }

    static {
        basePos = 0;
        sb = null;
        buffer = ByteBuffer.allocate(6);
        int len = 16;
        sb = new StringBuilder(len * 2);
        ByteBuffer tempBuffer = ByteBuffer.allocate(len - buffer.limit());
        tempBuffer.position(2);
        tempBuffer.putInt(UtilAll.getPid());
        tempBuffer.position(0);
        try {
            tempBuffer.put(UtilAll.getIP());
        }
        catch (Exception e) {
            tempBuffer.put(MessageClientIDSetter.createFakeIP());
        }
        tempBuffer.position(6);
        tempBuffer.putInt(MessageClientIDSetter.class.getClassLoader().hashCode());
        sb.append(UtilAll.bytes2string(tempBuffer.array()));
        basePos = sb.length();
        MessageClientIDSetter.setStartTime(System.currentTimeMillis());
        counter = 0;
    }
}

