/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.metaq.client.common.AllocateMessageQueueStrategyBean;
import com.taobao.metaq.client.common.AllocateMessageQueueStrategyListener;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class AllocateMessageQueueStrategyChanged {
    public static final String diamondSubStrategyDataId = "metaq.rebalance.strategy";
    public static final String diamondGroupId = "metaq";
    public static final String DEFAULT_STRATEGY = "com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely";
    public static final String NEW_LINE = "\r\n";
    private static Logger log = ClientLogger.getLog();
    private ManagerListener diamondManagerListener;

    public AllocateMessageQueueStrategyChanged(final String group, final AllocateMessageQueueStrategyListener listener) {
        try {
            String configInfo = Diamond.getConfig((String)diamondSubStrategyDataId, (String)diamondGroupId, (long)3000L);
            this.parserConfig(configInfo, group, listener);
        }
        catch (Throwable e) {
            log.warn("Allocate messageQueue strategy changed from diamond Exception. dataId={}, groupId={}", new Object[]{diamondSubStrategyDataId, diamondGroupId, e});
        }
        try {
            this.diamondManagerListener = new ManagerListener(){

                public void receiveConfigInfo(String configInfo) {
                    AllocateMessageQueueStrategyChanged.this.parserConfig(configInfo, group, listener);
                }

                public Executor getExecutor() {
                    return null;
                }
            };
            Diamond.addListener((String)diamondSubStrategyDataId, (String)diamondGroupId, (ManagerListener)this.diamondManagerListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void parserConfig(String configInfo, String group, AllocateMessageQueueStrategyListener listener) {
        if (configInfo != null) {
            boolean isChanged;
            AllocateMessageQueueStrategy allocateMessageQueueStrategy;
            String[] strategyJsonArr;
            HashMap<String, String> strategyMap = new HashMap<String, String>();
            for (String strategy : strategyJsonArr = configInfo.trim().split(NEW_LINE)) {
                AllocateMessageQueueStrategyBean bean = RemotingSerializable.fromJson(strategy, AllocateMessageQueueStrategyBean.class);
                strategyMap.put(bean.getGroup(), bean.getStrategy());
            }
            String name = (String)strategyMap.get(group);
            if (name == null) {
                name = DEFAULT_STRATEGY;
            }
            if ((allocateMessageQueueStrategy = this.selectStrategy(name)) != null && (isChanged = listener.strategyChanged(allocateMessageQueueStrategy))) {
                log.info("allocate messageQueue strategy changed from diamond. group={}, strategyName={}", (Object)group, (Object)name);
            }
        }
    }

    private AllocateMessageQueueStrategy selectStrategy(String strategyName) {
        try {
            return (AllocateMessageQueueStrategy)Class.forName(strategyName).newInstance();
        }
        catch (InstantiationException e) {
            log.warn("change allocate messageQueue strategy from diamond error. strategyName={}", (Object)strategyName, (Object)e);
        }
        catch (IllegalAccessException e) {
            log.warn("change allocate messageQueue strategy from diamond error. strategyName={}", (Object)strategyName, (Object)e);
        }
        catch (ClassNotFoundException e) {
            log.warn("change allocate messageQueue strategy from diamond error. strategyName={}", (Object)strategyName, (Object)e);
        }
        return null;
    }

    public void shutdown() {
        try {
            Diamond.removeListener((String)diamondSubStrategyDataId, (String)diamondGroupId, (ManagerListener)this.diamondManagerListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

