/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.manager.ManagerListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class MetaClientConfigChanged {
    public static final String DiamondDataIdProducerConfig = "metaq.producer.config";
    public static final String DiamondDataIdConsumerConfig = "metaq.consumer.config";
    private static final long AllowPushInterval = 60000L;
    private static Logger log = ClientLogger.getLog();
    private final long accessDiamondTimestamp = System.currentTimeMillis();
    private final String diamondDataId;
    private final String diamondGroup;
    private ManagerListener diamondManagerListener;

    public MetaClientConfigChanged(final String dataId, final String group, final Object obj) {
        this.diamondDataId = dataId;
        this.diamondGroup = group;
        try {
            Properties pro;
            String configInfo = Diamond.getConfig((String)dataId, (String)group, (long)3000L);
            if (configInfo != null && (pro = MixAll.string2Properties(configInfo)) != null) {
                log.info("MetaClientConfigChanged got diamond config, {} {}\n{}", new Object[]{dataId, group, configInfo});
                MixAll.properties2Object(pro, obj);
            }
        }
        catch (Throwable e) {
            log.warn(String.format("MetaClientConfigChanged Diamond.getConfig Exception. %s %s", dataId, group), e);
        }
        try {
            this.diamondManagerListener = new ManagerListener(){

                public void receiveConfigInfo(String configInfo) {
                    if (System.currentTimeMillis() - MetaClientConfigChanged.this.accessDiamondTimestamp > 60000L) {
                        try {
                            Properties pro;
                            if (configInfo != null && (pro = MixAll.string2Properties(configInfo)) != null) {
                                log.info("MetaClientConfigChanged got diamond config, {} {}\n{}", new Object[]{dataId, group, configInfo});
                                MixAll.properties2Object(pro, obj);
                            }
                        }
                        catch (Throwable e) {
                            log.warn(String.format("MetaClientConfigChanged Diamond.receiveConfigInfo Exception. %s %s", dataId, group), e);
                        }
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            };
            Diamond.addListener((String)dataId, (String)group, (ManagerListener)this.diamondManagerListener);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public void shutdown() {
        try {
            Diamond.removeListener((String)this.diamondDataId, (String)this.diamondGroup, (ManagerListener)this.diamondManagerListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

