/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.unit;

import com.ali.unit.rule.Router;
import com.ali.unit.rule.RouterForbiddenListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientAPIImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.aliyun.openservices.shade.org.apache.commons.lang.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class UnitCheckForbiddenHookImpl
implements CheckForbiddenHook {
    private static Logger log = ClientLogger.getLog();
    private static final Map<String, String> orderConfigTable = new HashMap<String, String>();
    private boolean isForbidden;
    private final MQClientAPIImpl client = new MQClientAPIImpl(new NettyClientConfig(), null);
    private ScheduledExecutorService scheduledExecutorService;

    public UnitCheckForbiddenHookImpl() {
        ClientConfig clientConfig = new ClientConfig();
        if (null == clientConfig.getNamesrvAddr()) {
            this.client.fetchNameServerAddr();
        } else {
            this.client.updateNameServerAddressList(clientConfig.getNamesrvAddr());
        }
        this.client.start();
        Router.registerForbiddenListener((RouterForbiddenListener)new RouterForbiddenListener(){

            public void onChanged(String forbiddenUserRule) {
                UnitCheckForbiddenHookImpl.this.isForbidden(forbiddenUserRule);
            }
        });
    }

    public void getOrderTopics() {
        try {
            if (this.isForbidden) {
                KVTable kvTable = this.client.getKVListByNamespace("ORDER_TOPIC_CONFIG", 3000L);
                this.changeTopics(kvTable.getTable());
            }
        }
        catch (Exception e) {
            log.error("[unit-check-forbidden] get all order topics from nameserver exception.", (Throwable)e);
        }
    }

    @Override
    public String hookName() {
        return "CheckForbiddenHook";
    }

    @Override
    public void checkForbidden(CheckForbiddenContext context) throws MQClientException {
        boolean isOrder;
        if (!context.isUnitMode()) {
            return;
        }
        if (StringUtils.isBlank((String)context.getMessage().getBuyerId())) {
            String errorMsg = String.format("send message failed, please set buyerId. topic=%s, currentUnit=%s", context.getMessage().getTopic(), Router.getCurrentUnit());
            log.error("[unit-check-forbidden] " + errorMsg);
            throw new MQClientException(204, errorMsg);
        }
        String buyerId = context.getMessage().getBuyerId();
        if (!Router.isInCurrentUnit((long)Long.parseLong(buyerId))) {
            String errorMsg = String.format("send message failed, buyerId is not in current unit. topic=%s, buyerId=%s, currentUnit=%s", context.getMessage().getTopic(), buyerId, Router.getCurrentUnit());
            log.error("[unit-check-forbidden] " + errorMsg);
            throw new MQClientException(204, errorMsg);
        }
        if (this.isForbidden && (isOrder = this.isOrderTopic(context.getMessage().getTopic()))) {
            String errorMsg = String.format("send message failed, because the forbidden user rule is open. topic=%s, isOrder=%s, currentUnit=%s", context.getMessage().getTopic(), isOrder, Router.getCurrentUnit());
            log.error("[unit-check-forbidden] " + errorMsg);
            throw new MQClientException(16, errorMsg);
        }
    }

    private void isForbidden(String forbiddenUserRule) {
        log.info("[forbidden-change] forbidden user rule changed. rule={}", (Object)forbiddenUserRule);
        if (StringUtils.isBlank((String)forbiddenUserRule)) {
            this.isForbidden = false;
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdownNow();
                this.scheduledExecutorService = null;
            }
        } else {
            this.isForbidden = true;
            this.getOrderTopics();
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "UnitCheckForbiddenHookThread");
                    }
                });
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UnitCheckForbiddenHookImpl.this.getOrderTopics();
                        }
                        catch (Throwable e) {
                            log.error("[UnitCheckForbiddenHookThread-error] scheduledExecutorService exception.", e);
                        }
                    }
                }, 60L, 60L, TimeUnit.SECONDS);
            }
        }
    }

    private synchronized void changeTopics(HashMap<String, String> orderConfigTable) {
        UnitCheckForbiddenHookImpl.orderConfigTable.clear();
        UnitCheckForbiddenHookImpl.orderConfigTable.putAll(orderConfigTable);
    }

    private synchronized boolean isOrderTopic(String topic) {
        return orderConfigTable.containsKey(topic);
    }
}

