/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.unit;

import com.ali.unit.rule.Router;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.FilterMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.FilterMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.taobao.metaq.client.unit.MessageRouteCallback;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class UnitFilterMessageHookImpl
implements FilterMessageHook {
    private MessageRouteCallback messageRoute = null;
    private static Logger log = ClientLogger.getLog();

    @Override
    public String hookName() {
        return "UnitFilterMessageHook";
    }

    @Override
    public void filterMessage(FilterMessageContext context) {
        List<MessageExt> msgs = context.getMsgList();
        if (!msgs.isEmpty()) {
            Iterator<MessageExt> msgIt = msgs.iterator();
            while (msgIt.hasNext()) {
                MessageExt msg = msgIt.next();
                if (!context.isUnitMode()) continue;
                String buyerId = msg.getBuyerId();
                if (!UtilAll.isBlank(buyerId)) {
                    if (Router.isInCurrentUnit((long)Long.parseLong(buyerId))) continue;
                    msgIt.remove();
                    if (!log.isDebugEnabled()) continue;
                    log.debug("[msg-filter] buyer not in current unit. buyerId={}, currentUnit={}, correctUnit={}", new Object[]{buyerId, Router.getCurrentUnit(), Router.getUnitByUserId((long)Long.parseLong(buyerId))});
                    continue;
                }
                if (this.messageRoute == null || UtilAll.isBlank(buyerId = this.messageRoute.handleRouteUser(msg).getBuyerId()) || Router.isInCurrentUnit((long)Long.parseLong(buyerId))) continue;
                msgIt.remove();
                if (!log.isDebugEnabled()) continue;
                log.debug("[msg-filter] buyer not in current unit. buyerId={}, currentUnit={}, correctUnit={}", new Object[]{buyerId, Router.getCurrentUnit(), Router.getUnitByUserId((long)Long.parseLong(buyerId))});
            }
        }
    }

    public void setMessageRoute(MessageRouteCallback messageRoute) {
        this.messageRoute = messageRoute;
    }
}

