/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobReader;
import COM.ibm.db2.app.ClobWithIO;
import COM.ibm.db2.app.ClobWriter;
import COM.ibm.db2.app.Lob;
import java.io.Reader;
import java.io.Writer;

class ClobWithCharBuffer
extends Lob
implements ClobWithIO {
    char[] buffer;
    int capacity;
    int count;

    ClobWithCharBuffer(char[] cArray) throws Exception {
        this.buffer = cArray;
        this.capacity = cArray.length;
        this.count = cArray.length;
    }

    ClobWithCharBuffer() throws Exception {
        this.capacity = 32;
        this.count = 0;
        this.buffer = new char[this.capacity];
    }

    public void close() {
        this.buffer = null;
        this.count = 0;
        this.capacity = 0;
    }

    void assertOpen() throws Exception {
        if (this.buffer == null) {
            throw new Exception("Clob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return this.count;
    }

    public Reader getReader() throws Exception {
        return new ClobReader(this);
    }

    public Writer getWriter() throws Exception {
        return new ClobWriter(this);
    }

    public synchronized void append(char[] cArray, int n, int n2) throws Exception {
        this.assertOpen();
        if (this.count + n2 <= this.capacity) {
            System.arraycopy(cArray, n, this.buffer, this.count, n2);
            this.count += n2;
            return;
        }
        int n3 = this.capacity + (int)((double)n2 * 1.2);
        char[] cArray2 = new char[n3];
        int n4 = this.count + n2;
        System.arraycopy(this.buffer, 0, cArray2, 0, this.count);
        System.arraycopy(cArray, n, cArray2, this.count, n2);
        this.capacity = n3;
        this.buffer = cArray2;
        this.count = n4;
    }

    public synchronized int substr(int n, char[] cArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = n3;
        if (n >= this.count) {
            n4 = 0;
        } else if (n + n3 > this.count) {
            n4 = this.count - (n + n3);
        }
        System.arraycopy(this.buffer, n, cArray, n2, n4);
        return n4;
    }
}

