/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected int maxFieldSize;
    protected DB2InputStream is;
    protected boolean closed = false;

    public DB2Blob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2Blob( stmt, " + n + ", " + n2 + " )");
        }
        DB2Connection dB2Connection = this.connection = (DB2Connection)dB2Statement.getConnection();
        synchronized (dB2Connection) {
            this.locator = n;
            this.lobType = n2;
            this.is = new DB2InputStream(dB2Statement, this.locator, this.lobType);
            this.statement = this.is.getStatement();
            this.closed = false;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "DB2Blob()");
        }
    }

    protected native int SQLGetBAPosition(int var1, Integer var2, byte[] var3, int var4);

    protected native int SQLGetBlobPosition(int var1, Integer var2, int var3, int var4);

    public void close() throws IOException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "close()");
        }
        if (!this.closed) {
            this.is.close();
        }
        this.closed = true;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
        }
    }

    public void finalize() throws IOException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "finalize()");
        }
        this.close();
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getBinaryStream()");
        }
        DB2InputStream dB2InputStream = null;
        try {
            dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            }
        }
        return dB2InputStream;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getBytes( " + l + ", " + n + " )");
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        this.is.moveTo((int)l);
        try {
            int n2 = this.is.read(byArray);
            if (n2 > 0) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getBytes()");
        }
        return byArray2;
    }

    final int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    public long length() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "length()");
        }
        long l = 0L;
        try {
            l = this.is.getLength();
        }
        finally {
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "length()", l);
            }
        }
        return l;
    }

    public long position(Blob blob, long l) throws SQLException {
        long l2;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "position( pattern, " + l + " )");
        }
        if (blob instanceof DB2Blob) {
            Integer n = new Integer(0);
            l2 = this.SQLGetBlobPosition(this.statement.statementHandle, n, ((DB2Blob)blob).getLocator(), (int)l);
        } else {
            long l3 = blob.length();
            byte[] byArray = blob.getBytes(0L, (int)l3);
            l2 = this.position(byArray, l);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "position()", l2);
        }
        return l2;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "position( pattern[], " + l + " )");
        }
        Integer n = new Integer(0);
        long l2 = this.SQLGetBAPosition(this.statement.statementHandle, n, byArray, (int)l);
        this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "position()", l2);
        }
        return l2;
    }
}

