/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement {
    private boolean wasNull = true;
    private int year = 0;
    private int month = 0;
    private int date = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;

    public DB2CallableStatement(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(string, dB2Connection, n, n2);
    }

    protected native int SQLBindOutParameter(int var1, int var2, int var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int var9, boolean var10);

    protected native byte[] SQLGetBinary(int var1, int[] var2, int[] var3);

    protected native String SQLGetChar(int var1, int var2, int[] var3, int[] var4);

    protected native void SQLGetDate(int var1, int[] var2, int[] var3);

    protected native double SQLGetDouble(int var1, int[] var2, int[] var3);

    protected native float SQLGetFloat(int var1, int[] var2, int[] var3);

    protected native int SQLGetInt(int var1, int[] var2, int[] var3);

    protected native long SQLGetLong(int var1, int[] var2, int[] var3);

    protected native String SQLGetNumericString(int var1, int var2, int[] var3, int[] var4);

    protected native int SQLGetShort(int var1, int[] var2, int[] var3);

    protected native void SQLGetTime(int var1, int[] var2, int[] var3);

    protected native void SQLGetTimestamp(int var1, int[] var2, int[] var3);

    protected native int SQLReBind(int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, int var8, boolean var9);

    protected native int SQLisNull(int var1, int[] var2);

    protected int SQLisNull2(int n) {
        return this.SQLisNull(n, this.indicators);
    }

    protected void checkParameters() throws SQLException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxNumParams) {
            if (this.direction[n2] == 4) {
                int n3 = this.sqltypes[n2];
                int n4 = this.scales[n2];
                switch (n3) {
                    case -7: 
                    case -6: {
                        n3 = 5;
                        break;
                    }
                    case -5: {
                        n3 = -5;
                        break;
                    }
                    case 7: {
                        n3 = this.connection.getRealSqlType();
                        break;
                    }
                    case 2: 
                    case 3: {
                        n = this.connection.getDecMaxLength(2, 4);
                        break;
                    }
                    case 2005: {
                        n3 = 41;
                        break;
                    }
                    case 2004: {
                        n3 = 31;
                        break;
                    }
                }
                int n5 = this.SQLBindOutParameter(this.direction[n2], n2 + 1, n3, n, n4, this.parameters, this.indicators, this.paramLengths, this.statementHandle, this.connection.isDescribeParamSupported());
                if (n5 != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, n5);
                }
            }
            ++n2;
        }
    }

    public Array getArray(int n) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n3 = this.validateParameter(n, 2);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetNumericString(n, this.connection.connectionHandle, this.parameters, this.indicators);
        }
        if (this.SQLisNull2(n) != 0) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (n2 == -1) {
            return new BigDecimal(string);
        }
        return new BigDecimal(string).setScale(n2, 4);
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.sqlExcptGen.checkParamIndex(n, this.maxNumParams);
        this.sqlExcptGen.check_address(this.parameters[n - 1], this.executed);
        int n2 = this.sqltypes[n - 1];
        if (n2 != -98) {
            this.sqlExcptGen.check_type(-2, n2);
        }
        int n3 = this.SQLGetInt(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return new DB2Blob(this, n3, n2);
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 5);
        int n3 = this.SQLGetShort(n, this.parameters, this.indicators);
        boolean bl = true;
        if (n3 == 0) {
            bl = false;
        }
        this.wasNull = this.SQLisNull2(n) != 0;
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 5);
        byte by = (byte)this.SQLGetShort(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return by;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n);
        int n3 = this.sqltypes[n2];
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "type", n3);
        }
        if (n3 != -2 && n3 != -3 && n3 != -4 && n3 != -98) {
            this.sqlExcptGen.throwTypeError();
        }
        byte[] byArray = this.SQLGetBinary(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            int n4 = 0;
            while (n4 < this.maxFieldSize) {
                byArray[n4] = byArray2[n4];
                ++n4;
            }
        }
        return byArray;
    }

    public Clob getClob(int n) throws SQLException {
        return null;
    }

    public Date getDate(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 91);
        this.SQLGetDate(n, this.parameters, this.indicators);
        if (this.year == -1 && this.month == -1 && this.date == -1) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return new Date(this.year - 1900, this.month - 1, this.date);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public double getDouble(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 8);
        double d = this.SQLGetDouble(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return d;
    }

    public float getFloat(int n) throws SQLException {
        float f;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 7);
        int n3 = this.connection.getRealSqlType();
        if (n3 == 7) {
            f = this.SQLGetFloat(n, this.parameters, this.indicators);
        } else {
            double d = this.SQLGetDouble(n, this.parameters, this.indicators);
            f = (float)d;
        }
        this.wasNull = this.SQLisNull2(n) != 0;
        return f;
    }

    public int getInt(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 4);
        int n3 = this.SQLGetInt(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return n3;
    }

    public long getLong(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, -5);
        long l = this.SQLGetLong(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return l;
    }

    public Object getObject(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n);
        Object object = null;
        int n3 = this.sqltypes[n - 1];
        int n4 = this.scales[n - 1];
        switch (n3) {
            case 12: {
                object = this.getString(n);
                break;
            }
            case 1: {
                object = this.getString(n);
                break;
            }
            case -1: {
                object = this.getString(n);
                break;
            }
            case 2: {
                object = this.getBigDecimal(n, n4);
                break;
            }
            case 3: {
                object = this.getBigDecimal(n, n4);
                break;
            }
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case -3: {
                object = this.getBytes(n);
                break;
            }
            case -4: {
                object = this.getBytes(n);
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n));
                break;
            }
            case 6: {
                object = new Double(this.getDouble(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            default: {
                this.sqlExcptGen.rsException("S1004");
            }
        }
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        return null;
    }

    public short getShort(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 5);
        short s = (short)this.SQLGetShort(n, this.parameters, this.indicators);
        this.wasNull = this.SQLisNull2(n) != 0;
        return s;
    }

    public String getString(int n) throws SQLException {
        String string;
        int n2;
        int n3;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if ((n3 = this.sqltypes[n2 = this.validateParameter(n)]) != 1 && n3 != 12 && n3 != -1 && n3 != -99) {
            this.sqlExcptGen.throwTypeError();
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetChar(n, this.connection.connectionHandle, this.parameters, this.indicators);
        }
        if (this.SQLisNull2(n) != 0) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        return string;
    }

    public Time getTime(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 92);
        this.SQLGetTime(n, this.parameters, this.indicators);
        if (this.hour == -1 && this.minute == -1 && this.second == -1) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return new Time(this.hour, this.minute, this.second);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n2 = this.validateParameter(n, 93);
        this.SQLGetTimestamp(n, this.parameters, this.indicators);
        if (this.year == -1 && this.month == -1 && this.date == -1) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return new Timestamp(this.year - 1900, this.month - 1, this.date, this.hour, this.minute, this.second, this.nano);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return null;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = n - 1;
        n2 = this.convert2SQLType(n2);
        if (this.direction[n4] == 0) {
            this.direction[n4] = 4;
            this.sqltypes[n4] = n2;
            this.ctypes[n4] = this.sqlType2cType(n2);
            this.scales[n4] = n3;
        } else if (this.direction[n4] == 1) {
            this.direction[n4] = 2;
            this.sqltypes[n4] = n2;
            if (n3 > this.scales[n4]) {
                this.scales[n4] = n3;
            }
        }
        this.executed = false;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2CallableStatement \r\n" + string + "{");
        stringBuffer.append(super.toString(String.valueOf(string) + "    ", bl));
        stringBuffer.append("\r\n" + string + "    wasNull = " + this.wasNull + "\r\n");
        return stringBuffer.toString();
    }

    private int validateParameter(int n) throws SQLException {
        return this.validateParameter(n, 0, false);
    }

    private int validateParameter(int n, int n2) throws SQLException {
        return this.validateParameter(n, n2, true);
    }

    private int validateParameter(int n, int n2, boolean bl) throws SQLException {
        int n3;
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (!this.executed) {
            this.sqlExcptGen.throwNotExecutedError();
        }
        if (this.direction[n3 = n - 1] != 4 && this.direction[n3] != 2) {
            this.sqlExcptGen.throwNotOutputParameterError();
        }
        if (bl && this.sqltypes[n3] != n2) {
            this.sqlExcptGen.throwTypeError();
        }
        return n3;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

