/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2Connection;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public class DB2CallableStatementTrace
extends DB2CallableStatement {
    protected double timerSeconds = 0.0;

    public DB2CallableStatementTrace(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
        DB2Trace.getTraceObj().traceEntry(this, "DB2CallableStatement(" + string + ")");
        DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
        DB2Trace.getTraceObj().traceExit(this, "DB2CallableStatement");
    }

    public void cancel() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "cancel()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.cancel();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj().traceExit(this, "cancel - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "clearParameters()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.clearParameters();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj().traceExit(this, "clearParameters - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "clearWarnings()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.clearWarnings();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj().traceExit(this, "clearWarnings - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void close() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "close()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.close();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj().traceExit(this, "close - Time Elapsed = " + this.timerSeconds);
        }
    }

    public boolean execute() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "execute()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.execute();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + bl);
            boolean bl2 = bl;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "execute - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "execute - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "executeQuery()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            ResultSet resultSet = super.executeQuery();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            ResultSet resultSet2 = resultSet;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "executeQuery - Time Elapsed = " + this.timerSeconds);
            return resultSet2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "executeQuery - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "executeUpdate()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.executeUpdate();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "executeUpdate - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "executeUpdate - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public void finalize() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "finalize()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.finalize();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var2_3 = null;
            DB2Trace.getTraceObj().traceExit(this, "finalize - Time Elapsed = " + this.timerSeconds);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getBigDecimal(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            BigDecimal bigDecimal = super.getBigDecimal(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + bigDecimal);
            BigDecimal bigDecimal2 = bigDecimal;
            Object var5_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBigDecimal - Time Elapsed = " + this.timerSeconds);
            return bigDecimal2;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBigDecimal - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getBoolean(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.getBoolean(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + bl);
            boolean bl2 = bl;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBoolean - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBoolean - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getByte(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            byte by = super.getByte(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + by);
            byte by2 = by;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getByte - Time Elapsed = " + this.timerSeconds);
            return by2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getByte - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getBytes(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            byte[] byArray = super.getBytes(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = ", byArray);
            byte[] byArray2 = byArray;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBytes - Time Elapsed = " + this.timerSeconds);
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getBytes - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getDate(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            Date date = super.getDate(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + date);
            Date date2 = date;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getDate - Time Elapsed = " + this.timerSeconds);
            return date2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getDate - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getDouble(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            double d = super.getDouble(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + d);
            double d2 = d;
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getDouble - Time Elapsed = " + this.timerSeconds);
            return d2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getDouble - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getFloat(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            float f = super.getFloat(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + f);
            float f2 = f;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getFloat - Time Elapsed = " + this.timerSeconds);
            return f2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getFloat - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getInt(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n2 = super.getInt(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n2);
            int n3 = n2;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getInt - Time Elapsed = " + this.timerSeconds);
            return n3;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getInt - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getLong(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            long l2 = super.getLong(n);
            long l3 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l3);
            DB2Trace.getTraceObj().println("Return value = " + l2);
            long l4 = l2;
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getLong - Time Elapsed = " + this.timerSeconds);
            return l4;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getLong - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getMaxFieldSize()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getMaxFieldSize();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMaxFieldSize - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMaxFieldSize - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getMaxRows()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getMaxRows();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMaxRows - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMaxRows - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getMoreResults()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.getMoreResults();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + bl);
            boolean bl2 = bl;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMoreResults - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getMoreResults - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getObject(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            Object object = super.getObject(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + object);
            Object object2 = object;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getObject - Time Elapsed = " + this.timerSeconds);
            return object2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getObject - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getQueryTimeout()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getQueryTimeout();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getQueryTimeout - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getQueryTimeout - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getResultSet()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            ResultSet resultSet = super.getResultSet();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            ResultSet resultSet2 = resultSet;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getResultSet - Time Elapsed = " + this.timerSeconds);
            return resultSet2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getResultSet - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getShort(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            short s = super.getShort(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + s);
            short s2 = s;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getShort - Time Elapsed = " + this.timerSeconds);
            return s2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getShort - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public String getString(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getString(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            String string = super.getString(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + string);
            String string2 = string;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getString - Time Elapsed = " + this.timerSeconds);
            return string2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getString - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getTime(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            Time time = super.getTime(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + time);
            Time time2 = time;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getTime - Time Elapsed = " + this.timerSeconds);
            return time2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getTime - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getTimestamp(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            Timestamp timestamp = super.getTimestamp(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + timestamp);
            Timestamp timestamp2 = timestamp;
            Object var4_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getTimestamp - Time Elapsed = " + this.timerSeconds);
            return timestamp2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "getTimestamp - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    public int getUpdateCount() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getUpdateCount()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            int n = super.getUpdateCount();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + n);
            int n2 = n;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getUpdateCount - Time Elapsed = " + this.timerSeconds);
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getUpdateCount - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "getWarnings()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            SQLWarning sQLWarning = super.getWarnings();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            SQLWarning sQLWarning2 = sQLWarning;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "getWarnings - Time Elapsed = " + this.timerSeconds);
            return sQLWarning2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "getWarnings - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "registerOutParameter(" + n + ", " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.registerOutParameter(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "registerOutParameter - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "registerOutParameter(" + n + ", " + n2 + ", " + n3 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.registerOutParameter(n, n2, n3);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "registerOutParameter - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setAsciiStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setAsciiStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "setAsciiStream - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setBigDecimal(" + n + ", " + bigDecimal + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBigDecimal(n, bigDecimal);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setBigDecimal - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setBinaryStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBinaryStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "setBinaryStream - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setBoolean(" + n + ", " + bl + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setBoolean(n, bl);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setBoolean - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setByte(" + n + ", " + by + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setByte(n, by);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setByte - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setBytes(" + n + ", " + byArray + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            DB2Trace.getTraceObj().println("Input bytes = ", byArray);
            long l = DB2Trace.timer();
            super.setBytes(n, byArray);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setBytes - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setCursorName(" + string + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setCursorName(string);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj().traceExit(this, "setCursorName - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setDate(" + n + ", " + date + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setDate(n, date);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setDate - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setDouble(" + n + ", " + d + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setDouble(n, d);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setDouble - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setEscapeProcessing(" + bl + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setEscapeProcessing(bl);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj().traceExit(this, "setEscapeProcessing - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setFloat(" + n + ", " + f + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setFloat(n, f);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setFloat - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setInt(" + n + ", " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setInt(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setInt - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setLong(" + n + ", " + l + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l2 = DB2Trace.timer();
            super.setLong(n, l);
            long l3 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l2, l3);
        }
        finally {
            Object var5_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setLong - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setMaxFieldSize(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setMaxFieldSize(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj().traceExit(this, "setMaxFieldSize - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setMaxRows(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setMaxRows(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj().traceExit(this, "setMaxRows - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setNull(" + n + ", " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setNull(n, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setNull - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setObject(" + n + ", " + object + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setObject(" + n + ", " + object + ", " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setObject(" + n + ", " + object + ", " + n2 + ", " + n3 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setObject(n, object, n2, n3);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var6_7 = null;
            DB2Trace.getTraceObj().traceExit(this, "setObject - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setQueryTimeout(" + n + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setQueryTimeout(n);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var3_4 = null;
            DB2Trace.getTraceObj().traceExit(this, "setQueryTimeout - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setShort(" + n + ", " + s + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setShort(n, s);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setShort - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setString(int n, String string) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setString(" + n + ", " + string + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setString(n, string);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setString - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setTime(" + n + ", " + time + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setTime(n, time);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setTime - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setTimestamp(" + n + ", " + timestamp + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setTimestamp(n, timestamp);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var4_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "setTimestamp - Time Elapsed = " + this.timerSeconds);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "setUnicodeStream(" + n + ", ~~, " + n2 + ")");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            super.setUnicodeStream(n, inputStream, n2);
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
        }
        finally {
            Object var5_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "setUnicodeStream - Time Elapsed = " + this.timerSeconds);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            DB2Trace.getTraceObj().traceEntry(this, "wasNull()");
            DB2Trace.getTraceObj().println("Statement handle = " + this.getTraceHandle());
            long l = DB2Trace.timer();
            boolean bl = super.wasNull();
            long l2 = DB2Trace.timer();
            this.timerSeconds = DB2Trace.computeTimeDiff(l, l2);
            DB2Trace.getTraceObj().println("Return value = " + bl);
            boolean bl2 = bl;
            Object var3_5 = null;
            DB2Trace.getTraceObj().traceExit(this, "wasNull - Time Elapsed = " + this.timerSeconds);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            DB2Trace.getTraceObj().traceExit(this, "wasNull - Time Elapsed = " + this.timerSeconds);
            throw throwable;
        }
    }
}

