/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected DB2CharReader reader = null;

    public DB2Clob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2Clob( stmt, " + n + ", " + n2 + " )");
        }
        this.locator = n;
        this.lobType = n2;
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.reader = new DB2CharReader(dB2Statement, n2, n);
        this.statement = this.reader.getStatement();
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "DB2Clob()");
        }
    }

    protected native int SQLGetClobPosition(Integer var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetStrPosition(Integer var1, int var2, String var3, int var4, int var5);

    public InputStream getAsciiStream() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getAsciiStream()");
        }
        DB2InputStream dB2InputStream = null;
        try {
            dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
            }
        }
        return dB2InputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getCharacterStream()");
            DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
        }
        return this.reader;
    }

    int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    public String getSubString(long l, int n) throws SQLException {
        String string;
        block8: {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getSubString( " + l + ", " + n + " )");
            }
            string = null;
            try {
                if (this.reader.markSupported()) {
                    try {
                        this.reader.moveTo((int)l);
                        char[] cArray = new char[n];
                        int n2 = this.reader.read(cArray);
                        string = new String(cArray, 0, n2);
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.toString());
                    }
                }
                this.connection.sqlExcptGen.throwNoRandomAccess();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "getSubString()", string);
                }
                throw throwable;
            }
        }
        Object var6_7 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getSubString()", string);
        }
        return string;
    }

    public long length() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "length()");
        }
        long l = 0L;
        try {
            l = this.reader.getLength();
        }
        finally {
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "length()", l);
            }
        }
        return l;
    }

    public long position(String string, long l) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "position( " + string + ", " + l + " )");
        }
        Integer n = new Integer(0);
        int n2 = this.SQLGetStrPosition(n, this.statement.statementHandle, string, (int)l, this.connection.connectionHandle);
        this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "position()", n2);
        }
        return n2;
    }

    public long position(Clob clob, long l) throws SQLException {
        long l2;
        Integer n = new Integer(0);
        if (clob instanceof DB2Clob) {
            int n2 = this.SQLGetClobPosition(n, this.statement.statementHandle, ((DB2Clob)clob).getLocator(), (int)l, this.connection.connectionHandle);
            this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
            l2 = n2;
        } else {
            String string = clob.getSubString(0L, (int)clob.length());
            l2 = this.position(string, l);
        }
        DB2Trace.methodExit((Object)this, "position()", l2);
        return l2;
    }
}

