/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ConnectionTrace;
import COM.ibm.db2.mri.DB2Messages;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DB2Driver
implements Driver {
    private static DB2Driver ourDriver = null;
    public static final int MajorVersion = 7;
    public static final int MinorVersion = 1;
    private static final String libraryName = "libdb2jdbc.so";
    private static final String HPlibraryName = "libdb2jdbc.sl";
    private static final String libpath_unix = "java12";
    private static final String libpath_nt = "bin";
    private static final String libpath_os2 = "dll";
    private static final String DLLName = "db2jdbc";
    private static final String MSDLLName = "db2jms";
    private static String language = "C";
    public static boolean loaded = false;
    protected int traceOn = 0;
    public static final String buildLevel = "n010504";

    static {
        try {
            if (ourDriver == null) {
                ourDriver = new DB2Driver();
                DriverManager.registerDriver(ourDriver);
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", sQLException.getMessage(), sQLException.getSQLState(), String.valueOf(sQLException.getErrorCode())};
            String string = new DB2Messages().getString("0645", stringArray);
            DriverManager.println(string);
        }
    }

    public DB2Driver() throws SQLException {
        if (!loaded) {
            Object object;
            Object object2;
            Object object3;
            this.traceOn = 0;
            String string = null;
            String string2 = null;
            try {
                string2 = System.getProperty("ibm.db2.instance.path");
                if (string2 != null) {
                    object3 = System.getProperty("file.separator");
                    object2 = System.getProperty("os.name");
                    if (object3 != null && object3.equals("/")) {
                        string = String.valueOf(string2) + "/" + libpath_unix + "/";
                        string = object2 != null && ((String)object2).startsWith("HP-UX") ? String.valueOf(string) + HPlibraryName : String.valueOf(string) + libraryName;
                        System.load(string);
                    } else {
                        string = String.valueOf(string2) + "\\";
                        if (object2 != null && ((String)object2).startsWith("OS/2")) {
                            string = String.valueOf(string) + "dll\\db2jdbc";
                        } else {
                            string = String.valueOf(string) + "bin\\";
                            object = System.getProperty("java.vendor");
                            string = object != null && ((String)object).toLowerCase().indexOf("microsoft") != -1 ? String.valueOf(string) + MSDLLName : String.valueOf(string) + DLLName;
                        }
                        string = String.valueOf(string) + ".dll";
                        System.load(string);
                    }
                } else {
                    object3 = System.getProperty("java.vendor");
                    if (object3 != null && object3.toLowerCase().indexOf("microsoft") != -1) {
                        System.loadLibrary(MSDLLName);
                    } else {
                        System.loadLibrary(DLLName);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String[] stringArray = new String[]{DLLName};
                String string3 = new DB2Messages().getString("0646", stringArray);
                DriverManager.println(string3);
                DriverManager.println(unsatisfiedLinkError.toString());
                throw new SQLException(unsatisfiedLinkError.toString());
            }
            int n = this.SQLAllocEnv();
            if (n != 0) {
                object3 = new String[]{String.valueOf(n)};
                object2 = new DB2Messages().getString("0647", (String[])object3);
                DriverManager.println((String)object2);
                throw new SQLException((String)object2);
            }
            if (this.traceOn == 1) {
                object3 = new Integer(0);
                object2 = new Integer(0);
                object = new Integer(0);
                String string4 = this.SQLGetTracePath((Integer)object3, (Integer)object2, (Integer)object);
                if ((Integer)object != 0) {
                    DB2Trace.setTraceFlush(true);
                }
                if (object3.intValue() == 0 && string4 != null) {
                    DB2Trace.setTracePath(string4);
                }
                if (!DB2Trace.isInitialized()) {
                    DB2Trace dB2Trace = new DB2Trace((Integer)object2);
                    DB2Trace.methodEntry(this, "DB2Driver()");
                    if (string2 != null) {
                        dB2Trace.println("Loaded " + string);
                    } else {
                        dB2Trace.println("Loaded db2jdbc from java.library.path");
                    }
                    DB2Trace.methodExit(this, "DB2Driver()");
                }
            }
            loaded = true;
        }
    }

    protected native int SQLAllocEnv();

    protected native int SQLFreeEnv();

    protected native String SQLGetTracePath(Integer var1, Integer var2, Integer var3);

    public boolean acceptsURL(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceEntry(this.getClass().getName(), "DB2Connection(" + string + ")");
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n = string.indexOf(58);
        string2 = string.substring(0, n);
        int n2 = string.indexOf(58, n + 1);
        string3 = string.substring(n + 1, n2);
        string4 = string.substring(n2 + 1);
        boolean bl = string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//");
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceExit(this.getClass().getName(), "DB2Connection - Return value = " + bl);
        }
        return bl;
    }

    public Connection connect() throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("language", language);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect()\n");
            return new DB2ConnectionTrace(properties, this);
        }
        return new DB2Connection(properties, this);
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        string2 = string.substring(0, n);
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            return null;
        }
        string3 = string.substring(n + 1, n2);
        string4 = string.substring(n2 + 1);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect(" + string + ")\n");
        }
        if (string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//")) {
            ((Hashtable)properties).put("language", language);
            if (DB2Trace.TraceOn) {
                return new DB2ConnectionTrace(string4, properties, this);
            }
            return new DB2Connection(string4, properties, this);
        }
        return null;
    }

    public void finalize() throws SQLException {
    }

    public native String getDLLVersion();

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{new DriverPropertyInfo("user", null), new DriverPropertyInfo("password", null)};
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("user")) {
                driverPropertyInfoArray[0].value = properties.getProperty("user");
                continue;
            }
            if (!string2.equals("password")) continue;
            driverPropertyInfoArray[1].value = properties.getProperty("password");
        }
        return driverPropertyInfoArray;
    }

    public int getRelease() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public String toString() {
        return "DB2Driver: JDBC 2.0 n010504";
    }
}

