/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ParameterMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement {
    protected String sql = null;
    protected short maxNumParams = 0;
    protected int[] parameters = null;
    protected int[] paramLengths = null;
    protected int[] indicators = null;
    protected int[] direction = null;
    protected int[] sqltypes = null;
    protected int[] ctypes = null;
    protected int[] maxWholeDigits = null;
    protected int[] scales = null;
    protected boolean[] sameType = null;
    protected boolean[] wasBound = null;
    protected ParamElement[] paramRow = null;
    protected Vector paramSet = null;
    protected static final int BUFLEN = 32699;
    protected static final int MAXCHAR = 254;
    protected static final int MAXVCHAR = 4000;
    protected static final int MAXLONG = 32700;
    protected boolean executed = false;

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(dB2Connection, n, n2);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + string + "\", con, " + n + ", " + n2 + " )");
        }
        this.sql = this.check4JSQL(string);
        this.returnCode = 0;
        DB2Connection dB2Connection2 = this.connection;
        synchronized (dB2Connection2) {
            this.maxNumParams = (short)this.SQLPrepare(this.sql, this.statementHandle, dB2Connection.connectionHandle);
        }
        if (this.returnCode != 0) {
            try {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
                this.maxNumParams = (short)this.SQLGetNumParams(this.statementHandle);
            }
            catch (SQLException sQLException) {
                this.close();
                throw sQLException;
            }
        }
        this.parameters = new int[this.maxNumParams];
        this.paramLengths = new int[this.maxNumParams];
        this.indicators = new int[this.maxNumParams];
        this.direction = new int[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.sameType = new boolean[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.paramSet = new Vector();
        this.paramRow = new ParamElement[this.maxNumParams];
        int n3 = 0;
        while (n3 < this.maxNumParams) {
            this.parameters[n3] = 0;
            this.paramLengths[n3] = 0;
            this.indicators[n3] = 0;
            this.direction[n3] = 0;
            this.sqltypes[n3] = 0;
            this.ctypes[n3] = 0;
            this.maxWholeDigits[n3] = 0;
            this.scales[n3] = 0;
            this.sameType[n3] = false;
            this.wasBound[n3] = false;
            this.paramRow[n3] = new ParamElement();
            ++n3;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
        }
    }

    protected native int SQLBindBigInt(int var1, int var2, long var3, int var5, int[] var6, int[] var7, int[] var8, int var9);

    protected native int SQLBindBigInt2(long var1, int var3, int var4);

    protected native int SQLBindBinary(int var1, int var2, int var3, byte[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int var9, boolean var10, boolean var11);

    protected native int SQLBindByteArrayArray(int var1, int var2, int var3, byte[][] var4, int[] var5, int var6);

    protected native int SQLBindChar(int var1, int var2, int var3, String var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int var10, int var11, boolean var12, boolean var13);

    protected native int SQLBindChar2(int var1, int var2, int var3, String var4, int var5, int[] var6, int var7, int[] var8, int var9, int[] var10, int var11, int var12);

    protected native int SQLBindDate(int var1, int var2, int var3, int var4, int var5, int var6, int[] var7, int[] var8, int[] var9, int var10);

    protected native int SQLBindDate2(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLBindDateArray(int var1, int var2, int var3, int[][] var4, int[] var5, int var6);

    protected native int SQLBindDouble(int var1, int var2, double var3, int var5, int[] var6, int[] var7, int[] var8, int var9);

    protected native int SQLBindDouble2(double var1, int var3, int var4);

    protected native int SQLBindDoubleArray(int var1, int var2, int var3, double[] var4, int[] var5, int var6);

    protected native int SQLBindFloatArray(int var1, int var2, int var3, float[] var4, int[] var5, int var6);

    protected native int SQLBindIntArray(int var1, int var2, int var3, int[] var4, int[] var5, int var6);

    protected native int SQLBindInteger(int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, int var8);

    protected native int SQLBindInteger2(int var1, int var2, int var3);

    protected native int SQLBindLob(int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, int var8);

    protected native int SQLBindLongArray(int var1, int var2, int var3, long[] var4, int[] var5, int var6);

    protected native int SQLBindNull(int var1, int var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int var8, boolean var9);

    protected native int SQLBindNull2(int var1);

    protected native int SQLBindNumeric(int var1, int var2, int var3, String var4, int var5, int var6, int[] var7, int[] var8, int[] var9, int var10);

    protected native int SQLBindNumericArray(int var1, int var2, int var3, String[] var4, int[] var5, int var6, int var7, int var8);

    protected native int SQLBindReal(int var1, int var2, int var3, float var4, int[] var5, int[] var6, int[] var7, int var8);

    protected native int SQLBindReal2(float var1, int var2, int var3);

    protected native int SQLBindShortArray(int var1, int var2, int var3, short[] var4, int[] var5, int var6);

    protected native int SQLBindSmallInt(int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, int var8);

    protected native int SQLBindSmallInt2(int var1, int var2, int var3);

    protected native int SQLBindStream(int var1, int var2, int var3, int var4, int var5, boolean var6, int[] var7, int[] var8, int[] var9, int[] var10, int var11, boolean var12);

    protected native int SQLBindStringArray(int var1, int var2, int var3, String[] var4, int[] var5, int var6, int var7);

    protected native int SQLBindTime(int var1, int var2, int var3, int var4, int var5, int var6, int[] var7, int[] var8, int[] var9, int var10);

    protected native int SQLBindTime2(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLBindTimeArray(int var1, int var2, int var3, int[][] var4, int[] var5, int var6);

    protected native int SQLBindTimestamp(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int[] var11, int[] var12, int[] var13, int var14);

    protected native int SQLBindTimestamp2(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    protected native int SQLBindTimestampArray(int var1, int var2, int var3, int[][] var4, int[] var5, int var6);

    protected native int SQLExecBatchData(int var1, int[] var2, int var3);

    protected native int SQLExecute(int var1, int var2);

    protected native int SQLFreeStmtClearParameters(int var1);

    protected native int SQLGetNumParams(int var1);

    protected native int SQLParamData(int var1);

    protected native int SQLPrepare(String var1, int var2, int var3);

    protected native int SQLPutByteData(byte[] var1, int var2, int var3);

    protected native int SQLPutStringData(String var1, int var2, int var3, int var4);

    public void addBatch() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "addBatch()");
        }
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.paramSet.addElement(this.paramRow);
        this.paramRow = new ParamElement[this.maxNumParams];
        int n = 0;
        while (n < this.maxNumParams) {
            this.paramRow[n] = new ParamElement();
            ++n;
        }
        ++this.batchSize;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "addBatch()");
        }
    }

    private String check4JSQL(String string) throws SQLException {
        if (string.startsWith("#")) {
            int n;
            int n2;
            int n3;
            int n4;
            this.isJSQL = true;
            String string2 = string.substring(string.indexOf("{"));
            int n5 = string.indexOf(",");
            int n6 = Integer.parseInt(string.substring(1, n5));
            if (n6 > 0) {
                int[] nArray = new int[n6];
                n4 = 0;
                ++n5;
                n3 = 0;
                while (n3 < n6) {
                    n4 = string.indexOf(",", n5);
                    nArray[n3] = Integer.parseInt(string.substring(n5, n4));
                    n5 = n4 + 1;
                    ++n3;
                }
                this.colCount4JSQL = n6;
                this.colNames4JSQL = new String[n6];
                n2 = 0;
                while (n2 < n6) {
                    n4 = n5 + nArray[n2];
                    this.colNames4JSQL[n2] = new String(string.substring(n5, n4));
                    n5 = n4;
                    ++n2;
                }
            }
            if ((n4 = Integer.parseInt(string.substring(++n5, n = string.indexOf(",", n5)))) > 0) {
                n5 = n + 1;
                n = string.indexOf(",", n5);
                n3 = Integer.parseInt(string.substring(n5, n));
                n5 = n + 1;
                n = string.indexOf(",", n5);
                n2 = Integer.parseInt(string.substring(n5, n));
                String string3 = string2.substring(n3, n2);
                n5 = n + 1;
                n = n5 + n4;
                String string4 = String.valueOf(new String(string.substring(n5, n))) + "," + string3;
                this.setCursorName(string4);
            }
            return string2;
        }
        return string;
    }

    protected void checkParameters() throws SQLException {
    }

    public void clearBatch() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "clearBatch()");
        }
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.batchSize = 0;
        this.paramSet = new Vector();
        this.paramRow = new ParamElement[this.maxNumParams];
        int n = 0;
        while (n < this.maxNumParams) {
            this.paramRow[n] = new ParamElement();
            ++n;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "clearBatch()");
        }
    }

    public void clearParameters() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.freeArrays(this.maxNumParams, this.parameters, this.indicators, this.paramLengths);
        int n = 0;
        while (n < this.maxNumParams) {
            this.parameters[n] = 0;
            this.paramLengths[n] = 0;
            this.indicators[n] = 0;
            this.direction[n] = 0;
            this.sqltypes[n] = 0;
            this.ctypes[n] = 0;
            this.maxWholeDigits[n] = 0;
            this.scales[n] = 0;
            this.sameType[n] = false;
            this.wasBound[n] = false;
            this.paramRow[n].unset();
            ++n;
        }
        this.SQLFreeStmtClearParameters(this.statementHandle);
    }

    protected void close2(boolean bl) throws SQLException {
        if (!this.closed) {
            super.close2(bl);
            if (this.parameters != null) {
                this.freeArrays(this.maxNumParams, this.parameters, this.indicators, this.paramLengths);
            }
        }
    }

    protected int convert2SQLType(int n) throws SQLException {
        int n2 = n;
        switch (n2) {
            case -7: 
            case -6: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case -5: {
                n2 = -5;
                break;
            }
            case 7: {
                n2 = this.connection.getRealSqlType();
                break;
            }
            case 2004: {
                n2 = -98;
                break;
            }
            case 2005: {
                n2 = -99;
                break;
            }
        }
        return n2;
    }

    public boolean execute() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.execute2();
        this.getResultSet();
        return this.colCount > 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute2() throws SQLException {
        block35: {
            block34: {
                this.moreResults = true;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute2()");
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    this.warnings = null;
                    this.batchReturn = null;
                    var3_1 = 0;
                    while (true) {
                        block36: {
                            block38: {
                                block37: {
                                    if (var3_1 >= this.maxNumParams) {
                                        if (this.resultSet != null) {
                                            this.resultSet.close2(true);
                                            this.resultSet.setClosed(false);
                                        }
                                        this.rowCount = 0;
                                        this.colCount = 0;
                                        this.checkParameters();
                                        this.returnCode = 0;
                                        this.returnCode = this.SQLExecute(this.statementHandle, this.connection.connectionHandle);
                                        if (this.returnCode == 99) {
                                            this.returnCode = this.loadParameters();
                                        }
                                        if (this.returnCode != 100) break;
                                        this.rowCount = 0;
                                        var2_6 = null;
                                        if (DB2Trace.TraceOn == false) return;
                                        break block34;
                                    }
                                    if (!this.paramRow[var3_1].isSet()) break block36;
                                    var4_2 = this.paramRow[var3_1].getValue();
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.data(10, "wasBound[" + var3_1 + "] = " + this.wasBound[var3_1]);
                                        DB2Trace.data(10, "sqltypes[" + var3_1 + "] = " + this.sqltypes[var3_1]);
                                        DB2Trace.data(10, "ctypes[" + var3_1 + "] = " + this.ctypes[var3_1]);
                                    }
                                    if (var4_2 != null) break block37;
                                    var5_3 = this.wasBound[var3_1] == false ? this.SQLBindNull(this.direction[var3_1], var3_1 + 1, this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.sqltypes, this.statementHandle, this.direction[var3_1] == 2 && this.connection.isDescribeParamSupported() != false) : this.SQLBindNull2(this.indicators[var3_1]);
                                    this.sqlExcptGen.check_return_code(this, var5_3);
                                    break block38;
                                }
                                switch (this.ctypes[var3_1]) {
                                    case -25: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindBigInt(this.direction[var3_1], var3_1 + 1, ((PrimitiveData)var4_2).longValue(), this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindBigInt2(((PrimitiveData)var4_2).longValue(), this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 4: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindInteger(this.direction[var3_1], var3_1 + 1, ((PrimitiveData)var4_2).intValue(), this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindInteger2(((PrimitiveData)var4_2).intValue(), this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case -7: 
                                    case -6: 
                                    case 5: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindSmallInt(this.direction[var3_1], var3_1 + 1, ((PrimitiveData)var4_2).shortValue(), this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindSmallInt2(((PrimitiveData)var4_2).shortValue(), this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 7: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindReal(this.direction[var3_1], this.sqltypes[var3_1], var3_1 + 1, ((PrimitiveData)var4_2).floatValue(), this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindReal2(((PrimitiveData)var4_2).floatValue(), this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 8: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindDouble(this.direction[var3_1], var3_1 + 1, ((PrimitiveData)var4_2).doubleValue(), this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindDouble2(((PrimitiveData)var4_2).doubleValue(), this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case -8: 
                                    case 1: {
                                        if (!this.paramRow[var3_1].isStream()) ** GOTO lbl70
                                        if (this.direction[var3_1] == 2 && this instanceof DB2CallableStatement) {
                                            this.sqlExcptGen.pstmtException("S1003");
                                            var5_3 = -1;
                                        } else {
                                            var5_3 = this.SQLBindStream(this.direction[var3_1], this.sqltypes[var3_1], this.ctypes[var3_1], var3_1 + 1, this.paramRow[var3_1].getLength(), this.paramRow[var3_1].doConversion(), this.parameters, this.indicators, this.paramLengths, this.sqltypes, this.statementHandle, this.connection.isDescribeParamSupported());
                                        }
                                        ** GOTO lbl82
lbl70:
                                        // 1 sources

                                        if (this.sqltypes[var3_1] == 2 || this.sqltypes[var3_1] == 3) {
                                            var6_4 = 0;
                                            var6_4 = this.direction[var3_1] == 2 ? this.connection.getDecMaxLength(2, 4) : this.paramRow[var3_1].getLength();
                                            var5_3 = this.SQLBindNumeric(this.direction[var3_1], this.sqltypes[var3_1], var3_1 + 1, (String)var4_2, var6_4, this.scales[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle);
                                        } else {
                                            var6_5 = this.connection;
                                            synchronized (var6_5) {
                                                var5_3 = this.wasBound[var3_1] == false ? this.SQLBindChar(this.direction[var3_1], this.sqltypes[var3_1], var3_1 + 1, (String)var4_2, this.scales[var3_1], this.parameters, this.indicators, this.paramLengths, this.sqltypes, this.statementHandle, this.connection.connectionHandle, this.isJSQL, this.direction[var3_1] == 2 && this.connection.isDescribeParamSupported() != false) : this.SQLBindChar2(this.direction[var3_1], this.sqltypes[var3_1], var3_1 + 1, (String)var4_2, this.parameters[var3_1], this.parameters, this.indicators[var3_1], this.indicators, this.paramLengths[var3_1], this.paramLengths, this.statementHandle, this.connection.connectionHandle);
                                            }
                                        }
lbl82:
                                        // 4 sources

                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case -2: {
                                        if (this.paramRow[var3_1].isStream()) {
                                            if (this.direction[var3_1] == 2 && this instanceof DB2CallableStatement) {
                                                this.sqlExcptGen.pstmtException("S1003");
                                                break;
                                            }
                                            var5_3 = this.SQLBindStream(this.direction[var3_1], this.sqltypes[var3_1], this.ctypes[var3_1], var3_1 + 1, this.paramRow[var3_1].getLength(), this.paramRow[var3_1].doConversion(), this.parameters, this.indicators, this.paramLengths, this.sqltypes, this.statementHandle, this.connection.isDescribeParamSupported());
                                            this.sqlExcptGen.check_return_code(this, var5_3);
                                            break;
                                        }
                                        var5_3 = this.SQLBindBinary(this.direction[var3_1], this.sqltypes[var3_1], var3_1 + 1, (byte[])var4_2, this.parameters, this.indicators, this.paramLengths, this.sqltypes, this.statementHandle, this.isJSQL, this.direction[var3_1] == 2 && this.connection.isDescribeParamSupported() != false);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 31: {
                                        var6_4 = ((DB2Blob)var4_2).getLocator();
                                        var5_3 = this.SQLBindLob(this.direction[var3_1], var3_1 + 1, var6_4, this.ctypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case -351: 
                                    case 41: {
                                        var6_4 = ((DB2Clob)var4_2).getLocator();
                                        var5_3 = this.SQLBindLob(this.direction[var3_1], var3_1 + 1, var6_4, this.ctypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 9: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindDate(this.direction[var3_1], var3_1 + 1, ((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindDate2(((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 10: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindTime(this.direction[var3_1], var3_1 + 1, ((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindTime2(((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    case 11: {
                                        var5_3 = this.wasBound[var3_1] == false ? this.SQLBindTimestamp(this.direction[var3_1], var3_1 + 1, ((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], ((int[])var4_2)[3], ((int[])var4_2)[4], ((int[])var4_2)[5], ((int[])var4_2)[6], this.sqltypes[var3_1], this.parameters, this.indicators, this.paramLengths, this.statementHandle) : this.SQLBindTimestamp2(((int[])var4_2)[0], ((int[])var4_2)[1], ((int[])var4_2)[2], ((int[])var4_2)[3], ((int[])var4_2)[4], ((int[])var4_2)[5], ((int[])var4_2)[6], this.parameters[var3_1], this.indicators[var3_1]);
                                        this.sqlExcptGen.check_return_code(this, var5_3);
                                        break;
                                    }
                                    default: {
                                        this.sqlExcptGen.pstmtException("S1003");
                                        break;
                                    }
                                }
                            }
                            this.wasBound[var3_1] = true;
                        }
                        ++var3_1;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    this.executed = true;
                    break block35;
                }
                catch (Throwable var1_9) {
                    var2_8 = null;
                    if (DB2Trace.TraceOn == false) throw var1_9;
                    DB2Trace.data(20, "rowCount", this.rowCount);
                    DB2Trace.data(20, "colCount", this.colCount);
                    DB2Trace.methodExit(this, "execute2()");
                    throw var1_9;
                }
            }
            DB2Trace.data(20, "rowCount", this.rowCount);
            DB2Trace.data(20, "colCount", this.colCount);
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        var2_7 = null;
        if (DB2Trace.TraceOn == false) return;
        DB2Trace.data(20, "rowCount", this.rowCount);
        DB2Trace.data(20, "colCount", this.colCount);
        DB2Trace.methodExit(this, "execute2()");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        try {
            block74: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "executeBatch()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                this.batchReturn = new int[this.batchSize];
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.batchSize == 0) break block74;
                var4_6 = 0;
                while (true) {
                    if (var4_6 >= this.batchSize) {
                        if (!DB2PreparedStatement.isQuery(this.sql)) break;
                        throw new BatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn);
                    }
                    this.batchReturn[var4_6] = -3;
                    ++var4_6;
                }
                var5_7 = new ParamElement[this.batchSize][this.maxNumParams];
                var6_8 = 0;
                var7_9 = this.paramSet.elements();
                while (true) {
                    if (!var7_9.hasMoreElements()) break;
                    var5_7[var6_8++] = (ParamElement[])var7_9.nextElement();
                }
                var8_10 = null;
                var9_11 = new int[this.batchSize];
                var10_12 = 0;
                var6_8 = 0;
                while (true) {
                    if (var6_8 >= this.maxNumParams) break;
                    block1 : switch (this.ctypes[var6_8]) {
                        case -25: {
                            var11_13 = new long[this.batchSize];
                            var12_15 = 0;
                            while (true) {
                                if (var12_15 >= this.batchSize) {
                                    var10_12 = this.SQLBindLongArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var11_13, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var12_15][var6_8], var12_15, var6_8)) {
                                    var8_10 = var5_7[var12_15][var6_8].getValue();
                                    var9_11[var12_15] = var5_7[var12_15][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var11_13[var12_15] = ((PrimitiveData)var8_10).longValue();
                                    }
                                }
                                ++var12_15;
                            }
                        }
                        case 4: {
                            var12_16 = new int[this.batchSize];
                            var13_17 = 0;
                            while (true) {
                                if (var13_17 >= this.batchSize) {
                                    var10_12 = this.SQLBindIntArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var12_16, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var13_17][var6_8], var13_17, var6_8)) {
                                    var8_10 = var5_7[var13_17][var6_8].getValue();
                                    var9_11[var13_17] = var5_7[var13_17][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var12_16[var13_17] = ((PrimitiveData)var8_10).intValue();
                                    }
                                }
                                ++var13_17;
                            }
                        }
                        case -7: 
                        case -6: 
                        case 5: {
                            var13_18 = new short[this.batchSize];
                            var14_19 = 0;
                            while (true) {
                                if (var14_19 >= this.batchSize) {
                                    var10_12 = this.SQLBindShortArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var13_18, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var14_19][var6_8], var14_19, var6_8)) {
                                    var8_10 = var5_7[var14_19][var6_8].getValue();
                                    var9_11[var14_19] = var5_7[var14_19][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var13_18[var14_19] = ((PrimitiveData)var8_10).shortValue();
                                    }
                                }
                                ++var14_19;
                            }
                        }
                        case 7: {
                            var14_20 = new float[this.batchSize];
                            var15_21 = 0;
                            while (true) {
                                if (var15_21 >= this.batchSize) {
                                    var10_12 = this.SQLBindFloatArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var14_20, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var15_21][var6_8], var15_21, var6_8)) {
                                    var8_10 = var5_7[var15_21][var6_8].getValue();
                                    var9_11[var15_21] = var5_7[var15_21][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var14_20[var15_21] = ((PrimitiveData)var8_10).floatValue();
                                    }
                                }
                                ++var15_21;
                            }
                        }
                        case 8: {
                            var15_22 = new double[this.batchSize];
                            var16_23 = 0;
                            while (true) {
                                if (var16_23 >= this.batchSize) {
                                    var10_12 = this.SQLBindDoubleArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var15_22, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var16_23][var6_8], var16_23, var6_8)) {
                                    var8_10 = var5_7[var16_23][var6_8].getValue();
                                    var9_11[var16_23] = var5_7[var16_23][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var15_22[var16_23] = ((PrimitiveData)var8_10).doubleValue();
                                    }
                                }
                                ++var16_23;
                            }
                        }
                        case -8: {
                            var16_24 = new String[this.batchSize];
                            if (this.sqltypes[var6_8] != 2 && this.sqltypes[var6_8] != 3) ** GOTO lbl124
                            var17_25 = 0;
                            while (true) {
                                if (var17_25 < this.batchSize) ** GOTO lbl117
                                var10_12 = this.SQLBindNumericArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var16_24, var9_11, this.maxWholeDigits[var6_8] + this.scales[var6_8], this.scales[var6_8], this.statementHandle);
                                ** GOTO lbl140
lbl117:
                                // 1 sources

                                if (!this.isElementNull(var5_7[var17_25][var6_8], var17_25, var6_8)) {
                                    var8_10 = var5_7[var17_25][var6_8].getValue();
                                    var9_11[var17_25] = var5_7[var17_25][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var16_24[var17_25] = (String)var8_10;
                                    }
                                }
                                ++var17_25;
                            }
lbl124:
                            // 1 sources

                            var17_25 = 0;
                            while (true) {
                                if (var17_25 >= this.batchSize) {
                                    var10_12 = this.SQLBindStringArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var16_24, var9_11, this.statementHandle, this.connection.connectionHandle);
                                    break;
                                }
                                if (!this.isElementNull(var5_7[var17_25][var6_8], var17_25, var6_8)) {
                                    var8_10 = var5_7[var17_25][var6_8].getValue();
                                    var9_11[var17_25] = var5_7[var17_25][var6_8].getLength();
                                    if (var8_10 != null) {
                                        if (var5_7[var17_25][var6_8].isStream()) {
                                            var9_11[var17_25] = -2;
                                        } else {
                                            var16_24[var17_25] = (String)var8_10;
                                            var9_11[var17_25] = var5_7[var17_25][var6_8].getLength();
                                        }
                                    }
                                }
                                ++var17_25;
                            }
lbl140:
                            // 2 sources

                            this.sqlExcptGen.check_return_code(this, var10_12);
                            break;
                        }
                        case -2: {
                            var17_26 = new byte[this.batchSize][];
                            var18_27 = 0;
                            while (true) {
                                if (var18_27 >= this.batchSize) {
                                    var10_12 = this.SQLBindByteArrayArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var17_26, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (var8_10 != null) {
                                    var8_10 = var5_7[var18_27][var6_8].getValue();
                                    if (var5_7[var18_27][var6_8].isStream()) {
                                        var9_11[var18_27] = -2;
                                    } else {
                                        var9_11[var18_27] = var5_7[var18_27][var6_8].getLength();
                                        var17_26[var18_27] = new byte[var9_11[var18_27]];
                                        System.arraycopy((byte[])var8_10, 0, var17_26[var18_27], 0, var9_11[var18_27]);
                                    }
                                }
                                ++var18_27;
                            }
                        }
                        case 9: {
                            var18_28 = new int[this.batchSize][3];
                            var19_29 = 0;
                            while (true) {
                                if (var19_29 >= this.batchSize) {
                                    var10_12 = this.SQLBindDateArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var18_28, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var19_29][var6_8], var19_29, var6_8)) {
                                    var8_10 = var5_7[var19_29][var6_8].getValue();
                                    var9_11[var19_29] = var5_7[var19_29][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var20_31 /* !! */  = (int[][])((int[])var8_10);
                                        System.arraycopy(var20_31 /* !! */ , 0, var18_28[var19_29], 0, 3);
                                    }
                                }
                                ++var19_29;
                            }
                        }
                        case 10: {
                            var19_30 = new int[this.batchSize][3];
                            var20_32 = 0;
                            while (true) {
                                if (var20_32 >= this.batchSize) {
                                    var10_12 = this.SQLBindTimeArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var19_30, var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var20_32][var6_8], var20_32, var6_8)) {
                                    var8_10 = var5_7[var20_32][var6_8].getValue();
                                    var9_11[var20_32] = var5_7[var20_32][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var21_33 = (int[])var8_10;
                                        System.arraycopy(var21_33, 0, var19_30[var20_32], 0, 3);
                                    }
                                }
                                ++var20_32;
                            }
                        }
                        case 11: {
                            var20_31 /* !! */  = new int[this.batchSize][7];
                            var21_34 = 0;
                            while (true) {
                                if (var21_34 >= this.batchSize) {
                                    var10_12 = this.SQLBindTimestampArray(var6_8 + 1, this.sqltypes[var6_8], this.batchSize, var20_31 /* !! */ , var9_11, this.statementHandle);
                                    this.sqlExcptGen.check_return_code(this, var10_12);
                                    break block1;
                                }
                                if (!this.isElementNull(var5_7[var21_34][var6_8], var21_34, var6_8)) {
                                    var8_10 = var5_7[var21_34][var6_8].getValue();
                                    var9_11[var21_34] = var5_7[var21_34][var6_8].getLength();
                                    if (var8_10 != null) {
                                        var22_35 = (int[])var8_10;
                                        System.arraycopy(var22_35, 0, var20_31 /* !! */ [var21_34], 0, 7);
                                    }
                                }
                                ++var21_34;
                            }
                        }
                        default: {
                            this.isElementNull(var5_7[0][var6_8], 0, var6_8);
                            break;
                        }
                    }
                    ++var6_8;
                }
                var10_12 = this.SQLExecBatchData(this.batchSize, this.batchReturn, this.statementHandle);
                var11_14 = 0;
                while (true) {
                    if (var11_14 >= this.batchReturn.length) break;
                    switch (this.batchReturn[var11_14]) {
                        case 0: 
                        case 6: {
                            this.batchReturn[var11_14] = -2;
                            break;
                        }
                        case 5: {
                            this.batchReturn[var11_14] = -3;
                            break;
                        }
                        case 7: {
                            this.batchReturn[var11_14] = 0;
                            break;
                        }
                    }
                    ++var11_14;
                }
                this.clearBatch();
                this.sqlExcptGen.check_batch_return_code(this, var10_12);
                var1_2 = this.batchReturn;
                var3_4 = null;
                if (DB2Trace.TraceOn == false) return var1_2;
                DB2Trace.methodExit(this, "executeBatch()");
                return var1_2;
            }
            var1_1 = this.batchReturn;
            var3_3 = null;
            if (DB2Trace.TraceOn == false) return var1_1;
        }
        catch (Throwable var2_36) {
            var3_5 = null;
            if (DB2Trace.TraceOn == false) throw var2_36;
            DB2Trace.methodExit(this, "executeBatch()");
            throw var2_36;
        }
        DB2Trace.methodExit(this, "executeBatch()");
        return var1_1;
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute2();
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "executeUpdate()");
        }
        this.execute2();
        int n = this.getUpdateCount();
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "executeUpdate()");
        }
        return n;
    }

    protected native void freeArrays(int var1, int[] var2, int[] var3, int[] var4);

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSetMetaData();
    }

    public DB2ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        return new DB2ParameterMetaData(this);
    }

    public DB2ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        return new DB2ResultSetMetaData(this);
    }

    protected final boolean isElementNull(ParamElement paramElement, int n, int n2) throws SQLException {
        if (!paramElement.isSet()) {
            this.sqlExcptGen.throwNotSet(n, n2, this.batchReturn);
        }
        return false;
    }

    private static boolean isQuery(String string) {
        return string.trim().substring(0, 6).equalsIgnoreCase("select");
    }

    protected int loadParameters() throws SQLException {
        byte[] byArray = new byte[32699];
        int n = -1;
        try {
            this.returnCode = 0;
            n = this.SQLParamData(this.statementHandle);
            while (this.returnCode == 99) {
                int n2;
                Closeable closeable;
                int n3 = this.maxFieldSize;
                int n4 = n3 != 0 ? Math.min(this.paramRow[n - 1].getLength(), n3) : this.paramRow[n - 1].getLength();
                if (this.paramRow[n - 1].doConversion()) {
                    closeable = new BufferedReader((Reader)this.paramRow[n - 1].getValue());
                    n2 = this.paramRow[n - 1].getLength();
                    int n5 = Math.min(16349, n2);
                    char[] cArray = new char[n5];
                    while (n2 != 0) {
                        int n6;
                        int n7 = 0;
                        n5 = Math.min(16349, n2);
                        while (n7 < n5 && (cArray[n7] = (char)((BufferedReader)closeable).read()) != '\uffffffff') {
                            ++n7;
                        }
                        if (n7 == 0) {
                            n2 = 0;
                            continue;
                        }
                        n2 -= n7;
                        String string = new String(cArray, 0, n7);
                        DB2Connection dB2Connection = this.connection;
                        synchronized (dB2Connection) {
                            n6 = this.SQLPutStringData(string, n7, this.statementHandle, this.connection.connectionHandle);
                        }
                        if (n6 == 0) continue;
                        this.sqlExcptGen.check_return_code(this, n6);
                    }
                } else {
                    int n8;
                    closeable = (InputStream)this.paramRow[n - 1].getValue();
                    while ((n8 = ((InputStream)closeable).read(byArray, 0, Math.min(32699, n4))) != -1 && n4 != 0) {
                        n4 -= n8;
                        n2 = this.SQLPutByteData(byArray, n8, this.statementHandle);
                        if (n2 == 0) continue;
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                }
                this.returnCode = 0;
                n = this.SQLParamData(this.statementHandle);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.throw_IOException(iOException);
            return 0;
        }
        return this.returnCode;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setArray()");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 1);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setBigDecimal(n, bigDecimal, 2);
    }

    protected void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (bigDecimal == null) {
            this.setNull(n, n2);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8);
        int n3 = n - 1;
        this.setPrecisionAndScale(n3, bigDecimal);
    }

    protected int setBinarySQLType(int n, int n2) throws SQLException {
        if (n2 < 1 || n2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (this.sqltypes[n2 - 1] == -98) {
            return -98;
        }
        if (n > 32700) {
            return this.connection.getBlobSqlType();
        }
        return -4;
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        int n3 = this.setBinarySQLType(n2, n);
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, -2);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBlob(n, blob, -98);
    }

    public void setBlob(int n, Blob blob, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (blob == null) {
            this.setNull(n, -3);
            return;
        }
        int n3 = (int)blob.length();
        if (n3 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        if (blob instanceof DB2Blob) {
            DB2Blob dB2Blob = (DB2Blob)blob;
            this.sameType[n - 1] = this.setDirection(n, n2, 31);
            this.paramRow[n - 1].set(n3, dB2Blob, false, false);
        } else {
            this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setBoolean(n, bl, 5);
    }

    protected void setBoolean(int n, boolean bl, int n2) throws SQLException {
        if (bl) {
            this.setShort(n, (short)1, n2);
        } else {
            this.setShort(n, (short)0, n2);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setByte(n, by, 5);
    }

    protected void setByte(int n, byte by, int n2) throws SQLException {
        this.setShort(n, by, n2);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        int n2 = byArray.length;
        int n3 = this.setBinarySQLType(n2, n);
        this.setBytes(n, byArray, n3);
    }

    protected void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        switch (n2) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.sqlExcptGen.pstmtException("22003");
                break;
            }
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -2);
        this.paramRow[n - 1].set(byArray.length, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        block8: {
            block7: {
                block6: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setCharacterStream( " + n + ", " + "reader, " + n2 + " )");
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        this.sqlExcptGen.checkParamIndex(n, this.maxNumParams);
                        int n3 = -1;
                        if (reader == null) {
                            this.setNull(n, 12);
                            Object var5_5 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block6;
                        }
                        this.sameType[n - 1] = this.setDirection(n, n3, -8);
                        if (n2 == 0) {
                            String string = new String();
                            this.setString(n, string);
                            break block7;
                        }
                        this.paramRow[n - 1].set(n2, reader, true, true);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setCharacterStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setCharacterStream()");
                return;
            }
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setCharacterStream()");
            return;
        }
        Object var5_7 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setCharacterStream()");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setClob(n, clob, -99);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClob(int n, Clob clob, int n2) throws SQLException {
        block10: {
            block9: {
                block8: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setClob( " + n + ", Clob, " + n2 + " )");
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (clob == null) {
                            this.setNull(n, -3);
                            Object var5_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block8;
                        }
                        int n3 = (int)clob.length();
                        if (n3 == 0) {
                            String string = new String();
                            this.setString(n, string);
                            break block9;
                        }
                        if (clob instanceof DB2Clob) {
                            DB2Clob dB2Clob = (DB2Clob)clob;
                            n2 = dB2Clob.lobType == 41 ? -99 : -350;
                            this.sameType[n - 1] = this.setDirection(n, n2, dB2Clob.lobType);
                            this.paramRow[n - 1].set(n3, dB2Clob, false, true);
                            break block10;
                        } else {
                            this.setCharacterStream(n, clob.getCharacterStream(), (int)clob.length());
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setClob()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setClob()");
                return;
            }
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setClob()");
            return;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setClob()");
    }

    public void setDate(int n, Date date) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setDate(n, date, 91);
    }

    protected void setDate(int n, Date date, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (date == null) {
            this.setNull(n, n2);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 9);
        int[] nArray = new int[]{date.getYear() + 1900, date.getMonth() + 1, date.getDate()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    protected boolean setDirection(int n, int n2, int n3) {
        return this.setDirection(n, n2, n3, -1);
    }

    protected boolean setDirection(int n, int n2, int n3, int n4) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setDirection( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
        }
        int n5 = n - 1;
        boolean bl = true;
        if (this.direction[n5] == 4) {
            this.direction[n5] = 2;
            bl = false;
        } else if (this.direction[n5] == 0) {
            this.direction[n5] = 1;
            bl = false;
        }
        if (this.sqltypes[n5] == 0) {
            this.sqltypes[n5] = n2;
        }
        if ((this.sqltypes[n5] == 3 || this.sqltypes[n5] == 2) && n4 != -1 && n4 != this.scales[n5]) {
            this.scales[n5] = n4;
            bl = false;
        }
        if (this.ctypes[n5] != n3) {
            this.ctypes[n5] = n3;
            bl = false;
        }
        if (!bl) {
            this.wasBound[n5] = false;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setDirection()", bl);
        }
        return bl;
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setDouble(n, d, 8);
    }

    protected void setDouble(int n, double d, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 8);
        this.paramRow[n - 1].set(0, d);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setFloat(n, f, 7);
    }

    protected void setFloat(int n, float f, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        n2 = this.convert2SQLType(n2);
        this.sameType[n - 1] = this.setDirection(n, n2, 7);
        this.paramRow[n - 1].set(0, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setInt(n, n2, 4);
    }

    protected void setInt(int n, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 4);
        this.paramRow[n - 1].set(0, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setLong(n, l, -5);
    }

    protected void setLong(int n, long l, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = this.convert2SQLType(-5);
        this.sameType[n - 1] = this.setDirection(n, n3, -25);
        if (n3 == -5) {
            this.paramRow[n - 1].set(0, l);
        } else {
            this.paramRow[n - 1].set(0, (int)l);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (n2 == 0) {
            this.sqlExcptGen.pstmtException("S1003");
        }
        int n3 = this.convert2SQLType(n2);
        int n4 = this.sqlType2cType(n3);
        this.sameType[n - 1] = this.setDirection(n, n3, n4);
        this.paramRow[n - 1].set(-1, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block42: {
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (object == null) {
                this.setNull(n, n2);
                return;
            }
            if (n2 == 0) {
                try {
                    if (object instanceof String) {
                        this.setString(n, (String)object);
                        break block42;
                    }
                    if (object instanceof Character) {
                        this.setString(n, ((Character)object).toString());
                        break block42;
                    }
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                        this.setBigDecimal(n, bigDecimal);
                        break block42;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n, (Boolean)object);
                        break block42;
                    }
                    if (object instanceof Short) {
                        this.setShort(n, (Short)object);
                        break block42;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n, (Integer)object);
                        break block42;
                    }
                    if (object instanceof Long) {
                        this.setLong(n, (Long)object);
                        break block42;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n, ((Float)object).floatValue());
                        break block42;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n, (Double)object);
                        break block42;
                    }
                    if (object instanceof byte[]) {
                        this.setBytes(n, (byte[])object);
                        break block42;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object);
                        break block42;
                    }
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object);
                        break block42;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object);
                        break block42;
                    }
                    if (object instanceof Blob) {
                        this.setBlob(n, (Blob)object);
                        break block42;
                    }
                    if (object instanceof Clob) {
                        this.setClob(n, (Clob)object);
                        break block42;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            } else {
                n2 = this.convert2SQLType(n2);
                try {
                    if (object instanceof String) {
                        if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                            this.setString(n, DB2PreparedStatement.translateFloat((String)object), n2, n3);
                        } else {
                            this.setString(n, (String)object, n2);
                        }
                        break block42;
                    }
                    if (object instanceof Character) {
                        if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                            this.setString(n, DB2PreparedStatement.translateFloat(((Character)object).toString()), n2, n3);
                        } else {
                            this.setString(n, ((Character)object).toString(), n2);
                        }
                        break block42;
                    }
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                        this.setBigDecimal(n, bigDecimal, n2);
                        break block42;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n, (Boolean)object, n2);
                        break block42;
                    }
                    if (object instanceof Short) {
                        this.setShort(n, (Short)object, n2);
                        break block42;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n, (Integer)object, n2);
                        break block42;
                    }
                    if (object instanceof Long) {
                        this.setLong(n, (Long)object, n2);
                        break block42;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n, ((Float)object).floatValue(), n2);
                        break block42;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n, (Double)object, n2);
                        break block42;
                    }
                    if (object instanceof byte[]) {
                        this.setBytes(n, (byte[])object, n2);
                        break block42;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object, n2);
                        break block42;
                    }
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object, n2);
                        break block42;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object, n2);
                        break block42;
                    }
                    if (object instanceof Blob) {
                        this.setBlob(n, (Blob)object, n2);
                        break block42;
                    }
                    if (object instanceof Clob) {
                        this.setClob(n, (Clob)object, n2);
                        break block42;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            }
        }
    }

    protected void setPrecisionAndScale(int n, BigDecimal bigDecimal) {
        String string = bigDecimal.abs().toString();
        int n2 = 0;
        int n3 = string.length();
        if (string.indexOf(46) != -1) {
            n2 = 1;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!string.startsWith("0", n4)) break;
            ++n2;
            ++n4;
        }
        int n5 = bigDecimal.scale();
        int n6 = n3 - n2;
        int n7 = (n6 = Math.max(n6, 1)) - n5;
        if (n7 > this.maxWholeDigits[n]) {
            this.maxWholeDigits[n] = n7;
        }
        if (n5 > this.scales[n]) {
            this.scales[n] = n5;
        } else {
            n6 += this.scales[n] - n5;
        }
        this.paramRow[n].set(n6, bigDecimal.toString());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setRef()");
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setShort(n, s, 5);
    }

    protected void setShort(int n, short s, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 5);
        this.paramRow[n - 1].set(0, s);
    }

    public void setString(int n, String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        int n2 = string.length() < 4000 ? 12 : -1;
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8, n3);
        int n4 = string.length();
        this.paramRow[n - 1].set(n4, string);
        if (n3 <= 0) {
            if (n4 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n4;
            }
        } else {
            int n5 = n4 - n3;
            if (n5 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n5;
            }
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setTime(n, time, 92);
    }

    protected void setTime(int n, Time time, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (time == null) {
            this.setNull(n, n2);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 10);
        int[] nArray = new int[]{time.getHours(), time.getMinutes(), time.getSeconds()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.sqlExcptGen.checkParamIndex(n, this.maxNumParams);
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, 92, 10);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(time);
        int[] nArray = new int[3];
        int[] nArray2 = this.connection.getTimeZoneOffset();
        calendar2.add(11, nArray2[0]);
        calendar2.add(12, nArray2[1]);
        calendar2.add(13, nArray2[2]);
        nArray[0] = calendar2.get(11);
        nArray[1] = calendar2.get(12);
        nArray[2] = calendar2.get(13);
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.setTimestamp(n, timestamp, 93);
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (timestamp == null) {
            this.setNull(n, n2);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 11);
        int[] nArray = new int[]{timestamp.getYear() + 1900, timestamp.getMonth() + 1, timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.sqlExcptGen.checkParamIndex(n, this.maxNumParams);
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, 93, 11);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(timestamp);
        int[] nArray = this.connection.getTimeZoneOffset();
        calendar2.add(11, nArray[0]);
        calendar2.add(12, nArray[1]);
        calendar2.add(13, nArray[2]);
        int[] nArray2 = new int[]{calendar2.get(1), calendar2.get(2) + 1, calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13), timestamp.getNanos()};
        this.paramRow[n - 1].set(0, nArray2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, -8);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.paramRow[n - 1].set(n2 / 2, inputStreamReader, true, true);
    }

    protected int sqlType2cType(int n) {
        int n2;
        switch (n) {
            case -5: {
                n2 = -25;
                break;
            }
            case 2: 
            case 3: {
                n2 = -8;
                break;
            }
            case -98: 
            case -4: 
            case -3: {
                n2 = -2;
                break;
            }
            case -99: 
            case -1: 
            case 12: {
                n2 = -8;
                break;
            }
            case 2004: {
                n2 = 31;
                break;
            }
            case 2005: {
                n2 = 41;
                break;
            }
            case 91: {
                n2 = 9;
                break;
            }
            case 92: {
                n2 = 10;
                break;
            }
            case 93: {
                n2 = 11;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    protected byte[] toByteArray(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray[n * 2] = (byte)((cArray[n] & 0xFF00) >> 8);
            byArray[n * 2 + 1] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2PreparedStatement \r\n" + string + "{");
        stringBuffer.append(super.toString(String.valueOf(string) + "    ", bl));
        stringBuffer.append("\r\n");
        stringBuffer.append(String.valueOf(string) + "    SQL = " + this.sql + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    executed = " + this.executed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxNumParams = " + this.maxNumParams + "\r\n");
        int n = 0;
        while (n < this.maxNumParams) {
            stringBuffer.append(String.valueOf(string) + "    parameters[" + n + "] = " + this.parameters[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    paramLengths[" + n + "] = " + this.paramLengths[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    indicators[" + n + "] = " + this.indicators[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    direction[" + n + "] = " + this.direction[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    sqltypes[" + n + "] = " + this.sqltypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    ctypes[" + n + "] = " + this.ctypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    maxWholeDigits[" + n + "] = " + this.maxWholeDigits[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    scales[" + n + "] = " + this.scales[n] + "\r\n");
            ++n;
        }
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }

    private static String translateFloat(String string) {
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        if (c != '.') {
            return string.replace(c, '.');
        }
        return string;
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public double doubleValue() {
            return this.doubleVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public void set(double d) {
            this.doubleVal = d;
        }

        public void set(float f) {
            this.floatVal = f;
        }

        public void set(int n) {
            this.intVal = n;
        }

        public void set(long l) {
            this.longVal = l;
        }

        public void set(short s) {
            this.shortVal = s;
        }

        public short shortValue() {
            return this.shortVal;
        }
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
        }

        public ParamElement(int n, Object object) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n, Object object, boolean bl, boolean bl2) {
            this(n, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public void set(int n, double d) {
            this.primitiveData.set(d);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, float f) {
            this.primitiveData.set(f);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, int n2) {
            this.primitiveData.set(n2);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, long l) {
            this.primitiveData.set(l);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, Object object) {
            this.set(n, object, false, false);
        }

        public void set(int n, Object object, boolean bl, boolean bl2) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void set(int n, short s) {
            this.primitiveData.set(s);
            this.set(n, this.primitiveData, false, false);
        }

        public void unset() {
            this.fSet = false;
        }
    }
}

