/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.SQLException;

public class DB2ScrollableResultSet
extends DB2ResultSet {
    private int rowNumber = 0;
    private int currentRowId = 0;

    public DB2ScrollableResultSet(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n);
        this.rowNumber = n2;
        this.rsType = 1004;
        this.currentRowId = 0;
    }

    public boolean absolute(int n) throws SQLException {
        if (n == 0) {
            this.sqlExcptGen.throwInvalidAbsoluteCall();
        }
        if (this.rowNumber == 0) {
            return false;
        }
        if (n > this.rowNumber) {
            if (this.currentRowId > this.rowNumber) {
                return false;
            }
            n = this.rowNumber + 1;
        } else if (-n > this.rowNumber) {
            if (this.currentRowId < 1) {
                return false;
            }
            n = 0;
        } else if (n < 0) {
            n = this.rowNumber + n + 1;
        }
        if (n == this.currentRowId) {
            return true;
        }
        boolean bl = this.fetchOneRow(5, n);
        this.currentRowId = n;
        return bl;
    }

    public void afterLast() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId > this.rowNumber) {
            return;
        }
        this.fetchOneRow(5, this.rowNumber + 1);
        this.currentRowId = this.rowNumber + 1;
    }

    public void beforeFirst() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1) {
            return;
        }
        this.fetchOneRow(5, 0);
        this.currentRowId = 0;
    }

    protected boolean fetchOneRow(int n, int n2) throws SQLException {
        this.clearIsList();
        this.clearWarnings();
        int n3 = this.SQLFetchScroll(this.statement.statementHandle, n, n2);
        if (n3 != 100) {
            this.inValidRow = false;
            this.sqlExcptGen.check_return_code(this.statement, this, n3);
            return true;
        }
        this.inValidRow = true;
        return false;
    }

    public boolean first() throws SQLException {
        if (this.rowNumber == 0) {
            return false;
        }
        if (this.currentRowId == 1) {
            return true;
        }
        boolean bl = this.fetchOneRow(2, 0);
        this.currentRowId = 1;
        return bl;
    }

    public int getRow() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1 || this.currentRowId > this.rowNumber) {
            return 0;
        }
        return this.currentRowId;
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId > this.rowNumber;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId < 1;
    }

    public boolean isFirst() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId == 1;
    }

    public boolean isLast() throws SQLException {
        return this.rowNumber > 0 && this.currentRowId == this.rowNumber;
    }

    public boolean last() throws SQLException {
        if (this.rowNumber == 0) {
            return false;
        }
        if (this.currentRowId == this.rowNumber) {
            return true;
        }
        boolean bl = this.fetchOneRow(3, 0);
        this.currentRowId = this.rowNumber;
        return bl;
    }

    public boolean next() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId > this.rowNumber) {
            return false;
        }
        boolean bl = this.fetchOneRow(1, 0);
        ++this.currentRowId;
        return bl;
    }

    public boolean previous() throws SQLException {
        if (this.rowNumber == 0 || this.currentRowId < 1) {
            return false;
        }
        boolean bl = this.fetchOneRow(4, 0);
        --this.currentRowId;
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        if (this.getRow() == 0) {
            this.sqlExcptGen.throwInvalidRelativeCall();
        }
        if (this.rowNumber == 0) {
            return false;
        }
        int n2 = this.currentRowId + n;
        if (n2 <= 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n2);
    }

    protected void reset(int n, int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "reset( " + n + ", " + n2 + " )");
        }
        this.reset(n);
        this.rowNumber = n2;
        this.currentRowId = 0;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "reset()");
        }
    }

    protected void resetRows(int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "resetRows( " + n + " )");
        }
        this.rowNumber = n;
        this.currentRowId = 0;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "resetRows()");
        }
    }
}

