/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected int statementHandle = 0;
    protected DB2Connection connection;
    SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected short colCount = 0;
    protected int returnCode = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected SQLExceptionGenerator sqlExcptGen;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected boolean isJSQL = false;
    protected String SQLState = null;
    protected String SQLmessage = null;
    protected int SQLnativeCode = 0;
    protected byte[] SQLca = null;
    protected boolean cachedError = false;
    protected int SQLNextErrorRC = 0;
    protected int sqlSuccess = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int fetchDirection = 1000;
    protected int fetchSize = 1;
    protected String batchQuery = null;
    protected int batchSize = 0;
    protected int[] batchReturn = null;
    protected BatchUpdateException batchUpdateException = null;
    protected BatchUpdateException lastBatchUpdateException = null;

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection, int n, int n2) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2Statement( con, " + n + ", " + n2 + " )");
        }
        this.connection = dB2Connection;
        this.sqlExcptGen = this.connection.sqlExcptGen;
        this.checkResultSetType(n, n2);
        this.rsType = n;
        this.rsConcur = n2;
        this.returnCode = 0;
        this.statementHandle = this.SQLAllocStmt(this.connection.connectionHandle, n, n2);
        if (this.returnCode != 0) {
            this.sqlExcptGen.check_return_code(this, this.returnCode);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "DB2Statement()");
        }
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection);
        this.internalStmt = bl;
    }

    protected native int SQLAllocStmt(int var1, int var2, int var3);

    protected native int SQLCancel(int var1);

    protected native int SQLExecBatch(String var1, int var2, int var3, int var4);

    protected native int SQLExecDirect(String var1, int var2, int var3);

    protected native int SQLFreeStmt(int var1);

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLGetQueryTimeout(int var1);

    protected native int SQLGetRowCount(int var1);

    protected native int SQLMaxFieldSize(int var1, int var2);

    protected native int SQLMaxRows(int var1, int var2);

    protected native int SQLMoreResults(int var1, int var2);

    protected native int SQLScan(boolean var1, int var2);

    protected native int SQLSetCursorName(String var1, int var2, int var3);

    protected native int SQLSetQueryTimeout(int var1, int var2);

    public void addBatch(String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.batchQuery = this.batchSize == 0 ? string : String.valueOf(this.batchQuery) + ";" + string;
        ++this.batchSize;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
        }
    }

    public void cancel() throws SQLException {
        int n;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statementHandle != 0 && (n = this.SQLCancel(this.statementHandle)) != 0) {
            this.sqlExcptGen.check_return_code(this, n);
        }
    }

    protected void checkFetchDirection(int n, int n2) throws SQLException {
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
        if (n == 1003 && n2 == 1001) {
            this.sqlExcptGen.throwFetchDirectionError();
        }
    }

    protected void checkFetchSize(int n, int n2) throws SQLException {
        if (n != 0 && n2 > n || n2 < 0) {
            this.sqlExcptGen.throwFetchSizeError();
        }
    }

    protected void checkResultSetType(int n, int n2) throws SQLException {
        if (n2 == 1008) {
            this.sqlExcptGen.throwNotSupportedByDB2("Updatable result set");
        }
        if (n2 != 1007) {
            this.sqlExcptGen.throwUnknownResultSetType(n2);
        }
        if (n == 1005) {
            this.sqlExcptGen.throwNotSupportedByDB2("Scroll sensitive result set");
        }
        if (n != 1003 && n != 1004) {
            this.sqlExcptGen.throwUnknownResultSetType(n);
        }
    }

    public void clearBatch() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.batchSize = 0;
        this.batchQuery = null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            this.close2(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void close2(boolean bl) throws SQLException {
        block18: {
            block19: {
                block16: {
                    block15: {
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "close2( " + bl + " )");
                            }
                            this.closed = true;
                            if (this.connection == null) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(10, "connection is null");
                                }
                                Object var3_2 = null;
                                if (!DB2Trace.TraceOn) return;
                                break block15;
                            }
                            if (this.statementHandle == 0) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(20, "statementHandle = 0");
                                }
                                break block16;
                            }
                            DB2Connection dB2Connection = this.connection;
                            synchronized (dB2Connection) {
                                block17: {
                                    if (this.connection.closed) {
                                        if (DB2Trace.TraceOn) {
                                            DB2Trace.data(30, "connection is closed");
                                        }
                                        Object var5_8 = null;
                                        break block17;
                                    }
                                    if (this.resultSet != null) {
                                        this.resultSet.clearIsList();
                                    }
                                    if (!this.connection.SPConnected || this.connection.SPConnected && bl) {
                                        int n = this.SQLFreeStmt(this.statementHandle);
                                        if (this.returnCode != 0) {
                                            this.sqlExcptGen.check_return_code(this, n);
                                        }
                                        this.statementHandle = 0;
                                    }
                                    break block18;
                                }
                            }
                            break block19;
                        }
                        catch (Throwable throwable) {
                            Object var3_6 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit(this, "close2()");
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit(this, "close2()");
                    return;
                }
                Object var3_3 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "close2()");
                return;
            }
            Object var3_4 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "close2()");
            return;
        }
        Object var3_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "close2()");
    }

    public boolean execute(String string) throws SQLException {
        this.execute2(string);
        this.getResultSet();
        return this.colCount > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute2(String string) throws SQLException {
        block12: {
            block11: {
                this.moreResults = true;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute2( " + string + " )");
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    this.warnings = null;
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                    this.colCount = 0;
                    this.rowCount = 0;
                    this.returnCode = 0;
                    DB2Connection dB2Connection = this.connection;
                    synchronized (dB2Connection) {
                        this.returnCode = (short)this.SQLExecDirect(string, this.statementHandle, this.connection.connectionHandle);
                    }
                    if (this.returnCode == 100) {
                        this.rowCount = 0;
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block11;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(20, "rowCount", this.rowCount);
                    DB2Trace.data(20, "colCount", this.colCount);
                    DB2Trace.methodExit(this, "execute2()");
                    throw throwable;
                }
            }
            DB2Trace.data(20, "rowCount", this.rowCount);
            DB2Trace.data(20, "colCount", this.colCount);
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "rowCount", this.rowCount);
        DB2Trace.data(20, "colCount", this.colCount);
        DB2Trace.methodExit(this, "execute2()");
    }

    public int[] executeBatch() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.batchSize == 0) {
            return new int[0];
        }
        this.batchReturn = null;
        this.lastBatchUpdateException = null;
        this.batchUpdateException = null;
        int n = this.SQLExecBatch(this.batchQuery, this.batchSize, this.statementHandle, this.connection.connectionHandle);
        if (n != 0 && n != 1) {
            this.sqlExcptGen.check_batch_return_code(this, n);
        }
        this.clearBatch();
        if (this.batchUpdateException != null) {
            BatchUpdateException batchUpdateException = this.batchUpdateException;
            this.lastBatchUpdateException = null;
            this.batchUpdateException = null;
            throw batchUpdateException;
        }
        return this.batchReturn;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.execute2(string);
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute2(string);
        return this.getUpdateCount();
    }

    public void finalize() throws SQLException {
        this.close();
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    protected int getColCount() {
        this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
        return this.colCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (!this.moreResults) {
            return false;
        }
        this.colCount = 0;
        this.rowCount = 0;
        this.returnCode = 0;
        short s = this.colCount;
        this.colCount = (short)this.SQLMoreResults(this.statementHandle, this.connection.connectionHandle);
        if (this.returnCode == 100) {
            this.moreResults = false;
            return false;
        }
        if (this.returnCode != 0) {
            this.sqlExcptGen.check_return_code(this, this.returnCode);
            this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
        }
        if (this.returnCode == 0 || this.returnCode == 1) {
            return true;
        }
        this.moreResults = false;
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        this.returnCode = 0;
        n = this.SQLGetQueryTimeout(this.statementHandle);
        if (this.returnCode != 0) {
            this.sqlExcptGen.check_return_code(this, this.returnCode);
        }
        return n;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.moreResults) {
            if (this.colCount == 0) {
                this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
            }
            if (this.rsType != 1003 && this.rowCount == 0) {
                this.rowCount = this.SQLGetRowCount(this.statementHandle);
            }
        }
        if (this.resultSet == null) {
            this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, this.colCount, this.rowCount) : new DB2ScrollableResultSet(this, this.colCount, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount));
        } else if (this.rsType != 1003) {
            this.resultSet.reset(this.colCount, this.rowCount);
        } else {
            this.resultSet.reset(this.colCount);
        }
        if (this.colCount <= 0 || !this.moreResults) {
            return null;
        }
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcur;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    protected int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    public int getUpdateCount() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.colCount > 0 || !this.moreResults) {
            return -1;
        }
        if (this.rowCount == 0) {
            this.rowCount = this.SQLGetRowCount(this.statementHandle);
        }
        if (this.rowCount < 0) {
            return 0;
        }
        return this.rowCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    protected void newBatchUpdateException(String string, String string2, int n, int[] nArray) {
        BatchUpdateException batchUpdateException = new BatchUpdateException(string, string2, n, nArray);
        if (this.batchUpdateException == null) {
            this.batchUpdateException = batchUpdateException;
        } else {
            this.lastBatchUpdateException.setNextException(batchUpdateException);
        }
        this.lastBatchUpdateException = batchUpdateException;
    }

    protected void selectInBatchUpdateException(int[] nArray) {
        this.newBatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY0000", -99999, nArray);
    }

    public void setCursorName(String string) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            n = this.SQLSetCursorName(string, this.statementHandle, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.sqlExcptGen.check_return_code(this, n);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if ((n = this.SQLScan(bl, this.statementHandle)) != 0) {
            this.sqlExcptGen.check_return_code(this, n);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.checkFetchDirection(this.rsType, n);
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        this.checkFetchSize(this.maxRows, n);
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 0) {
            this.sqlExcptGen.throwOutOfRangeError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if ((n2 = this.SQLMaxFieldSize(n, this.statementHandle)) != 0) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 0) {
            this.sqlExcptGen.throwOutOfRangeError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if ((n2 = this.SQLMaxRows(n, this.statementHandle)) != 0) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (n < 0) {
            this.sqlExcptGen.throwOutOfRangeError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if ((n2 = this.SQLSetQueryTimeout(n, this.statementHandle)) != 0) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
    }

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2Statement \r\n" + string + "{");
        if (this.connection != null) {
            stringBuffer.append(this.connection.toString(String.valueOf(string) + "    Connection -> "));
        } else {
            stringBuffer.append("\r\n" + string + "    Connection -> null");
        }
        if (bl) {
            if (this.resultSet != null) {
                stringBuffer.append(this.resultSet.toString(String.valueOf(string) + "    ResultSet -> ", false));
            } else {
                stringBuffer.append("\r\n" + string + "    ResultSet -> null\r\n");
            }
        }
        stringBuffer.append("\r\n");
        stringBuffer.append(String.valueOf(string) + "    statementHandle = " + this.getTraceHandle() + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxRows = " + this.maxRows + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    rowCount = " + this.rowCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    colCount = " + this.colCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    internalStmt = " + this.internalStmt + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    isSQLJ = " + this.isJSQL + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }
}

