/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2DataTruncation;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2Warning;
import COM.ibm.db2.mri.DB2Messages;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class SQLExceptionGenerator {
    protected String SQLState = null;
    protected String SQLmessage = null;
    protected int SQLnativeCode = 0;
    protected byte[] SQLca = null;
    protected DB2Messages errMsgClass;
    protected int PSMLineNumber = 0;
    protected String SQLerrmc = null;

    public SQLExceptionGenerator(ResourceBundle resourceBundle) {
        this.errMsgClass = new DB2Messages(resourceBundle);
    }

    protected native int SQLConnectionError(int var1);

    protected native int SQLStatementError(int var1, int var2);

    protected void TraceException(String string) {
        DB2Trace.getTraceObj().traceEntry("SQLExceptionGenerator", string);
        DB2Trace.getTraceObj().println("SQLState = " + this.SQLState);
        DB2Trace.getTraceObj().println("SQLmessage = " + this.SQLmessage);
        DB2Trace.getTraceObj().println("SQLnativeCode = " + this.SQLnativeCode);
        DB2Trace.getTraceObj().traceExit("SQLExceptionGenerator", string);
        DB2Trace.flush();
    }

    public void addWarning(DB2Connection dB2Connection) {
        if (this.getSQLConnectionError(dB2Connection) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Connection)");
            }
            dB2Connection.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
        }
    }

    public void addWarning(DB2Statement dB2Statement) {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            String string;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement)");
            }
            if ((string = this.SQLState.trim()).equals("01004")) {
                dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else if (string.equals("01592")) {
                dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else {
                dB2Statement.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            }
        }
    }

    public void addWarning(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet) {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            String string;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement, DB2ResultSet)");
            }
            if ((string = this.SQLState.trim()).equals("01004")) {
                dB2ResultSet.addWarning(new DB2DataTruncation(-1, false, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else if (string.equals("01592")) {
                dB2ResultSet.addWarning(new DB2DataTruncation(-1, false, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else {
                dB2ResultSet.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
            }
        }
    }

    public void checkColumnIndex(int n, int n2) throws SQLException {
        if (n < 1 || n > n2) {
            throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
        }
    }

    public void checkParamIndex(int n, int n2) throws SQLException {
        if (n < 1 || n > n2) {
            throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
        }
    }

    public void check_address(int n, boolean bl) throws SQLException {
        if (n == 0) {
            throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
        }
        if (!bl) {
            throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
        }
    }

    public void check_batch_return_code(DB2Statement dB2Statement, int n) throws SQLException {
        if (n == 0) {
            return;
        }
        if (n == -2) {
            throw new DB2Exception(this.errMsgClass.getString("0601"), "S1000", -99999, null);
        }
        if (n == 1) {
            this.addWarning(dB2Statement);
        } else {
            this.throw_SQLException(dB2Statement, true);
        }
    }

    public void check_return_code(DB2Connection dB2Connection, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Connection);
                break;
            }
            case -2: {
                dB2Connection.close();
                throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
            }
            default: {
                this.throw_SQLException(dB2Connection);
            }
            case 0: 
        }
    }

    public void check_return_code(DB2Statement dB2Statement, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Statement);
                break;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(dB2Statement);
            }
            case 0: 
        }
    }

    public void check_return_code(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Statement, dB2ResultSet);
                break;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(dB2Statement);
            }
            case 0: 
        }
    }

    public void check_type(int n, int n2) throws SQLException {
        if (n != n2) {
            throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
        }
    }

    public void connException(String string) throws SQLException {
        if (string.trim().equals("S1C00")) {
            throw new DB2Exception(this.errMsgClass.getString("0700"), "S1C00", -99999, null);
        }
    }

    protected int getSQLConnectionError(DB2Connection dB2Connection) {
        int n;
        DB2Connection dB2Connection2 = dB2Connection;
        synchronized (dB2Connection2) {
            n = this.SQLConnectionError(dB2Connection.connectionHandle);
        }
        return n;
    }

    protected int getSQLStatementError(DB2Statement dB2Statement) {
        int n = 0;
        if (dB2Statement.cachedError) {
            this.SQLState = dB2Statement.SQLState;
            this.SQLmessage = dB2Statement.SQLmessage;
            this.SQLnativeCode = dB2Statement.SQLnativeCode;
            this.SQLca = dB2Statement.SQLca;
            dB2Statement.cachedError = false;
            dB2Statement.SQLState = null;
            dB2Statement.SQLmessage = null;
            dB2Statement.SQLnativeCode = 0;
        } else {
            this.SQLState = "";
            this.SQLmessage = "";
            this.SQLnativeCode = 0;
            this.SQLca = null;
            this.PSMLineNumber = 0;
            this.SQLerrmc = "";
            DB2Connection dB2Connection = dB2Statement.connection;
            synchronized (dB2Connection) {
                n = this.SQLStatementError(dB2Statement.statementHandle, dB2Statement.connection.connectionHandle);
            }
        }
        return n;
    }

    public void pstmtException(String string) throws SQLException {
        if (string.equals("S1003")) {
            throw new DB2Exception(this.errMsgClass.getString("0613"), "S1003", -99999, null);
        }
        if (string.equals("22003")) {
            throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
        }
    }

    public void rsException(String string) throws SQLException {
        if (string.equals("S0022")) {
            throw new DB2Exception(this.errMsgClass.getString("0611"), "S0022", -99999, null);
        }
        if (string.equals("22005")) {
            throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
        }
        if (string.equals("07006")) {
            throw new DB2Exception(this.errMsgClass.getString("0608"), "07006", -99999, null);
        }
    }

    public void throwBatchSizeError() throws SQLException {
        throw new BatchUpdateException(this.errMsgClass.getString("0643"), new int[0]);
    }

    public void throwClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0601"), "S1000", -99999, null);
    }

    public void throwColumnDataTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
    }

    public void throwColumnIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
    }

    public void throwConnectionClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
    }

    public void throwFetchDirectionError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0642"));
    }

    public void throwFetchSizeError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0632"));
    }

    public void throwInvalidAbsoluteCall() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0644"));
    }

    public void throwInvalidRelativeCall() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0633"));
    }

    public void throwNoRandomAccess() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0631"));
    }

    public void throwNot20() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0625"));
    }

    public void throwNotExecutedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
    }

    public void throwNotOutputParameterError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
    }

    public void throwNotScrollable() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0627"));
    }

    public void throwNotSet(int n, int n2, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{String.valueOf(n2 + 1), String.valueOf(n + 1)};
        throw new BatchUpdateException(this.errMsgClass.getString("0628", stringArray), "", -99999, nArray);
    }

    public void throwNotSupportedByDB2(String string) throws SQLException {
        String[] stringArray = new String[]{string};
        throw new SQLException(this.errMsgClass.getString("0626", stringArray));
    }

    public void throwNotSupportedIO(String string) throws IOException {
        String[] stringArray = new String[]{string};
        throw new IOException(this.errMsgClass.getString("0629", stringArray));
    }

    public void throwOutOfRangeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
    }

    public void throwParamIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
    }

    public void throwQueryInBatch() throws SQLException {
        throw new BatchUpdateException(this.errMsgClass.getString("0641"), new int[0]);
    }

    public void throwTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
    }

    public void throwUnknownResultSetType(int n) throws SQLException {
        String[] stringArray = new String[]{String.valueOf(n)};
        throw new SQLException(this.errMsgClass.getString("0630", stringArray));
    }

    public void throw_IOException(IOException iOException) throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0620"), "22021", -99999, null);
    }

    public void throw_SQLException(DB2Connection dB2Connection) throws SQLException {
        DB2Exception dB2Exception = null;
        DB2Exception dB2Exception2 = null;
        int n = this.getSQLConnectionError(dB2Connection);
        while (n != 100 && n != -2) {
            String string = this.SQLState.trim();
            if (string.equals("08003")) {
                dB2Connection.setClosed(true);
            }
            if (string.startsWith("01") && !string.equals("01004")) {
                dB2Connection.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
            } else if (dB2Exception2 == null) {
                dB2Exception = dB2Exception2 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
            } else {
                DB2Exception dB2Exception3 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
                dB2Exception.setNextException(dB2Exception3);
                dB2Exception = dB2Exception3;
            }
            n = this.getSQLConnectionError(dB2Connection);
        }
        if (dB2Exception2 != null) {
            throw dB2Exception2;
        }
    }

    public void throw_SQLException(DB2Statement dB2Statement) throws SQLException {
        this.throw_SQLException(dB2Statement, false);
    }

    public void throw_SQLException(DB2Statement dB2Statement, boolean bl) throws SQLException {
        SQLException sQLException = null;
        Object object = null;
        int n = this.getSQLStatementError(dB2Statement);
        while (n != 100 && n != -2) {
            Object object2;
            String string = this.SQLState.trim();
            if (string.equals("08003")) {
                ((DB2Connection)dB2Statement.getConnection()).setClosed(true);
            }
            if (string.startsWith("01") && !string.equals("01004")) {
                if (string.equals("01004")) {
                    dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else if (string.equals("01592")) {
                    dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else {
                    dB2Statement.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                }
            } else if (sQLException == null) {
                if (bl) {
                    object2 = dB2Statement.getBatchReturn();
                    sQLException = new BatchUpdateException(this.SQLmessage, this.SQLState, this.SQLnativeCode, (int[])object2);
                } else {
                    sQLException = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
                }
                object = sQLException;
            } else {
                object2 = null;
                if (bl) {
                    int[] nArray = dB2Statement.getBatchReturn();
                    object2 = new BatchUpdateException(this.SQLmessage, this.SQLState, this.SQLnativeCode, nArray);
                } else {
                    object2 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
                }
                ((SQLException)object).setNextException((SQLException)object2);
                object = object2;
            }
            n = this.getSQLStatementError(dB2Statement);
        }
        if (n == -2) {
            this.throwClosedError();
        } else if (sQLException != null) {
            throw sQLException;
        }
    }
}

