/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.IOException;
import java.sql.SQLException;

public class DB2Binary2AsciiInputStream
extends DB2InputStream {
    private byte[] cvtBuffer;
    private int cvtBufPos;
    private int cvtAvailable;

    public DB2Binary2AsciiInputStream(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n, n2, false);
        if (this.maxFieldSize != 0 && (long)(this.maxFieldSize / 2) > this.docLength) {
            this.docLength = this.maxFieldSize / 2;
        }
        this.cvtAvailable = 0;
        this.cvtBufPos = 0;
    }

    public int available() {
        return super.available() * 2;
    }

    private byte[] getData(int n) throws IOException {
        if (this.cvtAvailable == 0 && !this.hasMore()) {
            return null;
        }
        if (this.cvtAvailable >= n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, n);
            this.cvtAvailable -= n;
            this.cvtBufPos += n;
            return byArray;
        }
        if (!this.hasMore()) {
            byte[] byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            this.cvtAvailable = 0;
            return byArray;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.cvtAvailable != 0) {
            byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            byArray2 = new byte[(n - this.cvtAvailable + 1) / 2];
        } else {
            byArray2 = new byte[(n + 1) / 2];
        }
        int n2 = super.read(byArray2);
        if (n2 > 0) {
            this.cvtBuffer = new byte[n2 * 2];
            int n3 = 0;
            while (n3 < n2) {
                this.cvtBuffer[n3 * 2] = DB2BaseConstants.TOCHAR[(byte)((byArray2[n3] & 0xF0) >> 4)];
                this.cvtBuffer[n3 * 2 + 1] = DB2BaseConstants.TOCHAR[(byte)(byArray2[n3] & 0xF)];
                ++n3;
            }
            this.cvtAvailable = this.cvtBuffer.length;
            this.cvtBufPos = 0;
            if (byArray != null) {
                int n4 = Math.min(n - byArray.length, this.cvtAvailable);
                byte[] byArray3 = new byte[byArray.length + n4];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray3, byArray.length, n4);
                this.cvtBufPos += n4;
                this.cvtAvailable -= n4;
                return byArray3;
            }
            int n5 = Math.min(n, this.cvtAvailable);
            byte[] byArray4 = new byte[n5];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray4, 0, n5);
            this.cvtBufPos += n5;
            this.cvtAvailable -= n5;
            return byArray4;
        }
        return byArray;
    }

    public void mark(int n) {
        super.mark(n / 2);
    }

    public int read() throws IOException {
        byte[] byArray = this.getData(1);
        if (byArray == null) {
            return -1;
        }
        if (byArray[0] < 0) {
            return byArray[0] + 256;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        byte[] byArray2 = this.getData(byArray.length);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        return byArray2.length;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.getData(n2);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }
}

