/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected int maxFieldSize;
    protected DB2InputStream db2is;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected boolean closed = false;
    protected DB2Statement parentStmt;

    public DB2Blob(DB2Statement dB2Statement, int n) throws SQLException {
        this.parentStmt = dB2Statement;
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.maxFieldSize = dB2Statement.getMaxFieldSize();
        this.locator = n;
        this.lobType = 31;
        this.db2is = new DB2InputStream(dB2Statement, n, this.lobType, false);
        this.statement = this.db2is.getStatement();
        this.sqlExcptGen = dB2Statement.sqlExcptGen;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Statement.db2req) : new DB2RequestTrace(dB2Statement.db2req);
    }

    protected int SQLGetPosition(byte[] byArray, int n) throws SQLException {
        int n2 = -1;
        try {
            this.db2req.write((short)207);
            this.db2req.write(this.statement.getHandle());
            this.db2req.write(this.locator);
            this.db2req.write(byArray);
            this.db2req.write(n);
            this.db2req.sendAndRecv();
            int n3 = this.db2req.readInt();
            this.sqlExcptGen.check_return_code(this.statement, n3);
            n2 = this.db2req.readInt();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.throw_IOException(iOException);
        }
        return n2;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getBinaryStream()");
        }
        DB2InputStream dB2InputStream = null;
        try {
            dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType, false);
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            }
        }
        return dB2InputStream;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        int n2 = 0;
        try {
            this.db2is.moveTo((int)l);
            n2 = this.db2is.read(byArray);
            if (n2 >= 0) {
                if (n2 != n) {
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                } else {
                    byArray2 = byArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return byArray2;
    }

    int getLocator() {
        return this.locator;
    }

    public long length() throws SQLException {
        long l = this.db2is.getLength();
        if (this.maxFieldSize != 0 && (long)this.maxFieldSize < l) {
            l = this.maxFieldSize;
        }
        return l;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (blob instanceof DB2Blob) {
            DB2Blob dB2Blob = (DB2Blob)blob;
            int n = dB2Blob.getLocator();
            int n2 = -1;
            try {
                this.db2req.write((short)208);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(this.lobType);
                this.db2req.write(n);
                this.db2req.write((int)l);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                this.sqlExcptGen.check_return_code(this.statement, n3);
                n2 = this.db2req.readInt();
            }
            catch (IOException iOException) {
                this.sqlExcptGen.throw_IOException(iOException);
            }
            return n2;
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        Integer n = new Integer(0);
        int n2 = this.SQLGetPosition(byArray, (int)l);
        this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
        return n2;
    }
}

