/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2OutputParameters;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement {
    private DB2OutputParameters outParams = null;
    protected boolean wasNull = false;

    public DB2CallableStatement(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(string, dB2Connection, n, n2);
    }

    private void createOutputParamObj() throws SQLException {
        this.outParams = new DB2OutputParameters(this, this.maxNumParams, this.direction, this.sqltypes);
    }

    public boolean execute() throws SQLException {
        boolean bl = super.execute();
        this.createOutputParamObj();
        return bl;
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n = 0;
        this.warnings = null;
        try {
            this.db2req.write((short)80);
            this.db2req.write(this.statementHandle);
            this.paramToServer();
            this.db2req.sendAndRecv();
            n = this.db2req.readInt();
            this.executed = true;
            if (n == this.SQL_SUCCESS) {
                this.rowCount = this.db2req.readInt();
                this.colCount = this.db2req.readShort();
                if (this.resultSet != null) {
                    this.resultSet.reset(this.colCount);
                }
            } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                n = this.db2req.readInt();
                if (n == this.SQL_SUCCESS) {
                    String string = this.db2req.readString();
                    String string2 = this.db2req.readString();
                    int n2 = this.db2req.readInt();
                    this.addWarning(new SQLWarning(string, string2, n2));
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null) {
                        this.resultSet.reset(this.colCount);
                    }
                }
                n = this.SQL_SUCCESS;
            }
            if (n == 99) {
                n = this.loadParameters();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = super.executeQuery();
        this.createOutputParamObj();
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n = super.executeUpdate();
        this.createOutputParamObj();
        return n;
    }

    public Array getArray(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        int n2 = this.validateParameter(n, 2);
        return this.outParams.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        int n3 = this.validateParameter(n, 2);
        BigDecimal bigDecimal = this.outParams.getBigDecimal(n3);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n2, 4);
    }

    public Blob getBlob(int n) throws SQLException {
        int n2 = this.validateParameter(n, -98);
        return this.outParams.getBlob(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        int n2 = this.validateParameter(n, 5);
        return this.outParams.getBoolean(n2);
    }

    public byte getByte(int n) throws SQLException {
        int n2 = this.validateParameter(n, 5);
        return this.outParams.getByte(n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        int n2 = this.validateParameter(n);
        int n3 = this.sqltypes[n2];
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "type", n3);
        }
        if (n3 != -2 && n3 != -3 && n3 != -4 && n3 != -98) {
            this.sqlExcptGen.throwTypeError();
        }
        return this.outParams.getBytes(n2);
    }

    public Clob getClob(int n) throws SQLException {
        int n2 = this.validateParameter(n, -99);
        return this.outParams.getClob(n);
    }

    public Date getDate(int n) throws SQLException {
        int n2 = this.validateParameter(n, 91);
        return this.outParams.getDate(n2);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public double getDouble(int n) throws SQLException {
        int n2 = this.validateParameter(n, 8);
        return this.outParams.getDouble(n2);
    }

    public float getFloat(int n) throws SQLException {
        int n2 = this.validateParameter(n, 7);
        return this.outParams.getFloat(n2);
    }

    public int getInt(int n) throws SQLException {
        int n2 = this.validateParameter(n, 4);
        return this.outParams.getInt(n2);
    }

    public long getLong(int n) throws SQLException {
        int n2 = this.validateParameter(n, -5);
        return this.outParams.getLong(n2);
    }

    public Object getObject(int n) throws SQLException {
        int n2 = this.validateParameter(n);
        return this.outParams.getObject(n2);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Ref type");
        return null;
    }

    public short getShort(int n) throws SQLException {
        int n2 = this.validateParameter(n, 5);
        return this.outParams.getShort(n2);
    }

    public String getString(int n) throws SQLException {
        int n2 = this.validateParameter(n);
        int n3 = this.sqltypes[n2];
        if (n3 != 1 && n3 != 12 && n3 != -1) {
            this.sqlExcptGen.throwTypeError();
        }
        return this.outParams.getString(n2);
    }

    public Time getTime(int n) throws SQLException {
        int n2 = this.validateParameter(n, 92);
        return this.outParams.getTime(n2);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (this.wasNull()) {
            return null;
        }
        calendar.setTime(time);
        Time time2 = new Time(calendar.get(10), calendar.get(12), calendar.get(13));
        return time2;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        int n2 = this.validateParameter(n, 93);
        return this.outParams.getTimestamp(n2);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (this.wasNull()) {
            return null;
        }
        calendar.setTime(timestamp);
        Timestamp timestamp2 = new Timestamp(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13), timestamp.getNanos());
        return timestamp2;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n4 = n - 1;
        n2 = this.convert2SQLType(n2);
        switch (this.direction[n4]) {
            case 0: {
                this.direction[n4] = 4;
                break;
            }
            case 1: {
                this.direction[n4] = 2;
                break;
            }
        }
        this.sqltypes[n4] = n2;
        if (this.ctypes[n4] == 0) {
            this.ctypes[n4] = this.sqlType2cType(n2);
        }
        if ((n2 == 3 || n2 == 2) && n3 < this.scales[n4]) {
            n3 = this.scales[n4];
        }
        this.scales[n4] = (short)n3;
        this.executed = false;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    private int validateParameter(int n) throws SQLException {
        return this.validateParameter(n, 0, false);
    }

    private int validateParameter(int n, int n2) throws SQLException {
        return this.validateParameter(n, n2, true);
    }

    private int validateParameter(int n, int n2, boolean bl) throws SQLException {
        int n3;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (!this.executed) {
            this.sqlExcptGen.throwNotExecutedError();
        }
        if (this.direction[n3 = n - 1] != 4 && this.direction[n3] != 2) {
            this.sqlExcptGen.throwNotOutputParameterError();
        }
        if (bl && this.sqltypes[n3] != n2) {
            this.sqlExcptGen.throwTypeError();
        }
        return n3;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

