/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CharReader;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected int maxFieldSize;
    protected DB2CharReader reader;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected boolean closed = false;
    protected DB2Statement parentStmt;

    public DB2Clob(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        this.parentStmt = dB2Statement;
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.maxFieldSize = dB2Statement.getMaxFieldSize();
        this.locator = n;
        this.lobType = n2;
        this.reader = new DB2CharReader(dB2Statement, n, n2);
        this.statement = this.reader.getStatement();
        this.sqlExcptGen = dB2Statement.sqlExcptGen;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Statement.db2req) : new DB2RequestTrace(dB2Statement.db2req);
    }

    protected int SQLGetPosition(String string, int n) throws SQLException {
        int n2 = -1;
        try {
            this.db2req.write((short)206);
            this.db2req.write(this.statement.getHandle());
            this.db2req.write(this.locator);
            this.db2req.write(this.lobType);
            this.db2req.write(string);
            this.db2req.write(n);
            this.db2req.sendAndRecv();
            int n3 = this.db2req.readInt();
            this.sqlExcptGen.check_return_code(this.statement, n3);
            n2 = this.db2req.readInt();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.throw_IOException(iOException);
        }
        return n2;
    }

    public InputStream getAsciiStream() throws SQLException {
        return new DB2InputStream(this.statement, this.locator, this.lobType, false);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.reader;
    }

    int getLocator() {
        return this.locator;
    }

    public String getSubString(long l, int n) throws SQLException {
        this.reader.moveTo((int)l);
        char[] cArray = new char[n];
        int n2 = 0;
        try {
            n2 = this.reader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return new String(cArray, 0, n2);
    }

    public long length() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "length()");
        }
        long l = 0L;
        try {
            l = this.reader.getLength();
        }
        finally {
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "length()", l);
            }
        }
        return l;
    }

    public long position(String string, long l) throws SQLException {
        Integer n = new Integer(0);
        int n2 = this.SQLGetPosition(string, (int)l);
        this.connection.sqlExcptGen.check_return_code(this.statement, (int)n);
        return n2;
    }

    public long position(Clob clob, long l) throws SQLException {
        if (clob instanceof DB2Clob) {
            DB2Clob dB2Clob = (DB2Clob)clob;
            int n = dB2Clob.getLocator();
            int n2 = -1;
            try {
                this.db2req.write((short)208);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(this.lobType);
                this.db2req.write(n);
                this.db2req.write((int)l);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                this.sqlExcptGen.check_return_code(this.statement, n3);
                n2 = this.db2req.readInt();
            }
            catch (IOException iOException) {
                this.sqlExcptGen.throw_IOException(iOException);
            }
            return n2;
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }
}

