/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.DB2EmptyResultSet;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2ColumnMappingResultSet;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2SQLTypeMappingResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2DatabaseMetaData
implements DatabaseMetaData {
    DB2Connection connection;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    private static final String bogusSchema = new String("SysBogus");
    public int procedureResultUnknown = 0;
    public int procedureNoResult = 1;
    public int procedureReturnsResult = 2;
    public int procedureColumnUnknown = 0;
    public int procedureColumnIn = 1;
    public int procedureColumnInOut = 2;
    public int procedureColumnResult = 3;
    public int procedureColumnOut = 4;
    public int procedureColumnReturn = 5;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeUnSearchable = 0;
    int typeSearchLikeOnly = 1;
    int typeSearchNotLike = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    public DB2DatabaseMetaData(DB2Connection dB2Connection) {
        this.connection = dB2Connection;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(this.connection.db2socket) : new DB2RequestTrace(this.connection.db2socket);
        this.sqlExcptGen = this.connection.sqlExcptGen;
    }

    protected boolean SQLCompShort(int n, int n2) throws SQLException {
        short s = this.getShortInfo(n);
        return s == n2;
    }

    protected void SQLForeignKeys(DB2Statement dB2Statement, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        if (!this.isCatalogValid(string4) || string5 != null && string5.length() == 0) {
            string5 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)116);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(string5);
                this.db2req.write(string6);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected boolean SQLGetBooleanInfo(int n) throws SQLException {
        String string = this.SQLGetStringInfo(n);
        return string.equals("Y");
    }

    protected boolean SQLGetBooleanInfo(int n, int n2) throws SQLException {
        int n3 = this.SQLGetIntegerInfo(n);
        return (n3 & n2) > 0;
    }

    protected void SQLGetCatalogs(DB2Statement dB2Statement) throws SQLException {
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)107);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetColumnPrivileges(DB2Statement dB2Statement, String string, String string2, String string3, String string4) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)110);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(string4);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetColumns(DB2Statement dB2Statement, String string, String string2, String string3, String string4) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)109);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(string4);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected int SQLGetIntInfo(int n) throws SQLException {
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)102);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != 0) {
                    this.sqlExcptGen.check_return_code(this.connection, n3);
                }
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    protected int SQLGetIntegerInfo(int n) throws SQLException {
        return this.SQLGetIntInfo(n);
    }

    protected void SQLGetProcedureColumns(DB2Statement dB2Statement, String string, String string2, String string3, String string4) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)104);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(string4);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetProcedures(DB2Statement dB2Statement, String string, String string2, String string3) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)103);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetSchemas(DB2Statement dB2Statement) throws SQLException {
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)106);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected short SQLGetShortInfo(int n) throws SQLException {
        short s = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)117);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != 0) {
                    this.sqlExcptGen.check_return_code(this.connection, n2);
                }
                s = this.db2req.readShort();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return s;
    }

    protected String SQLGetStrInfo(int n) throws SQLException {
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)101);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != 0) {
                    this.sqlExcptGen.check_return_code(this.connection, n2);
                }
                string = this.db2req.readString();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected String SQLGetStringInfo(int n) throws SQLException {
        return this.SQLGetStrInfo(n);
    }

    protected void SQLGetTableTypes(DB2Statement dB2Statement) throws SQLException {
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)108);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetTables(DB2Statement dB2Statement, String string, String string2, String string3, String string4) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)105);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(string4);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLGetTypeInfo(DB2Statement dB2Statement, int n) throws SQLException {
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)114);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n2);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLPrimaryKeys(DB2Statement dB2Statement, String string, String string2, String string3) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)113);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLSpecialColumns(DB2Statement dB2Statement, int n, String string, String string2, String string3, int n2, int n3) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)112);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(n);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(n2);
                this.db2req.write(n3);
                this.db2req.sendAndRecv();
                int n4 = this.db2req.readInt();
                if (n4 != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n4);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLStatistics(DB2Statement dB2Statement, String string, String string2, String string3, int n, int n2) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)115);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.write(n);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n3);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected void SQLTablePrivileges(DB2Statement dB2Statement, String string, String string2, String string3) throws SQLException {
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)111);
                this.db2req.write(dB2Statement.statementHandle);
                this.db2req.write(string2);
                this.db2req.write(string3);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != 0) {
                    this.sqlExcptGen.check_return_code(dB2Statement, n);
                } else {
                    dB2Statement.colCount = this.db2req.readShort();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.SQLGetBooleanInfo(20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.SQLGetBooleanInfo(19);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.SQLCompShort(46, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.SQLCompShort(46, 4);
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.SQLGetBooleanInfo(103);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (bl) {
            this.SQLSpecialColumns(dB2Statement, 1, string, string2, string3, n, 1);
        } else {
            this.SQLSpecialColumns(dB2Statement, 1, string, string2, string3, n, 0);
        }
        int[] nArray = new int[]{3};
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, dB2Statement.colCount);
    }

    public String getCatalogSeparator() throws SQLException {
        return this.SQLGetStringInfo(41);
    }

    public String getCatalogTerm() throws SQLException {
        return this.SQLGetStringInfo(42);
    }

    public ResultSet getCatalogs() throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetCatalogs(dB2Statement);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetColumnPrivileges(dB2Statement, string, string2, string3, string4);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetColumns(dB2Statement, string, string2, string3, string4);
        Object var6_6 = null;
        int[] nArray = new int[]{5};
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, 18);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLForeignKeys(dB2Statement, string, string2, string3, string4, string5, string6);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.SQLGetStringInfo(17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.SQLGetStringInfo(18);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.SQLGetIntegerInfo(26);
    }

    public int getDriverMajorVersion() {
        return 7;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public String getDriverName() throws SQLException {
        return "IBM DB2 JDBC 2.0 Type 3";
    }

    public String getDriverVersion() throws SQLException {
        return this.SQLGetStringInfo(7);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(string, string2, string3, string, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.SQLGetStringInfo(94);
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.SQLGetStringInfo(29);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(string, null, null, string, string2, string3);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (bl) {
            this.SQLStatistics(dB2Statement, string, string2, string3, 0, 0);
        } else {
            this.SQLStatistics(dB2Statement, string, string2, string3, 1, 0);
        }
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(112);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getShortInfo(34);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getShortInfo(30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getShortInfo(97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getShortInfo(98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getShortInfo(99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getShortInfo(100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getShortInfo(101);
    }

    public int getMaxConnections() throws SQLException {
        return this.getShortInfo(0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getShortInfo(31);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.SQLGetIntegerInfo(102);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getShortInfo(33);
    }

    public int getMaxRowSize() throws SQLException {
        return this.SQLGetIntegerInfo(104);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getShortInfo(32);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.SQLGetIntegerInfo(104);
    }

    public int getMaxStatements() throws SQLException {
        return this.getShortInfo(1);
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getShortInfo(35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getShortInfo(106);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getShortInfo(107);
    }

    public String getNumericFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(49);
        String string = new String();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_NUM_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].bitMask)) {
                string = String.valueOf(string) + "," + DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].nameStr;
            }
            ++n2;
        }
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLPrimaryKeys(dB2Statement, string, string2, string3);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetProcedureColumns(dB2Statement, string, string2, string3, string4);
        int[] nArray = new int[]{6};
        Object var7_7 = null;
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, 13);
    }

    public String getProcedureTerm() throws SQLException {
        return this.SQLGetStringInfo(40);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetProcedures(dB2Statement, string, string2, string3);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = !DB2Trace.TraceOn ? new DB2ResultSet(dB2Statement, dB2Statement.colCount) : new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public String getSQLKeywords() throws SQLException {
        return this.SQLGetStringInfo(89);
    }

    public String getSchemaTerm() throws SQLException {
        return this.SQLGetStringInfo(39);
    }

    public ResultSet getSchemas() throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetSchemas(dB2Statement);
        int[] nArray = new int[]{2};
        return new DB2ColumnMappingResultSet(dB2Statement, nArray, dB2Statement.colCount);
    }

    public String getSearchStringEscape() throws SQLException {
        return this.SQLGetStringInfo(14);
    }

    protected short getShortInfo(int n) throws SQLException {
        return this.SQLGetShortInfo(n);
    }

    public String getStringFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(50);
        String string = new String();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_STR_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_STR_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_STR_MAPPING[n2].bitMask)) {
                string = String.valueOf(string) + "," + DB2BaseConstants.SQL_FN_STR_MAPPING[n2].nameStr;
            }
            ++n2;
        }
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(51);
        String string = new String();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_SYS_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].bitMask)) {
                string = String.valueOf(string) + "," + DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].nameStr;
            }
            ++n2;
        }
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLTablePrivileges(dB2Statement, string, string2, string3);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetTableTypes(dB2Statement);
        int[] nArray = new int[]{4};
        return new DB2ColumnMappingResultSet(dB2Statement, nArray, dB2Statement.colCount);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        String string4 = new String("");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string4 = string4.concat("'" + stringArray[n] + "'");
                if (n != stringArray.length - 1) {
                    string4 = string4.concat(",");
                }
                ++n;
            }
        }
        this.SQLGetTables(dB2Statement, string, string2, string3, string4);
        DB2ResultSet dB2ResultSet = null;
        dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, dB2Statement.colCount) : new DB2ResultSet(dB2Statement, dB2Statement.colCount);
        return dB2ResultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(52);
        String string = new String();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_TD_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_TD_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_TD_MAPPING[n2].bitMask)) {
                string = String.valueOf(string) + "," + DB2BaseConstants.SQL_FN_TD_MAPPING[n2].nameStr;
            }
            ++n2;
        }
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public ResultSet getTypeInfo() throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLGetTypeInfo(dB2Statement, 0);
        int[] nArray = new int[]{2};
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, 18);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return new DB2EmptyResultSet();
    }

    public String getURL() throws SQLException {
        return "jdbc:db2://" + this.connection.getSource();
    }

    public String getUserName() throws SQLException {
        return this.SQLGetStringInfo(47);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        this.SQLSpecialColumns(dB2Statement, 2, string, string2, string3, 0, 0);
        int[] nArray = new int[]{3};
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, dB2Statement.colCount);
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.SQLCompShort(114, 1);
    }

    private boolean isCatalogValid(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != '%') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return this.SQLGetBooleanInfo(25);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.SQLCompShort(22, 0);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.SQLCompShort(85, 4);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.SQLCompShort(85, 2);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return this.SQLCompShort(85, 0);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.SQLCompShort(85, 1);
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(28) == 2;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(93) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(28) == 4;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(93) == 4;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(28) == 1;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(93) == 1;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        String string = this.getDriverVersion();
        int n = new Integer(string.substring(0, 2));
        return n >= 3;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 2);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(92, 1);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 8);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 16);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(92, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 4);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.SQLGetBooleanInfo(87);
    }

    public boolean supportsConvert() throws SQLException {
        return this.SQLGetBooleanInfo(48, 1);
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -7: {
                n = 55;
                break;
            }
            case -6: {
                n = 68;
                break;
            }
            case 5: {
                n = 65;
                break;
            }
            case 4: {
                n = 61;
                break;
            }
            case -5: {
                n = 53;
                break;
            }
            case 6: {
                n = 60;
                break;
            }
            case 7: {
                n = 64;
                break;
            }
            case 8: {
                n = 59;
                break;
            }
            case 2: {
                n = 63;
                break;
            }
            case 3: {
                n = 58;
                break;
            }
            case 1: {
                n = 56;
                break;
            }
            case 12: {
                n = 70;
                break;
            }
            case -1: {
                n = 62;
                break;
            }
            case 91: {
                n = 57;
                break;
            }
            case 92: {
                n = 66;
                break;
            }
            case 93: {
                n = 67;
                break;
            }
            case -2: {
                n = 54;
                break;
            }
            case -3: {
                n = 69;
                break;
            }
            case -4: {
                n = 71;
                break;
            }
            default: {
                n = 0;
            }
        }
        switch (n2) {
            case -7: {
                n2 = 4096;
                break;
            }
            case -6: {
                n2 = 8192;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case -5: {
                n2 = 16384;
                break;
            }
            case 6: {
                n2 = 32;
                break;
            }
            case 7: {
                n2 = 64;
                break;
            }
            case 8: {
                n2 = 128;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 256;
                break;
            }
            case -1: {
                n2 = 512;
                break;
            }
            case 91: {
                n2 = 32768;
                break;
            }
            case 92: {
                n2 = 65536;
                break;
            }
            case 93: {
                n2 = 131072;
                break;
            }
            case -2: {
                n2 = 1024;
                break;
            }
            case -3: {
                n2 = 2048;
                break;
            }
            case -4: {
                n2 = 262144;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.SQLGetBooleanInfo(n, n2);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 1);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.SQLGetBooleanInfo(95, 16);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.SQLCompShort(46, 2);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.SQLCompShort(46, 1);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.SQLCompShort(74, 1);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.SQLGetBooleanInfo(27);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 2);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.SQLGetBooleanInfo(115, 4);
    }

    public boolean supportsGroupBy() throws SQLException {
        return this.SQLCompShort(88, 0) ^ true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.SQLCompShort(88, 2);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.SQLCompShort(88, 3);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.SQLGetBooleanInfo(73);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.SQLGetBooleanInfo(113);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        String string = this.SQLGetStringInfo(38);
        return string.equals("P") || string.equals("Y");
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 0);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(28) == 3;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.SQLGetShortInfo(93) == 3;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return this.SQLGetBooleanInfo(36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return this.SQLGetBooleanInfo(37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.SQLCompShort(75, 1);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.SQLCompShort(23, 2);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.SQLCompShort(24, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        short s = this.getShortInfo(23);
        return s == 2 || s == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        short s = this.getShortInfo(24);
        return s == 2 || s == 1;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.SQLGetBooleanInfo(90) ^ true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return this.SQLGetStringInfo(38).equals("N") ^ true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return this.SQLGetBooleanInfo(80, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 2);
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(91, 1);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 8);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 16);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(91, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 4);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 4);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.SQLGetBooleanInfo(21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.SQLGetBooleanInfo(95, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.SQLGetBooleanInfo(95, 4);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.SQLGetBooleanInfo(95, 8);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.SQLCompShort(74, 0) ^ true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return this.SQLGetBooleanInfo(72, n);
    }

    public boolean supportsTransactions() throws SQLException {
        return this.SQLCompShort(46, 0) ^ true;
    }

    public boolean supportsUnion() throws SQLException {
        return this.SQLGetBooleanInfo(96, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return this.SQLCompShort(84, 1);
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.SQLCompShort(84, 2);
    }
}

