/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DB2InputStream
extends InputStream {
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2Request db2req;
    protected int locator;
    protected long currentPosition;
    protected long docLength;
    protected int lobType;
    protected int marked;
    protected int maxFieldSize;
    protected boolean closed;
    protected boolean doConversion;
    protected int bufferPos;
    protected int bufferEnd;
    protected static final int defaultBufferSize = 32000;
    protected byte[] buffer;

    public DB2InputStream(DB2Statement dB2Statement, int n, int n2, boolean bl) throws SQLException {
        block5: {
            this.closed = false;
            this.doConversion = false;
            this.bufferPos = 0;
            this.bufferEnd = 0;
            this.buffer = null;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "DB2InputStream( stmt, " + n + ", " + n2 + ", " + bl + " )");
                }
                DB2Connection dB2Connection = dB2Statement.connection;
                this.sqlExcptGen = dB2Statement.sqlExcptGen;
                this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Statement.db2req) : new DB2RequestTrace(dB2Statement.db2req);
                this.statement = (DB2Statement)dB2Connection.createStatement();
                this.maxFieldSize = this.statement.maxFieldSize;
                this.locator = n;
                this.currentPosition = 1L;
                this.marked = 1;
                this.lobType = n2;
                this.doConversion = bl;
                this.docLength = this.SQLGetLength();
                if (this.maxFieldSize == 0 || (long)this.maxFieldSize >= this.docLength) break block5;
                this.docLength = this.maxFieldSize;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "docLength", (int)this.docLength);
                    DB2Trace.methodExit(this, "DB2InputStream()");
                }
                throw throwable;
            }
        }
        Object var6_6 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "docLength", (int)this.docLength);
            DB2Trace.methodExit(this, "DB2InputStream()");
        }
    }

    private int SQLGetLength() throws SQLException {
        int n = 0;
        try {
            this.db2req.write((short)51);
            this.db2req.write(this.statement.getHandle());
            this.db2req.write(this.locator);
            this.db2req.write(this.lobType);
            if (this.doConversion) {
                this.db2req.write((byte)1);
            } else {
                this.db2req.write((byte)0);
            }
            this.db2req.sendAndRecv();
            int n2 = this.db2req.readInt();
            if (n2 != 0 && n2 != 1) {
                this.sqlExcptGen.check_return_code(this.statement, n2);
            } else {
                n = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public int available() {
        int n = 0;
        if (this.buffer != null) {
            n = this.bufferEnd - this.bufferPos;
        }
        if (this.currentPosition <= this.docLength) {
            n += (int)(this.docLength - this.currentPosition + 1L);
        }
        return n;
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
            this.closed = true;
        }
    }

    public long getLength() throws SQLException {
        this.docLength = this.SQLGetLength();
        if (this.maxFieldSize != 0 && (long)this.maxFieldSize < this.docLength) {
            this.docLength = this.maxFieldSize;
        }
        return this.docLength;
    }

    public DB2Statement getStatement() {
        return this.statement;
    }

    protected boolean hasMore() {
        return this.currentPosition <= this.docLength;
    }

    public synchronized void mark(int n) {
        this.marked = n;
    }

    public boolean markSupported() {
        return true;
    }

    void moveTo(int n) {
        this.currentPosition = (long)n < this.docLength ? (long)n : this.docLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read() throws IOException {
        int n;
        int n2 = 0;
        try {
            byte[] byArray;
            int n3;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read()");
            }
            n2 = (n3 = this.read(byArray = new byte[1])) == -1 ? n3 : (byArray[0] < 0 ? byArray[0] + 256 : byArray[0]);
            n = n2;
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n2);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            if (this.available() == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "No more data available from the database");
                }
                n2 = -1;
            } else {
                int n3;
                int n4 = byArray.length;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "bytesToRead", n4);
                }
                if (this.buffer != null) {
                    n3 = this.bufferEnd - this.bufferPos;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "bytesAvailable", n3);
                    }
                    if (n3 != 0) {
                        if (n4 <= n3) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n4);
                            this.bufferPos += n4;
                            n2 = n4;
                            n4 = 0;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n3);
                            this.bufferPos += n3;
                            n2 = n3;
                            n4 -= n3;
                        }
                    }
                }
                if (n4 != 0) {
                    n3 = (int)Math.min(this.docLength - this.currentPosition + 1L, (long)Math.max(32000, n4));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "currentPosition", (int)this.currentPosition);
                        DB2Trace.data(30, "bytesToRead", n4);
                        DB2Trace.data(30, "bufferLength", n3);
                    }
                    int n5 = 0;
                    if (n3 != 0) {
                        try {
                            DB2Request dB2Request = this.db2req;
                            synchronized (dB2Request) {
                                this.db2req.write((short)52);
                                this.db2req.write(this.statement.getHandle());
                                this.db2req.write(n3);
                                this.db2req.write(this.locator);
                                this.db2req.write((int)this.currentPosition);
                                this.db2req.write(this.lobType);
                                if (this.doConversion) {
                                    this.db2req.write((byte)1);
                                } else {
                                    this.db2req.write((byte)0);
                                }
                                this.db2req.sendAndRecv();
                                int n6 = this.db2req.readInt();
                                if (n6 != 0 && n6 != 1) {
                                    this.sqlExcptGen.check_return_code(this.statement, n6);
                                }
                                n5 = this.db2req.readInt();
                                this.buffer = this.db2req.readBytes();
                                int n7 = this.db2req.readInt();
                                if (this.doConversion) {
                                    String string = new String(this.buffer, "UnicodeBig");
                                    this.buffer = string.getBytes("UTF8");
                                    n5 = this.buffer.length;
                                } else if (this.lobType == -351) {
                                    String string = new String(this.buffer, "UnicodeBig");
                                    this.buffer = string.getBytes();
                                    n5 = this.buffer.length;
                                }
                                this.currentPosition += (long)n7;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new IOException(sQLException.toString());
                        }
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(40, "bytesAvailable", n5);
                    }
                    this.bufferPos = 0;
                    this.bufferEnd = n5;
                    if (n5 != 0) {
                        if (n4 <= n5) {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
                            this.bufferPos += n4;
                            n2 += n4;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n5);
                            this.bufferPos += n5;
                            n2 += n5;
                        }
                    }
                }
            }
            n = n2;
            Object var5_13 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n2);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = -1;
        try {
            byte[] byArray2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b, " + n + ", " + n2 + " )");
            }
            if ((n4 = this.read(byArray2 = new byte[n2])) != -1) {
                System.arraycopy(byArray2, 0, byArray, n, n4);
            }
            n3 = n4;
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "read()", n4);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "read()", n4);
        return n3;
    }

    public synchronized void reset() {
        this.currentPosition = this.marked;
    }

    public synchronized long skip(long l) {
        if (this.buffer != null && l >= (long)(this.bufferEnd - this.bufferPos)) {
            this.buffer = null;
            l -= (long)(this.bufferEnd - this.bufferPos);
        }
        if (this.buffer == null) {
            if (this.currentPosition + (long)((int)l) > this.docLength) {
                this.currentPosition = this.docLength + 1L;
                l = this.docLength - this.currentPosition;
            } else {
                this.currentPosition += (long)((int)l);
            }
        }
        return l;
    }
}

