/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2CallableStatement;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2DataObject;
import COM.ibm.db2.jdbc.net.DB2RowObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DB2OutputParameters
extends DB2RowObject {
    private DB2CallableStatement cStmt;
    private short[] outParamIndex = null;

    public DB2OutputParameters(DB2CallableStatement dB2CallableStatement, int n, short[] sArray, int[] nArray) throws SQLException {
        this.connection = dB2CallableStatement.connection;
        this.cStmt = dB2CallableStatement;
        this.statement = dB2CallableStatement;
        this.db2req = dB2CallableStatement.db2req;
        this.sqlExcptGen = dB2CallableStatement.sqlExcptGen;
        this.length = 0;
        if (this.outParamIndex == null || this.outParamIndex.length < n) {
            this.outParamIndex = new short[n];
        }
        this.sqltype = new short[n];
        this.sqlind = new int[n];
        this.sqldata = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            if (sArray[n2] == 4 || sArray[n2] == 2) {
                this.outParamIndex[n2] = (short)this.length;
                this.sqltype[this.length] = (short)nArray[n2];
                ++this.length;
            } else {
                this.outParamIndex[n2] = -1;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.length) {
            switch (this.sqltype[n3]) {
                case 5: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
                case 4: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
                case -5: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
                case 91: {
                    this.sqldata[n3] = new Date(0L);
                    break;
                }
                case 92: {
                    this.sqldata[n3] = new Time(0L);
                    break;
                }
                case 93: {
                    this.sqldata[n3] = new Timestamp(0L);
                    break;
                }
                case 6: 
                case 8: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
                case 7: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
                case -351: 
                case -350: 
                case -99: 
                case -98: 
                case 31: 
                case 41: {
                    this.sqldata[n3] = new DB2DataObject();
                    break;
                }
            }
            ++n3;
        }
        try {
            this.getDataFromBuffer();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    protected BigDecimal getBigDecimal(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getBigDecimal(s);
    }

    protected DB2Blob getBlob(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getBlob(s);
    }

    protected boolean getBoolean(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getBoolean(s);
    }

    protected byte getByte(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getByte(s);
    }

    protected byte[] getBytes(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getBytes(s);
    }

    protected DB2Clob getClob(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getClob(s);
    }

    protected Date getDate(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getDate(s);
    }

    protected double getDouble(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getDouble(s);
    }

    protected float getFloat(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getFloat(s);
    }

    protected int getInt(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getInt(s);
    }

    protected long getLong(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getLong(s);
    }

    protected Object getObject(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getObject(s);
    }

    protected short getShort(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getShort(s);
    }

    protected String getString(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getString(s);
    }

    protected Time getTime(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getTime(s);
    }

    protected Timestamp getTimestamp(int n) throws SQLException {
        short s = this.outParamIndex[n];
        this.cStmt.wasNull = this.sqlind[s] == this.SQL_NULL_DATA;
        return super.getTimestamp(s);
    }
}

