/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Blob;
import COM.ibm.db2.jdbc.net.DB2Clob;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement {
    protected String sql = null;
    protected int maxNumParams = 0;
    protected short[] direction;
    protected int[] sqltypes = null;
    protected int[] ctypes = null;
    protected int[] maxWholeDigits;
    protected int[] scales;
    protected boolean[] sameType = null;
    protected boolean[] wasBound = null;
    protected ParamElement[] paramRow = null;
    protected Vector paramSet = null;
    protected int[] maxParamLength = null;
    protected static final int BUFLEN = 32699;
    protected static final int MAXCHAR = 254;
    protected static final int MAXVCHAR = 4000;
    protected boolean executed = false;

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        int n3;
        this.connection = dB2Connection;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        this.checkResultSetType(n, n2);
        this.rsType = n;
        this.rsConcur = n2;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        this.sql = this.check4JSQL(string);
        try {
            this.db2req.write((short)61);
            this.db2req.write(this.sql);
            this.db2req.write((short)this.rsType);
            this.db2req.sendAndRecv();
            n3 = this.db2req.readInt();
            if (n3 != this.SQL_SUCCESS) {
                try {
                    this.statementHandle = this.db2req.readInt();
                }
                catch (IOException iOException) {}
                this.sqlExcptGen.check_return_code(this, n3);
            }
            this.statementHandle = this.db2req.readInt();
            this.maxNumParams = this.db2req.readInt();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.direction = new short[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.sameType = new boolean[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.paramSet = new Vector();
        this.paramRow = new ParamElement[this.maxNumParams];
        this.maxParamLength = new int[this.maxNumParams];
        n3 = 0;
        while (n3 < this.maxNumParams) {
            this.direction[n3] = 0;
            this.sqltypes[n3] = 0;
            this.ctypes[n3] = 0;
            this.maxWholeDigits[n3] = 0;
            this.scales[n3] = 0;
            this.sameType[n3] = false;
            this.wasBound[n3] = false;
            this.paramRow[n3] = new ParamElement();
            this.maxParamLength[n3] = 0;
            ++n3;
        }
    }

    public void addBatch() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "addBatch()");
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.paramSet.addElement(this.paramRow);
        ParamElement[] paramElementArray = new ParamElement[this.maxNumParams];
        int n = 0;
        while (n < this.maxNumParams) {
            if (this.maxParamLength[n] < this.paramRow[n].getLength()) {
                this.maxParamLength[n] = this.paramRow[n].getLength();
            }
            paramElementArray[n] = new ParamElement();
            ++n;
        }
        this.paramRow = paramElementArray;
        ++this.batchSize;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "addBatch()");
        }
    }

    private String check4JSQL(String string) throws SQLException {
        if (string.startsWith("#")) {
            int n;
            int n2;
            int n3;
            int n4;
            this.isJSQL = true;
            String string2 = string.substring(string.indexOf("{"));
            int n5 = string.indexOf(",");
            int n6 = Integer.parseInt(string.substring(1, n5));
            if (n6 > 0) {
                int[] nArray = new int[n6];
                n4 = 0;
                ++n5;
                n3 = 0;
                while (n3 < n6) {
                    n4 = string.indexOf(",", n5);
                    nArray[n3] = Integer.parseInt(string.substring(n5, n4));
                    n5 = n4 + 1;
                    ++n3;
                }
                this.colCount4JSQL = n6;
                this.colNames4JSQL = new String[n6];
                n2 = 0;
                while (n2 < n6) {
                    n4 = n5 + nArray[n2];
                    this.colNames4JSQL[n2] = new String(string.substring(n5, n4));
                    n5 = n4;
                    ++n2;
                }
            }
            if ((n4 = Integer.parseInt(string.substring(++n5, n = string.indexOf(",", n5)))) > 0) {
                n5 = n + 1;
                n = string.indexOf(",", n5);
                n3 = Integer.parseInt(string.substring(n5, n));
                n5 = n + 1;
                n = string.indexOf(",", n5);
                n2 = Integer.parseInt(string.substring(n5, n));
                String string3 = string2.substring(n3, n2);
                n5 = n + 1;
                n = n5 + n4;
                String string4 = String.valueOf(new String(string.substring(n5, n))) + "," + string3;
                this.setCursorName(string4);
            }
            return string2;
        }
        return string;
    }

    public void clearBatch() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "clearBatch()");
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.batchSize = 0;
        this.paramSet = new Vector();
        int n = 0;
        while (n < this.maxNumParams) {
            this.paramRow[n].unset();
            this.maxParamLength[n] = 0;
            ++n;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "clearBatch()");
        }
    }

    public synchronized void clearParameters() throws SQLException {
        block8: {
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            this.paramSet = new Vector();
            int n = 0;
            while (n < this.maxNumParams) {
                this.direction[n] = 0;
                this.sqltypes[n] = 0;
                this.ctypes[n] = 0;
                this.maxWholeDigits[n] = 0;
                this.scales[n] = 0;
                this.sameType[n] = false;
                this.wasBound[n] = false;
                this.paramRow[n].unset();
                this.maxParamLength[n] = 0;
                ++n;
            }
            if (!this.executed) break block8;
            try {
                int n2;
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)77);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                }
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
                this.executed = false;
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
        }
    }

    protected int convert2SQLType(int n) {
        int n2 = n;
        switch (n2) {
            case -7: 
            case -6: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case 2004: {
                n2 = -98;
                break;
            }
            case 2005: {
                n2 = -99;
                break;
            }
        }
        return n2;
    }

    public boolean execute() throws SQLException {
        int n = this.execute2();
        if (n == 100) {
            this.rowCount = 0;
        } else if (n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        return this.colCount > 0;
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n = 0;
        this.warnings = null;
        this.moreResults = true;
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)79);
                this.db2req.write(this.statementHandle);
                this.paramToServer();
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                this.executed = true;
                if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readInt();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n);
                    this.getCounts();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                    n = this.SQL_SUCCESS;
                }
            }
            if (n == 99 && (n = this.loadParameters()) == this.SQL_SUCCESS) {
                this.getCounts();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        block71: {
            block69: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "executeBatch()");
                    }
                    if (this.connection.closed) {
                        SQLExceptionGenerator.throwConnectionClosedError();
                    }
                    this.batchReturn = new int[this.batchSize];
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                    if (this.batchSize == 0) {
                        var1_1 = this.batchReturn;
                        var3_4 = null;
                        if (DB2Trace.TraceOn == false) return var1_1;
                        break block69;
                    }
                    var4_8 = 0;
                    while (true) {
                        if (var4_8 >= this.batchSize) {
                            if (!DB2PreparedStatement.isQuery(this.sql)) break;
                            throw new BatchUpdateException(SQLExceptionGenerator.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn);
                        }
                        this.batchReturn[var4_8] = -3;
                        ++var4_8;
                    }
                    var5_9 = new ParamElement[this.batchSize][this.maxNumParams];
                    var6_10 = 0;
                    var7_11 = this.paramSet.elements();
                    while (true) {
                        block72: {
                            if (var7_11.hasMoreElements()) break block72;
                            var8_12 = null;
                            var9_13 = 0;
                            try {
                                var10_14 = this.db2req;
                                synchronized (var10_14) {
                                    block73: {
                                        this.db2req.write((short)202);
                                        this.db2req.write(this.statementHandle);
                                        this.db2req.write((short)this.batchSize);
                                        if (this.batchSize <= 0) break block73;
                                        var6_10 = 0;
                                        while (var6_10 < this.maxNumParams) {
                                            this.db2req.write((short)this.ctypes[var6_10]);
                                            this.db2req.write((short)this.sqltypes[var6_10]);
                                            if (this.sqltypes[var6_10] == 2 || this.sqltypes[var6_10] == 3) {
                                                this.db2req.write(this.maxWholeDigits[var6_10] + this.scales[var6_10]);
                                                this.db2req.write((short)this.scales[var6_10]);
                                            }
                                            this.db2req.write(this.maxParamLength[var6_10]);
                                            switch (this.ctypes[var6_10]) {
                                                case -25: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                this.db2req.write(((PrimitiveData)var8_12).longValue());
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 4: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                this.db2req.write(((PrimitiveData)var8_12).intValue());
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case -7: 
                                                case -6: 
                                                case 5: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                this.db2req.write(((PrimitiveData)var8_12).shortValue());
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 7: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                this.db2req.write(((PrimitiveData)var8_12).floatValue());
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 6: 
                                                case 8: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                this.db2req.write(((PrimitiveData)var8_12).doubleValue());
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case -8: 
                                                case 1: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) ** GOTO lbl115
                                                        var8_12 = var5_9[var12_17][var6_10].getValue();
                                                        if (var8_12 == null) ** GOTO lbl114
                                                        if (var5_9[var12_17][var6_10].isStream()) {
                                                            this.db2req.write(-2);
                                                        } else {
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            this.db2req.write((String)var8_12);
                                                        }
                                                        ** GOTO lbl115
lbl114:
                                                        // 1 sources

                                                        this.db2req.write(var5_9[var12_17][var6_10].getLength());
lbl115:
                                                        // 4 sources

                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case -2: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (var8_12 != null) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            if (var5_9[var12_17][var6_10].isStream()) {
                                                                this.db2req.write(-2);
                                                            } else {
                                                                this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                                this.db2req.write((byte[])var8_12);
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 91: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                var13_18 = (int[])var8_12;
                                                                this.db2req.write(var13_18[0]);
                                                                this.db2req.write(var13_18[1]);
                                                                this.db2req.write(var13_18[2]);
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 92: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                var13_18 = (int[])var8_12;
                                                                this.db2req.write(var13_18[0]);
                                                                this.db2req.write(var13_18[1]);
                                                                this.db2req.write(var13_18[2]);
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                case 93: {
                                                    var12_17 = 0;
                                                    while (var12_17 < this.batchSize) {
                                                        if (!this.isElementNull(var5_9[var12_17][var6_10], var12_17, var6_10)) {
                                                            var8_12 = var5_9[var12_17][var6_10].getValue();
                                                            this.db2req.write(var5_9[var12_17][var6_10].getLength());
                                                            if (var8_12 != null) {
                                                                var13_18 = (int[])var8_12;
                                                                var14_19 = 0;
                                                                while (var14_19 < 7) {
                                                                    this.db2req.write(var13_18[var14_19]);
                                                                    ++var14_19;
                                                                }
                                                            }
                                                        }
                                                        ++var12_17;
                                                    }
                                                    break;
                                                }
                                                default: {
                                                    this.isElementNull(var5_9[0][var6_10], 0, var6_10);
                                                    break;
                                                }
                                            }
                                            ++var6_10;
                                        }
                                    }
                                    this.db2req.sendAndRecv();
                                    var9_13 = this.db2req.readInt();
                                    var6_10 = 0;
                                    while (true) {
                                        if (var6_10 >= this.batchSize) {
                                            break;
                                        }
                                        this.batchReturn[var6_10] = this.db2req.readInt();
                                        ++var6_10;
                                    }
                                }
                                var10_15 = 0;
                                while (true) {
                                    if (var10_15 >= this.batchReturn.length) {
                                        this.clearBatch();
                                        this.sqlExcptGen.check_batch_return_code(this, var9_13);
                                        var1_2 = this.batchReturn;
                                        break block71;
                                    }
                                    switch (this.batchReturn[var10_15]) {
                                        case 0: 
                                        case 6: {
                                            this.batchReturn[var10_15] = -2;
                                            break;
                                        }
                                        case 5: {
                                            this.batchReturn[var10_15] = -3;
                                            break;
                                        }
                                        case 7: {
                                            this.batchReturn[var10_15] = 0;
                                            break;
                                        }
                                    }
                                    ++var10_15;
                                }
                            }
                            catch (IOException var10_16) {
                                var10_16.printStackTrace();
                                this.sqlExcptGen.socketException("08S01a");
                                var1_3 = null;
                                var3_6 = null;
                                if (DB2Trace.TraceOn == false) return var1_3;
                                DB2Trace.methodExit(this, "executeBatch()");
                                return var1_3;
                            }
                        }
                        var5_9[var6_10++] = (ParamElement[])var7_11.nextElement();
                    }
                }
                catch (Throwable var2_20) {
                    var3_7 = null;
                    if (DB2Trace.TraceOn == false) throw var2_20;
                    DB2Trace.methodExit(this, "executeBatch()");
                    throw var2_20;
                }
            }
            DB2Trace.methodExit(this, "executeBatch()");
            return var1_1;
        }
        var3_5 = null;
        if (DB2Trace.TraceOn == false) return var1_2;
        DB2Trace.methodExit(this, "executeBatch()");
        return var1_2;
    }

    public ResultSet executeQuery() throws SQLException {
        int n = this.execute2();
        if (n != 100 && n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n = this.execute2();
        if (n == 100) {
            this.rowCount = 0;
        } else if (n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        return this.getUpdateCount();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.resultSet == null) {
            this.resultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount);
        }
        return this.resultSet.getMetaData();
    }

    protected final boolean isElementNull(ParamElement paramElement, int n, int n2) throws SQLException {
        if (!paramElement.isSet()) {
            this.db2req = new DB2Request(this.connection);
            this.sqlExcptGen.throwNotSet(n, n2, this.batchReturn);
        }
        return false;
    }

    private static boolean isQuery(String string) {
        return string.trim().substring(0, 6).equalsIgnoreCase("select");
    }

    protected int loadParameters() throws SQLException {
        int n = -1;
        int n2 = 99;
        try {
            while (n2 == 99) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)76);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                    if (n2 != this.SQL_SUCCESS && n2 != this.SQL_SUCCESS_WITH_INFO && n2 != 99) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    if (n2 == 99) {
                        int n3;
                        Closeable closeable;
                        n = this.db2req.readInt();
                        int n4 = n - 1;
                        int n5 = this.paramRow[n4].getLength();
                        if (this.maxFieldSize != 0) {
                            n5 = Math.min(n5, this.maxFieldSize);
                        }
                        if (!this.paramRow[n4].doConversion()) {
                            closeable = (InputStream)this.paramRow[n4].getValue();
                            byte[] byArray = new byte[Math.min(32699, n5)];
                            while ((n3 = ((InputStream)closeable).read(byArray, 0, Math.min(32699, n5))) != -1 && n5 != 0) {
                                n5 -= n3;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                if (this.sqltypes[n4] == -99) {
                                    this.db2req.write((short)1);
                                } else {
                                    this.db2req.write((short)0);
                                }
                                this.db2req.write(byArray, n3);
                                this.db2req.sendAndRecv();
                                int n6 = this.db2req.readInt();
                                if (n6 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n6);
                            }
                        } else {
                            int n7;
                            closeable = new BufferedReader((Reader)this.paramRow[n4].getValue());
                            int n8 = this.paramRow[n4].getLength();
                            n3 = Math.min(16349, n8);
                            char[] cArray = new char[n3];
                            while ((n7 = ((BufferedReader)closeable).read(cArray, 0, n3)) != -1 && n8 != 0) {
                                n3 = Math.min(16349, n8 -= n7);
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)1);
                                this.db2req.write(new String(cArray, 0, n7));
                                this.db2req.sendAndRecv();
                                int n9 = this.db2req.readInt();
                                if (n9 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n9);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    protected void paramToServer() throws IOException, SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "paramToServer()");
        }
        var1_1 = 0;
        while (var1_1 < this.maxNumParams) {
            this.db2req.write(this.direction[var1_1]);
            if (this.direction[var1_1] != 0) {
                this.db2req.write((short)this.ctypes[var1_1]);
                this.db2req.write((short)this.sqltypes[var1_1]);
                if (this.sqltypes[var1_1] == 2) {
                    this.db2req.write(this.maxWholeDigits[var1_1] + this.scales[var1_1]);
                    this.db2req.write((short)this.scales[var1_1]);
                }
                this.db2req.write((short)(this.wasBound[var1_1] != false));
                if (this.paramRow[var1_1].isSet()) {
                    if (this.direction[var1_1] != 4) {
                        if (this.paramRow[var1_1].isStream()) {
                            this.db2req.write(-2);
                        } else {
                            this.db2req.write(this.paramRow[var1_1].getLength());
                        }
                        if (this.paramRow[var1_1].getLength() != -1) {
                            switch (this.ctypes[var1_1]) {
                                case 5: {
                                    this.db2req.write(((PrimitiveData)this.paramRow[var1_1].getValue()).shortValue());
                                    ** break;
                                }
                                case 4: {
                                    this.db2req.write(((PrimitiveData)this.paramRow[var1_1].getValue()).intValue());
                                    ** break;
                                }
                                case -25: {
                                    this.db2req.write(((PrimitiveData)this.paramRow[var1_1].getValue()).longValue());
                                    ** break;
                                }
                                case 7: {
                                    this.db2req.write(((PrimitiveData)this.paramRow[var1_1].getValue()).floatValue());
                                    ** break;
                                }
                                case 6: 
                                case 8: {
                                    this.db2req.write(((PrimitiveData)this.paramRow[var1_1].getValue()).doubleValue());
                                    ** break;
                                }
                                case 91: {
                                    var2_2 = (int[])this.paramRow[var1_1].getValue();
                                    this.db2req.write((short)var2_2[0]);
                                    this.db2req.write((short)var2_2[1]);
                                    this.db2req.write((short)var2_2[2]);
                                    ** break;
                                }
                                case 92: {
                                    var3_3 = (int[])this.paramRow[var1_1].getValue();
                                    this.db2req.write((short)var3_3[0]);
                                    this.db2req.write((short)var3_3[1]);
                                    this.db2req.write((short)var3_3[2]);
                                    ** break;
                                }
                                case 93: {
                                    var4_4 = (int[])this.paramRow[var1_1].getValue();
                                    this.db2req.write((short)var4_4[0]);
                                    this.db2req.write((short)var4_4[1]);
                                    this.db2req.write((short)var4_4[2]);
                                    this.db2req.write((short)var4_4[3]);
                                    this.db2req.write((short)var4_4[4]);
                                    this.db2req.write((short)var4_4[5]);
                                    this.db2req.write(var4_4[6]);
                                    ** break;
                                }
                                case 2: 
                                case 3: {
                                    this.db2req.write(this.paramRow[var1_1].getValue().toString());
                                    ** break;
                                }
                                case -8: 
                                case 1: {
                                    if (this.paramRow[var1_1].isStream()) ** break;
                                    this.db2req.write((String)this.paramRow[var1_1].getValue());
                                    ** break;
                                }
                                case -2: {
                                    if (this.paramRow[var1_1].isStream()) ** break;
                                    this.db2req.write((byte[])this.paramRow[var1_1].getValue());
                                    ** break;
                                }
                                case -351: 
                                case 41: {
                                    var5_5 = (DB2Clob)this.paramRow[var1_1].getValue();
                                    this.db2req.write(var5_5.getLocator());
                                    ** break;
                                }
                                case 31: {
                                    var6_6 = (DB2Blob)this.paramRow[var1_1].getValue();
                                    this.db2req.write(var6_6.getLocator());
                                    ** break;
                                }
                                default: {
                                    this.sqlExcptGen.pstmtException("S1003");
                                    ** break;
                                }
                            }
                        }
                    } else lbl-1000:
                    // 17 sources

                    {
                        this.wasBound[var1_1] = true;
                    }
                }
            }
            ++var1_1;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "paramToServer()");
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 1);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setBigDecimal(n, bigDecimal, 2);
    }

    protected void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = n - 1;
        if (bigDecimal == null) {
            this.setNull(n, n2);
            this.maxWholeDigits[n3] = 31;
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8);
        this.setPrecisionAndScale(n3, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (n2 == 0) {
            byte[] byArray = new byte[]{};
            this.setBytes(n, byArray);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -3;
        this.sameType[n - 1] = this.setDirection(n, n3, -2);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBlob(n, blob, -98);
    }

    public void setBlob(int n, Blob blob, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (blob == null) {
            this.setNull(n, -3);
            return;
        }
        int n3 = (int)blob.length();
        if (n3 == 0) {
            byte[] byArray = new byte[]{};
            this.setBytes(n, byArray);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (blob instanceof DB2Blob) {
            DB2Blob dB2Blob = (DB2Blob)blob;
            this.sameType[n - 1] = this.setDirection(n, n2, 31);
            this.paramRow[n - 1].set(n3, dB2Blob, false, false);
        } else {
            this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setBoolean(n, bl, 5);
    }

    protected void setBoolean(int n, boolean bl, int n2) throws SQLException {
        if (bl) {
            this.setShort(n, (short)1, n2);
        } else {
            this.setShort(n, (short)0, n2);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setByte(n, by, 5);
    }

    protected void setByte(int n, byte by, int n2) throws SQLException {
        this.setShort(n, by, n2);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        int n3 = (n2 = byArray.length) < 4001 ? -3 : -4;
        this.setBytes(n, byArray, n3);
    }

    protected void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        switch (n2) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.sqlExcptGen.pstmtException("22003");
                break;
            }
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -2);
        this.paramRow[n - 1].set(byArray.length, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        block7: {
            block6: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setCharacterStream( " + n + ", " + "reader, " + n2 + " )");
                    }
                    if (this.connection.closed) {
                        SQLExceptionGenerator.throwConnectionClosedError();
                    }
                    if (reader == null) {
                        this.setNull(n, 12);
                        Object var5_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block6;
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    int n3 = -1;
                    this.sameType[n - 1] = this.setDirection(n, n3, -8);
                    this.paramRow[n - 1].set(n2, reader, true, true);
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setCharacterStream()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setCharacterStream()");
            return;
        }
        Object var5_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setCharacterStream()");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setClob(n, clob, -99);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClob(int n, Clob clob, int n2) throws SQLException {
        block11: {
            block10: {
                block9: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setClob( " + n + ", Clob, " + n2 + " )");
                        }
                        if (this.connection.closed) {
                            SQLExceptionGenerator.throwConnectionClosedError();
                        }
                        if (clob == null) {
                            this.setNull(n, 12);
                            Object var5_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block9;
                        }
                        int n3 = (int)clob.length();
                        if (n3 == 0) {
                            String string = new String();
                            this.setString(n, string);
                            break block10;
                        }
                        if (n < 1 || n > this.maxNumParams) {
                            this.sqlExcptGen.throwParamIndexError();
                        }
                        if (clob instanceof DB2Clob) {
                            DB2Clob dB2Clob = (DB2Clob)clob;
                            n2 = dB2Clob.lobType == 41 ? -99 : -350;
                            this.sameType[n - 1] = this.setDirection(n, n2, dB2Clob.lobType);
                            this.paramRow[n - 1].set(n3, dB2Clob, false, true);
                            break block11;
                        } else {
                            this.setCharacterStream(n, clob.getCharacterStream(), (int)clob.length());
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setClob()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setClob()");
                return;
            }
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setClob()");
            return;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setClob()");
    }

    public void setDate(int n, Date date) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setDate(n, date, 91);
    }

    protected void setDate(int n, Date date, int n2) throws SQLException {
        if (date == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 91);
        int[] nArray = new int[]{date.getYear() + 1900, date.getMonth() + 1, date.getDate()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    protected boolean setDirection(int n, int n2, int n3) {
        return this.setDirection(n, n2, n3, -1);
    }

    protected boolean setDirection(int n, int n2, int n3, int n4) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setDirection( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
        }
        int n5 = n - 1;
        boolean bl = true;
        if (this.direction[n5] == 4) {
            this.direction[n5] = 2;
            bl = false;
        } else if (this.direction[n5] == 0) {
            this.direction[n5] = 1;
            bl = false;
        }
        if (this.sqltypes[n5] == 0) {
            this.sqltypes[n5] = n2;
            bl = false;
        }
        if ((this.sqltypes[n5] == 3 || this.sqltypes[n5] == 2) && n4 != -1 && n4 != this.scales[n5]) {
            this.scales[n5] = n4;
            bl = false;
        }
        if (this.ctypes[n5] != n3) {
            this.ctypes[n5] = n3;
            bl = false;
        }
        if (!bl) {
            this.wasBound[n5] = false;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setDirection()", bl);
        }
        return bl;
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setDouble(n, d, 8);
    }

    protected void setDouble(int n, double d, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 8);
        this.paramRow[n - 1].set(0, d);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setFloat(n, f, 7);
    }

    protected void setFloat(int n, float f, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 7);
        this.paramRow[n - 1].set(0, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setInt(n, n2, 4);
    }

    protected void setInt(int n, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 4);
        this.paramRow[n - 1].set(0, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setLong(n, l, -5);
    }

    protected void setLong(int n, long l, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        n2 = -5;
        this.sameType[n - 1] = this.setDirection(n, n2, -25);
        if (n2 == -5) {
            this.paramRow[n - 1].set(0, l);
        } else {
            this.paramRow[n - 1].set(0, (int)l);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (n2 == 0) {
            this.sqlExcptGen.pstmtException("S1003");
        }
        int n3 = this.convert2SQLType(n2);
        int n4 = this.sqlType2cType(n3);
        this.sameType[n - 1] = this.setDirection(n, n3, n4);
        this.paramRow[n - 1].set(-1, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setNull()");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block42: {
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (object == null) {
                this.setNull(n, n2);
                return;
            }
            if (n2 == 0) {
                try {
                    if (object instanceof String) {
                        this.setString(n, (String)object);
                        break block42;
                    }
                    if (object instanceof Character) {
                        this.setString(n, ((Character)object).toString());
                        break block42;
                    }
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                        this.setBigDecimal(n, bigDecimal);
                        break block42;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n, (Boolean)object);
                        break block42;
                    }
                    if (object instanceof Short) {
                        this.setShort(n, (Short)object);
                        break block42;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n, (Integer)object);
                        break block42;
                    }
                    if (object instanceof Long) {
                        this.setLong(n, (Long)object);
                        break block42;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n, ((Float)object).floatValue());
                        break block42;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n, (Double)object);
                        break block42;
                    }
                    if (object instanceof byte[]) {
                        this.setBytes(n, (byte[])object);
                        break block42;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object);
                        break block42;
                    }
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object);
                        break block42;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object);
                        break block42;
                    }
                    if (object instanceof Blob) {
                        this.setBlob(n, (Blob)object);
                        break block42;
                    }
                    if (object instanceof Clob) {
                        this.setClob(n, (Clob)object);
                        break block42;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            } else {
                n2 = this.convert2SQLType(n2);
                try {
                    if (object instanceof String) {
                        if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                            this.setString(n, DB2PreparedStatement.translateFloat((String)object), n2, n3);
                        } else {
                            this.setString(n, (String)object, n2);
                        }
                        break block42;
                    }
                    if (object instanceof Character) {
                        if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                            this.setString(n, DB2PreparedStatement.translateFloat(((Character)object).toString()), n2, n3);
                        } else {
                            this.setString(n, ((Character)object).toString(), n2);
                        }
                        break block42;
                    }
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                        this.setBigDecimal(n, bigDecimal, n2);
                        break block42;
                    }
                    if (object instanceof Boolean) {
                        this.setBoolean(n, (Boolean)object, n2);
                        break block42;
                    }
                    if (object instanceof Short) {
                        this.setShort(n, (Short)object, n2);
                        break block42;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n, (Integer)object, n2);
                        break block42;
                    }
                    if (object instanceof Long) {
                        this.setLong(n, (Long)object, n2);
                        break block42;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n, ((Float)object).floatValue(), n2);
                        break block42;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n, (Double)object, n2);
                        break block42;
                    }
                    if (object instanceof byte[]) {
                        this.setBytes(n, (byte[])object, n2);
                        break block42;
                    }
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object, n2);
                        break block42;
                    }
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object, n2);
                        break block42;
                    }
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object, n2);
                        break block42;
                    }
                    if (object instanceof Blob) {
                        this.setBlob(n, (Blob)object, n2);
                        break block42;
                    }
                    if (object instanceof Clob) {
                        this.setClob(n, (Clob)object, n2);
                        break block42;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException classCastException) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            }
        }
    }

    protected void setPrecisionAndScale(int n, BigDecimal bigDecimal) {
        String string = bigDecimal.abs().toString();
        int n2 = 0;
        int n3 = string.length();
        if (string.indexOf(46) != -1) {
            n2 = 1;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!string.startsWith("0", n4)) break;
            ++n2;
            ++n4;
        }
        int n5 = bigDecimal.scale();
        int n6 = n3 - n2;
        int n7 = (n6 = Math.max(n6, 1)) - n5;
        if (n7 > this.maxWholeDigits[n]) {
            this.maxWholeDigits[n] = n7;
        }
        if (n5 > this.scales[n]) {
            this.scales[n] = n5;
        } else {
            n6 += this.scales[n] - n5;
        }
        this.paramRow[n].set(n6, bigDecimal.toString());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array type");
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setShort(n, s, 5);
    }

    protected void setShort(int n, short s, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 5);
        this.paramRow[n - 1].set(0, s);
    }

    public void setString(int n, String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        int n2 = string.length() < 4000 ? 12 : -1;
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8, n3);
        int n4 = string.length();
        this.paramRow[n - 1].set(n4, string);
        if (n3 <= 0) {
            if (n4 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n4;
            }
        } else {
            int n5 = n4 - n3;
            if (n5 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n5;
            }
        }
    }

    protected void setTargetType(int n, int n2, String string) throws SQLException {
        try {
            switch (n2) {
                case 5: {
                    this.setShort(n, Short.parseShort(string));
                    break;
                }
                case 4: {
                    this.setInt(n, Integer.parseInt(string));
                    break;
                }
                case -5: {
                    this.setLong(n, Long.parseLong(string));
                    break;
                }
                case 6: 
                case 8: {
                    this.setDouble(n, Double.valueOf(DB2PreparedStatement.translateFloat(string)));
                    break;
                }
                case 7: {
                    this.setFloat(n, Float.valueOf(DB2PreparedStatement.translateFloat(string)).floatValue());
                    break;
                }
                case 91: {
                    this.setDate(n, Date.valueOf(string));
                    break;
                }
                case 92: {
                    this.setTime(n, Time.valueOf(string));
                    break;
                }
                case 93: {
                    this.setTimestamp(n, Timestamp.valueOf(string));
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal(DB2PreparedStatement.translateFloat(string)));
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -1: 
                case 1: 
                case 12: {
                    this.setString(n, string);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    int n3 = string.length();
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = (byte)string.charAt(n4);
                        ++n4;
                    }
                    this.setBytes(n, byArray);
                    break;
                }
                case -350: 
                case -99: {
                    this.setString(n, string);
                    break;
                }
                case -98: {
                    int n5 = string.length();
                    byte[] byArray = new byte[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        byArray[n6] = (byte)string.charAt(n6);
                        ++n6;
                    }
                    this.setBytes(n, byArray, -98);
                    break;
                }
                default: {
                    this.sqlExcptGen.pstmtException("S1003");
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.sqlExcptGen.pstmtException("S1003");
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setTime(n, time, 92);
    }

    protected void setTime(int n, Time time, int n2) throws SQLException {
        if (time == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 92);
        int[] nArray = new int[]{time.getHours(), time.getMinutes(), time.getSeconds()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, 92, 92);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(time);
        int[] nArray = new int[3];
        int[] nArray2 = this.connection.getTimeZoneOffset();
        calendar2.add(11, nArray2[0]);
        calendar2.add(12, nArray2[1]);
        calendar2.add(13, nArray2[2]);
        nArray[0] = calendar2.get(11);
        nArray[1] = calendar2.get(12);
        nArray[2] = calendar2.get(13);
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        this.setTimestamp(n, timestamp, 93);
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 93);
        int[] nArray = new int[]{timestamp.getYear() + 1900, timestamp.getMonth() + 1, timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos()};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, 93, 93);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(timestamp);
        int[] nArray = this.connection.getTimeZoneOffset();
        calendar2.add(11, nArray[0]);
        calendar2.add(12, nArray[1]);
        calendar2.add(13, nArray[2]);
        int[] nArray2 = new int[]{calendar2.get(1), calendar2.get(2) + 1, calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13), timestamp.getNanos()};
        this.paramRow[n - 1].set(0, nArray2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, -8);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.paramRow[n - 1].set(n2 / 2, inputStreamReader, true, true);
    }

    protected int sqlType2cType(int n) {
        int n2;
        switch (n) {
            case -5: {
                n2 = -25;
                break;
            }
            case -98: 
            case -4: 
            case -3: {
                n2 = -2;
                break;
            }
            case -99: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                n2 = -8;
                break;
            }
            case 2004: {
                n2 = 31;
                break;
            }
            case 2005: {
                n2 = 41;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    private static String translateFloat(String string) {
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        if (c != '.') {
            return string.replace(c, '.');
        }
        return string;
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public double doubleValue() {
            return this.doubleVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public void set(double d) {
            this.doubleVal = d;
        }

        public void set(float f) {
            this.floatVal = f;
        }

        public void set(int n) {
            this.intVal = n;
        }

        public void set(long l) {
            this.longVal = l;
        }

        public void set(short s) {
            this.shortVal = s;
        }

        public short shortValue() {
            return this.shortVal;
        }
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
        }

        public ParamElement(int n, Object object) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n, Object object, boolean bl, boolean bl2) {
            this(n, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public void set(int n, double d) {
            this.primitiveData.set(d);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, float f) {
            this.primitiveData.set(f);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, int n2) {
            this.primitiveData.set(n2);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, long l) {
            this.primitiveData.set(l);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, Object object) {
            this.set(n, object, false, false);
        }

        public void set(int n, Object object, boolean bl, boolean bl2) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void set(int n, short s) {
            this.primitiveData.set(s);
            this.set(n, this.primitiveData, false, false);
        }

        public void unset() {
            this.fSet = false;
        }
    }
}

